/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.SourceProperty;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Sensitivity;
import javax.swing.table.AbstractTableModel;

public class SourcePropertiesTableModel
extends AbstractTableModel {
    private FieldSource fieldSource = null;

    public SourcePropertiesTableModel(FieldSource fieldSource) {
        this.setFieldSource(fieldSource);
    }

    private ColumnDescriptor getColumnDescriptor(int n) {
        return ColumnDescriptor.getColumnDescriptor(n);
    }

    @Override
    public int getRowCount() {
        FieldSource fieldSource = this.getFieldSource();
        int n = fieldSource != null ? fieldSource.getSourcePropertyCount() : 0;
        return n;
    }

    @Override
    public int getColumnCount() {
        return ColumnDescriptor.getColumnCount();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public String getColumnName(int n) {
        return this.getColumnDescriptor(n).getColumnName();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.getColumnDescriptor(n).getColumnClass();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SourceProperty sourceProperty = this.getFieldSource().getSourceProperty(n);
        switch (this.getColumnDescriptor(n2)) {
            case FREQUENCY: {
                return sourceProperty.getSourceFrequency();
            }
            case FLUX: {
                return sourceProperty.getSourceFluxI();
            }
            case DIAMETER: {
                return sourceProperty.getSourceDiameter();
            }
        }
        String string = "Unexpected column index : " + n2;
        Log.logger((Object)this).warning(string);
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        FieldSource fieldSource = this.getFieldSource();
        if (fieldSource.getSourcePropertyCount() > n) {
            SourceProperty sourceProperty = this.getFieldSource().getSourceProperty(n);
            switch (this.getColumnDescriptor(n2)) {
                case FREQUENCY: {
                    Frequency frequency = (Frequency)((Object)object);
                    sourceProperty.getSourceFrequency().setContent(frequency.getContent());
                    sourceProperty.getSourceFrequency().setUnit(frequency.getUnit());
                    break;
                }
                case FLUX: {
                    Sensitivity sensitivity = (Sensitivity)((Object)object);
                    sourceProperty.getSourceFluxI().setContent(sensitivity.getContent());
                    sourceProperty.getSourceFluxI().setUnit(sensitivity.getUnit());
                    break;
                }
                case DIAMETER: {
                    Angle angle = (Angle)((Object)object);
                    sourceProperty.getSourceDiameter().setContent(angle.getContent());
                    sourceProperty.getSourceDiameter().setUnit(angle.getUnit());
                    break;
                }
                default: {
                    String string = "Unexpected column index : " + n2;
                    Log.logger((Object)this).warning(string);
                }
            }
        }
    }

    public FieldSource getFieldSource() {
        return this.fieldSource;
    }

    public void setFieldSource(FieldSource fieldSource) {
        this.fieldSource = fieldSource;
    }

    public static enum ColumnDescriptor {
        FREQUENCY("Frequency", Frequency.class),
        FLUX("Flux", Sensitivity.class),
        DIAMETER("Diameter", Angle.class);

        public final String columnName;
        public final Class<?> columnClass;

        protected static int getColumnCount() {
            return ColumnDescriptor.values().length;
        }

        protected static ColumnDescriptor getColumnDescriptor(int n) {
            return ColumnDescriptor.values()[n];
        }

        private ColumnDescriptor(String string2, Class<?> clazz) {
            this.columnName = string2;
            this.columnClass = clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }
}

