/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.schedblock;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.schedblock.AbstractSwitchingCycle;
import alma.obsprep.bo.schedblock.BeamSwitchingCycle;
import alma.obsprep.bo.schedblock.BeamSwitchingState;
import alma.obsprep.bo.schedblock.FrequencySwitchingCycle;
import alma.obsprep.bo.schedblock.FrequencySwitchingState;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.schedblock.SwitchingCycleEditor;
import alma.obsprep.ot.models.schedblock.BeamSwitchingStateTableModel;
import alma.obsprep.ot.models.schedblock.FrequencySwitchingStateTableModel;
import alma.obsprep.ot.models.valuetypes.ValueUnitPairModel;
import alma.valuetypes.Time;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class SwitchingCycleModel
extends Model {
    private FrequencySwitchingCycle frequencySwitchingCycle;
    private final FrequencySwitchingStateTableModel frequencySwitchingStatesModel;
    private final ValueUnitPairModel frequencyDwellTimeModel = new ValueUnitPairModel(null);
    private BeamSwitchingCycle beamSwitchingCycle;
    private final BeamSwitchingStateTableModel beamSwitchingStatesModel;
    private final ValueUnitPairModel beamDwellTimeModel;

    public SwitchingCycleModel(SpectralSpec spectralSpec) {
        super(spectralSpec);
        this.frequencySwitchingStatesModel = new FrequencySwitchingStateTableModel();
        this.frequencySwitchingStatesModel.addTableModelListener(new MyTableModelListener(SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING));
        this.beamDwellTimeModel = new ValueUnitPairModel(null);
        this.beamSwitchingStatesModel = new BeamSwitchingStateTableModel();
        this.beamSwitchingStatesModel.addTableModelListener(new MyTableModelListener(SpectralSpec.SWITCHINGTYPE_NUTATOR_SWITCHING));
        this.registerSubModel(this.frequencyDwellTimeModel);
        this.registerSubModel(this.beamDwellTimeModel);
    }

    public SpectralSpec getSpectralSpec() {
        return (SpectralSpec)this.document;
    }

    @Override
    public void publish() {
        SpectralSpec spectralSpec = this.getSpectralSpec();
        if (spectralSpec == null) {
            return;
        }
        AbstractSwitchingCycle abstractSwitchingCycle = spectralSpec.getAbstractSwitchingCycle();
        if (abstractSwitchingCycle == null) {
            this.publish(SwitchingCycleEditor.SWITCHINGTYPE_FID, SpectralSpec.SWITCHINGTYPE_NO_SWITCHING);
            return;
        }
        String string = null;
        if (abstractSwitchingCycle instanceof FrequencySwitchingCycle) {
            string = SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING;
        } else if (abstractSwitchingCycle instanceof BeamSwitchingCycle) {
            string = SpectralSpec.SWITCHINGTYPE_NUTATOR_SWITCHING;
        }
        this.publish(SwitchingCycleEditor.SWITCHINGTYPE_FID, string);
        if (abstractSwitchingCycle instanceof FrequencySwitchingCycle) {
            this.publish(SwitchingCycleEditor.FREQ_NUMPOS_FID, this.frequencySwitchingCycle.getNumberOfPositions());
            this.frequencyDwellTimeModel.publish();
        } else if (abstractSwitchingCycle instanceof BeamSwitchingCycle) {
            this.publish(SwitchingCycleEditor.BEAM_NUMPOS_FID, this.beamSwitchingCycle.getNumberOfPositions());
            this.publish(SwitchingCycleEditor.BEAM_SWITCH_MODE_FID, this.beamSwitchingCycle.getMode());
            this.beamDwellTimeModel.publish();
        }
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        if (fieldID.equals(SwitchingCycleEditor.SWITCHINGTYPE_FID)) {
            String string = (String)object;
            if (string.equals(SpectralSpec.SWITCHINGTYPE_NO_SWITCHING)) {
                this.getSpectralSpec().setSwitchingType(SpectralSpec.SWITCHINGTYPE_NO_SWITCHING);
                this.getSpectralSpec().setAbstractSwitchingCycle(null);
            } else if (string.equals(SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING)) {
                this.getSpectralSpec().setSwitchingType(SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING);
                this.getSpectralSpec().setAbstractSwitchingCycle((AbstractSwitchingCycle)((Object)this.frequencySwitchingCycle));
                this.publish(SwitchingCycleEditor.FREQ_NUMPOS_FID, this.frequencySwitchingCycle.getNumberOfPositions());
                this.frequencyDwellTimeModel.publish();
            } else if (string.equals(SpectralSpec.SWITCHINGTYPE_NUTATOR_SWITCHING)) {
                this.getSpectralSpec().setSwitchingType(SpectralSpec.SWITCHINGTYPE_NUTATOR_SWITCHING);
                this.getSpectralSpec().setAbstractSwitchingCycle((AbstractSwitchingCycle)((Object)this.beamSwitchingCycle));
                this.publish(SwitchingCycleEditor.BEAM_NUMPOS_FID, this.beamSwitchingCycle.getNumberOfPositions());
                this.beamDwellTimeModel.publish();
            }
        } else if (fieldID.equals(SwitchingCycleEditor.BEAM_SWITCH_MODE_FID)) {
            this.beamSwitchingCycle.setMode((String)object);
        }
        return object;
    }

    private void updateBeamNumberOfPositions() {
        int n = this.beamSwitchingCycle.getBeamSwitchingState().length;
        this.beamSwitchingCycle.setNumberOfPositions(n);
        this.publish(SwitchingCycleEditor.BEAM_NUMPOS_FID, n);
    }

    private void updateBeamDwellTime() {
        Time time = Time.createTime();
        BeamSwitchingState[] beamSwitchingStateArray = this.beamSwitchingCycle.getBeamSwitchingState();
        for (int i = 0; i < beamSwitchingStateArray.length; ++i) {
            time.aggregate(beamSwitchingStateArray[i].getDwellTime());
        }
        this.beamSwitchingCycle.getDwellTime().setContentAndUnit((ValueUnitPair)time);
        this.beamDwellTimeModel.publish();
    }

    private void updateFrequencyNumberOfPositions() {
        int n = this.frequencySwitchingCycle.getFrequencySwitchingState().length;
        this.frequencySwitchingCycle.setNumberOfPositions(n);
        this.publish(SwitchingCycleEditor.FREQ_NUMPOS_FID, n);
    }

    private void updateFrequencyDwellTime() {
        Time time = Time.createTime();
        FrequencySwitchingState[] frequencySwitchingStateArray = this.frequencySwitchingCycle.getFrequencySwitchingState();
        for (int i = 0; i < frequencySwitchingStateArray.length; ++i) {
            time.aggregate(frequencySwitchingStateArray[i].getDwellTime());
        }
        this.frequencySwitchingCycle.getDwellTime().setContentAndUnit((ValueUnitPair)time);
        this.frequencyDwellTimeModel.publish();
    }

    @Override
    public void setDocument(Object object) {
        if (!(object instanceof SpectralSpec)) {
            throw new RuntimeException();
        }
        this.document = object;
        this.beamSwitchingCycle = BeamSwitchingCycle.createBeamSwitchingCycle();
        this.beamSwitchingCycle.setNumberOfPositions(0);
        this.beamSwitchingCycle.setDwellTime(Time.createTime((double)0.0, (String)Time.UNIT_MS));
        this.beamSwitchingCycle.setMode(BeamSwitchingCycle.MODE_STEPS);
        this.frequencySwitchingCycle = FrequencySwitchingCycle.createFrequencySwitchingCycle();
        this.frequencySwitchingCycle.setNumberOfPositions(0);
        this.frequencySwitchingCycle.setDwellTime(Time.createTime((double)0.0, (String)Time.UNIT_MS));
        AbstractSwitchingCycle abstractSwitchingCycle = ((SpectralSpec)object).getAbstractSwitchingCycle();
        if (abstractSwitchingCycle != null) {
            if (abstractSwitchingCycle instanceof FrequencySwitchingCycle) {
                this.frequencySwitchingCycle = (FrequencySwitchingCycle)((Object)abstractSwitchingCycle);
                this.getSpectralSpec().setSwitchingType(SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING);
            } else if (abstractSwitchingCycle instanceof BeamSwitchingCycle) {
                this.beamSwitchingCycle = (BeamSwitchingCycle)((Object)abstractSwitchingCycle);
                this.getSpectralSpec().setSwitchingType(SpectralSpec.SWITCHINGTYPE_NUTATOR_SWITCHING);
            }
        }
        this.frequencyDwellTimeModel.setDocument(this.frequencySwitchingCycle.getDwellTime());
        this.beamDwellTimeModel.setDocument(this.beamSwitchingCycle.getDwellTime());
        this.beamSwitchingStatesModel.setAbstractSwitchCycle((AbstractSwitchingCycle)((Object)this.beamSwitchingCycle));
        this.frequencySwitchingStatesModel.setAbstractSwitchCycle((AbstractSwitchingCycle)((Object)this.frequencySwitchingCycle));
        this.publish();
        this.updateBeamNumberOfPositions();
        this.updateBeamDwellTime();
        this.updateFrequencyNumberOfPositions();
        this.updateFrequencyDwellTime();
    }

    public FrequencySwitchingCycle getFrequencySwitchingCycle() {
        return this.frequencySwitchingCycle;
    }

    public FrequencySwitchingStateTableModel getFrequencySwitchingStatesModel() {
        return this.frequencySwitchingStatesModel;
    }

    public ValueUnitPairModel getFrequencyDwellTimeModel() {
        return this.frequencyDwellTimeModel;
    }

    public BeamSwitchingCycle getBeamSwitchingCycle() {
        return this.beamSwitchingCycle;
    }

    public BeamSwitchingStateTableModel getBeamSwitchingStatesModel() {
        return this.beamSwitchingStatesModel;
    }

    public ValueUnitPairModel getBeamDwellTimeModel() {
        return this.beamDwellTimeModel;
    }

    private class MyTableModelListener
    implements TableModelListener {
        private final String cycleType;

        public MyTableModelListener(String string) {
            this.cycleType = string;
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 1 || tableModelEvent.getType() == -1) {
                if (this.cycleType.equals(SpectralSpec.SWITCHINGTYPE_NUTATOR_SWITCHING)) {
                    SwitchingCycleModel.this.updateBeamNumberOfPositions();
                } else if (this.cycleType.equals(SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING)) {
                    SwitchingCycleModel.this.updateFrequencyNumberOfPositions();
                }
            }
            if (tableModelEvent.getColumn() == 1) {
                if (this.cycleType.equals(SpectralSpec.SWITCHINGTYPE_NUTATOR_SWITCHING)) {
                    SwitchingCycleModel.this.updateBeamDwellTime();
                } else if (this.cycleType.equals(SpectralSpec.SWITCHINGTYPE_FREQUENCY_SWITCHING)) {
                    SwitchingCycleModel.this.updateFrequencyDwellTime();
                }
            }
        }
    }
}

