/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.project;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.Referring;
import alma.hla.runtime.obsprep.interfaces.ModelStructureListener;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.adoption.Add;
import alma.obsprep.ot.project.adoption.AddRemove_AsIndicated;
import alma.obsprep.ot.project.adoption.AddRemove_IgnoredAssociations;
import alma.obsprep.ot.project.adoption.AddRemove_IgnoredTypes;
import alma.obsprep.ot.project.adoption.Add_AddableToSBCollection_to_SchedBlock;
import alma.obsprep.ot.project.adoption.Add_ObsUnitSet_to_ObsProgramFolder;
import alma.obsprep.ot.project.adoption.Add_ObsUnitSet_to_ObsProposalFolder;
import alma.obsprep.ot.project.adoption.Add_ObsUnitSet_to_ScienceGoal;
import alma.obsprep.ot.project.adoption.Add_ScienceGoal_to_PhaseISciencePlanCollection;
import alma.obsprep.ot.project.adoption.Remove;
import alma.obsprep.ot.project.adoption.StructuralOperation;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.SwingUtilities;

public class ProjectTreeStructuralUpdater
implements ModelStructureListener {
    private Log.Logger logger;
    private final ProjectTree ptree;
    private ObsProject myProject;
    private List<Add> addAdopts = new Vector<Add>();
    private List<Remove> remAdopts = new Vector<Remove>();

    public ProjectTreeStructuralUpdater(ProjectTree projectTree) {
        this.addAdopts.add(new AddRemove_IgnoredTypes());
        this.addAdopts.add(new Add_AddableToSBCollection_to_SchedBlock());
        this.addAdopts.add(new Add_ObsUnitSet_to_ScienceGoal());
        this.addAdopts.add(new Add_ObsUnitSet_to_ObsProposalFolder());
        this.addAdopts.add(new Add_ObsUnitSet_to_ObsProgramFolder());
        this.addAdopts.add(new Add_ScienceGoal_to_PhaseISciencePlanCollection());
        this.addAdopts.add(new AddRemove_IgnoredAssociations());
        this.addAdopts.add(new AddRemove_AsIndicated());
        this.remAdopts.add(new AddRemove_IgnoredTypes());
        this.remAdopts.add(new AddRemove_IgnoredAssociations());
        this.remAdopts.add(new AddRemove_AsIndicated());
        this.ptree = projectTree;
        this.logger = Log.logger((Object)this);
    }

    void switchToProject(ObsProject obsProject) {
        if (this.myProject == obsProject) {
            return;
        }
        if (this.myProject != null) {
            this.myProject.removeModelStructureListener(this);
        }
        if (obsProject != null) {
            obsProject.addModelStructureListener(this);
        }
        this.myProject = obsProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void businessObjectAddedTo(IBusinessObject iBusinessObject, IBusinessObject iBusinessObject2, Referring.By by, int n) {
        Debug_Add_Describe debug_Add_Describe = new Debug_Add_Describe();
        debug_Add_Describe.ptree = this.ptree;
        try {
            Add add3;
            StructuralOperation structuralOperation;
            debug_Add_Describe.op = structuralOperation = new StructuralOperation((BusinessObject)iBusinessObject, (BusinessObject)iBusinessObject2, by, n);
            Add add2 = null;
            for (Add add3 : this.addAdopts) {
                if (!add3.responsibleFor(structuralOperation)) continue;
                add2 = add3;
                break;
            }
            debug_Add_Describe.adopter = add2;
            if (add2 == null) {
                return;
            }
            boolean bl = false;
            add3 = add2;
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(() -> add3.performAdd(structuralOperation, this.ptree));
            } else {
                bl = add3.performAdd(structuralOperation, this.ptree);
            }
            debug_Add_Describe.workdone = bl;
        }
        finally {
            if (debug_Add_Describe.workdone) {
                if (this.logger.finer()) {
                    this.logger.finer(debug_Add_Describe.toString());
                }
            } else if (this.logger.debug()) {
                this.logger.log(Log.DEBUG, debug_Add_Describe.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void businessObjectRemovedFrom(IBusinessObject iBusinessObject, IBusinessObject iBusinessObject2, Referring.By by) {
        Debug_Remove_Describe debug_Remove_Describe = new Debug_Remove_Describe();
        debug_Remove_Describe.ptree = this.ptree;
        try {
            StructuralOperation structuralOperation;
            debug_Remove_Describe.op = structuralOperation = new StructuralOperation((BusinessObject)iBusinessObject, (BusinessObject)iBusinessObject2, by);
            Remove remove = null;
            for (Remove remove2 : this.remAdopts) {
                if (!remove2.responsibleFor(structuralOperation)) continue;
                remove = remove2;
                break;
            }
            debug_Remove_Describe.adopter = remove;
            if (remove == null) {
                return;
            }
            Iterator<Remove> iterator = remove;
            boolean bl = false;
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(() -> iterator.performRemove(structuralOperation, this.ptree));
            } else {
                bl = iterator.performRemove(structuralOperation, this.ptree);
            }
            debug_Remove_Describe.workdone = bl;
        }
        finally {
            if (debug_Remove_Describe.workdone) {
                if (this.logger.finer()) {
                    this.logger.finer(debug_Remove_Describe.toString());
                }
            } else if (this.logger.debug()) {
                this.logger.log(Log.DEBUG, debug_Remove_Describe.toString());
            }
        }
    }

    private class Debug_Add_Describe {
        ProjectTree ptree;
        StructuralOperation op;
        Add adopter;
        boolean workdone;

        private Debug_Add_Describe() {
        }

        Level toLevel() {
            return this.workdone ? Level.FINER : Log.DEBUG;
        }

        public String toString() {
            String string = "bo-event " + String.valueOf(this.op) + " arrived at ";
            int n = System.identityHashCode(this.ptree);
            string = string + (this.ptree.isPhase2Tree() ? "programtree@" + n + ". " : "proposaltree@" + n + ".");
            if (this.adopter == null) {
                string = string + "Ignored because don't know how to handle this kind of datamodel change.";
            } else {
                string = string + " Processed by " + this.adopter.getClass().getSimpleName() + ".";
                string = !this.workdone ? string + " Ignored because change not applicable to tree." : string + " Tree has been changed";
            }
            return string;
        }
    }

    private class Debug_Remove_Describe {
        ProjectTree ptree;
        StructuralOperation op;
        Remove adopter;
        boolean workdone;

        private Debug_Remove_Describe() {
        }

        Level toLevel() {
            return this.workdone ? Level.FINER : Log.DEBUG;
        }

        public String toString() {
            String string = "bo-event " + String.valueOf(this.op) + " arrived at ";
            int n = System.identityHashCode(this.ptree);
            string = string + (this.ptree.isPhase2Tree() ? "programtree@" + n + ". " : "proposaltree@" + n + ".");
            if (this.adopter == null) {
                string = string + "Ignored because don't know how to handle this kind of datamodel change.";
            } else {
                string = string + " Processed by " + this.adopter.getClass().getSimpleName() + ".";
                string = !this.workdone ? string + " Ignored because no node of this tree is affected by the change." : string + " Tree has been changed";
            }
            return string;
        }
    }
}

