/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.scripting;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.scripting.XmlErrorHandler;
import alma.obsprep.ot.scripting.bindings.ObjectFactory;
import alma.obsprep.ot.scripting.bindings.P2GBatchAction;
import alma.obsprep.util.FileUtilities;
import alma.obsprep.util.MiscUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import lombok.NonNull;
import org.xml.sax.SAXException;

public class P2GBatchActionXMLReader {
    private static P2GBatchActionXMLReader instance;

    public P2GBatchAction getP2GBatchConfiguration(@NonNull File file) throws JAXBException {
        if (file == null) {
            throw new NullPointerException("p2gActionXMLFile is marked non-null but is null");
        }
        this.validateXMLActionFile(file);
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        ValidationEventCollector validationEventCollector = new ValidationEventCollector();
        unmarshaller.setEventHandler((ValidationEventHandler)validationEventCollector);
        InputStream inputStream = null;
        Log.logger(this.getClass()).info("Loading P2G batch action file : " + String.valueOf(file));
        try {
            inputStream = FileUtilities.makeURL(file).openStream();
        }
        catch (Exception exception) {
            Log.logger(this.getClass()).log(Level.WARNING, "Error accessing " + String.valueOf(file) + " file: " + exception.getMessage(), (Throwable)exception);
            throw new RuntimeException(exception);
        }
        return (P2GBatchAction)((JAXBElement)unmarshaller.unmarshal(inputStream)).getValue();
    }

    private void validateXMLActionFile(@NonNull File file) {
        Object object;
        if (file == null) {
            throw new NullPointerException("p2gActionXMLFile is marked non-null but is null");
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = schemaFactory.newSchema(MiscUtils.findResource("idl/P2GBatchActions.xsd"));
        }
        catch (SAXException sAXException) {
            System.out.println("Unable to process schema file: " + sAXException.getMessage());
            System.exit(-1);
        }
        XmlErrorHandler xmlErrorHandler = new XmlErrorHandler();
        try {
            object = schema.newValidator();
            ((Validator)object).setErrorHandler(xmlErrorHandler);
            ((Validator)object).validate(new StreamSource(file));
        }
        catch (IOException | SAXException exception) {
            System.out.println("Unable to read the XML action file " + String.valueOf(file) + " " + exception.getMessage());
            System.exit(-1);
        }
        object = xmlErrorHandler.getExceptions();
        if (!object.isEmpty()) {
            System.out.println("Unable to process XML action file: " + String.valueOf(file) + "\n\n");
            object.forEach(sAXParseException -> System.out.println(String.format("Line number: %s, Column number: %s: %s", sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.getMessage())));
            System.out.println("\n\nPlease correct the above issues and try again.");
            System.exit(-1);
        }
    }

    public static P2GBatchActionXMLReader getInstance() {
        if (null == instance) {
            instance = new P2GBatchActionXMLReader();
        }
        return instance;
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        P2GBatchActionXMLReader p2GBatchActionXMLReader = P2GBatchActionXMLReader.getInstance();
        File file = new File("c:\\temp\\newfile.xml");
        try {
            p2GBatchActionXMLReader.getP2GBatchConfiguration(file);
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            System.exit(-1);
        }
        System.out.println("P2G Batch Action XML file " + String.valueOf(file) + " successfully validated");
    }
}

