/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.scripting;

import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsPhase;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.actions.WizardInteractor;
import alma.obsprep.ot.actions.WizardPerformer;
import alma.obsprep.ot.boEditors.AbstractWizard;
import alma.obsprep.ot.scripting.PyAction;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;

public abstract class PyGenerate
extends PyAction
implements WizardInteractor {
    protected final ObsPhase phase;

    protected PyGenerate(ObsPhase obsPhase) {
        this.phase = obsPhase;
        this.setPerformer(new WizardPerformer(this));
    }

    @Override
    public AbstractScienceGoal[] getScienceGoals() {
        return this.phase.getAbstractScienceGoalScienceGoal();
    }

    @Override
    public void busy(boolean bl) {
    }

    public static class PhaseII
    extends PyGenerate {
        private Optional<List<ScienceGoal>> scienceGoalsToBeRegenerated = Optional.empty();

        public PhaseII(ObsProgram obsProgram) {
            super((ObsPhase)((Object)obsProgram));
        }

        public PhaseII(ObsProgram obsProgram, @NonNull List<ScienceGoal> list) {
            super((ObsPhase)((Object)obsProgram));
            if (list == null) {
                throw new NullPointerException("scienceGoals is marked non-null but is null");
            }
            this.scienceGoalsToBeRegenerated = Optional.of(list);
        }

        @Override
        public boolean confirmOverwrite() {
            return true;
        }

        @Override
        public boolean shouldScienceGoalKnowItGotGenerated() {
            return true;
        }

        @Override
        public AbstractScienceGoal[] getScienceGoals() {
            return (AbstractScienceGoal[])this.scienceGoalsToBeRegenerated.orElse(Arrays.asList(this.phase.getAbstractScienceGoalScienceGoal())).stream().toArray(ScienceGoal[]::new);
        }

        @Override
        public boolean requestConfirmation(String string) {
            return true;
        }
    }

    public static class PhaseI
    extends PyGenerate {
        public PhaseI(ObsProposal obsProposal) {
            super((ObsPhase)((Object)obsProposal));
        }

        @Override
        public boolean confirmOverwrite() {
            return true;
        }

        @Override
        public boolean shouldScienceGoalKnowItGotGenerated() {
            return false;
        }

        @Override
        public AbstractScienceGoal[] getScienceGoals() {
            return this.phase.getAbstractScienceGoalScienceGoal();
        }

        @Override
        public void perform() {
            AbstractWizard.getPlanForPhase1SBs((ObsProposal)((Object)this.phase)).clearObsUnitSet();
            super.perform();
        }

        @Override
        public boolean requestConfirmation(String string) {
            return true;
        }
    }
}

