/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.valdef.ProblemListModel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import lombok.NonNull;

public abstract class AbstractValidator {
    private boolean isValidatorThreadSafe = false;
    private final AtomicBoolean isValidatorRan = new AtomicBoolean(false);

    public void resetValidatorRanFlag() {
        Log.logger(AbstractValidator.class).fine("validator flag reset: " + this.getClass().getSimpleName());
        this.isValidatorRan.set(false);
    }

    protected abstract void localValidate(BusinessObject var1, ProblemListModel var2);

    public final void validate(@NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel) {
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        try {
            this.isValidatorRan.set(true);
            this.localValidate(businessObject, problemListModel);
        }
        catch (Exception exception) {
            Log.logger((Object)this).log(Level.INFO, "Error running the " + this.getClass().getSimpleName() + " on " + businessObject.getClass().getName() + ". Its validation results will be ignored.", (Throwable)exception);
        }
    }

    protected boolean isMultiple(double d, double d2, double d3) {
        double d4 = d / d2;
        double d5 = d4 - Math.floor(d4);
        return d5 <= d3;
    }

    protected boolean isZero(double d, double d2) {
        return Math.abs(d) <= d2;
    }

    protected boolean equals(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3;
    }

    public boolean isValidatorThreadSafe() {
        return this.isValidatorThreadSafe;
    }

    public void setValidatorThreadSafe(boolean bl) {
        this.isValidatorThreadSafe = bl;
    }

    public AtomicBoolean getIsValidatorRan() {
        return this.isValidatorRan;
    }
}

