/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.valdef.schedblock;

import alma.entity.xmlbinding.obsproject.types.ControlBlockTArrayRequestedType;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.Reference;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.valdef.AbstractValidator;
import alma.obsprep.ot.valdef.ProblemListModel;
import alma.obsprep.ot.valdef.schedblock.ValidatorUtils;
import alma.obsprep.problems.DefaultProblem;
import alma.obsprep.problems.Problem;
import alma.obsprep.util.astro.SkyPoint;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Time;
import jsky.coords.WorldCoords;
import lombok.NonNull;

public class ReferenceValidator
extends AbstractValidator {
    public ReferenceValidator() {
        this.setValidatorThreadSafe(true);
    }

    @Override
    protected void localValidate(BusinessObject businessObject, ProblemListModel problemListModel) {
        Target[] targetArray;
        double d;
        Problem problem;
        Reference reference = (Reference)businessObject;
        double d2 = reference.getCycleTime().getContentInUnits(Time.UNIT_S);
        if (d2 <= 0.0) {
            problem = DefaultProblem.createError("Reference position cycle time is invalid", "Set the time to a sensible value", (IBusinessObject)reference);
            problemListModel.add(problem);
        }
        if ((d = reference.getIntegrationTime().getContentInUnits(Time.UNIT_S)) <= 0.0) {
            problem = DefaultProblem.createError("Reference position integration time is invalid", "Set the time to a sensible value", (IBusinessObject)reference);
            problemListModel.add(problem);
        }
        if (reference.getSubScanDuration().getContentInDefaultUnits() <= 0.0) {
            problem = DefaultProblem.createError("Reference Position subscan duration is invalid", "Set the time to a sensible value", (IBusinessObject)reference);
            problemListModel.add(problem);
        }
        FieldSource fieldSource = (FieldSource)reference.getParent();
        SchedBlock schedBlock = (SchedBlock)fieldSource.getParent();
        for (Target target : targetArray = fieldSource.getTargetList()) {
            boolean bl;
            if (target.getAbstractInstrumentSpec() != null && !(target.getAbstractInstrumentSpec() instanceof OpticalCameraSpec) && !target.hasScienceParameters()) {
                Time time;
                Time time2 = reference.getSubScanDuration();
                if (!ValidatorUtils.isIntegralMultipleTime(time2, time = ((SpectralSpec)((Object)target.getAbstractInstrumentSpec())).getCorrelatorConfiguration().getIntegrationDuration())) {
                    problem = DefaultProblem.createError("Subscan duration in reference position is not a multiple of the integration duration in the associated instrument setup", "Correct the value of the subscan duration", (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                }
                if (!ValidatorUtils.isIntegralMultipleControlRequiredBase(time2)) {
                    problem = DefaultProblem.createError("Subscan duration in reference position is not a multiple of 48.0 ms", "Correct the value of the subscan duration", (IBusinessObject)businessObject);
                    problemListModel.add(problem);
                }
            }
            if (!(bl = schedBlock.getObsUnitControl().getArrayRequested().equals(ControlBlockTArrayRequestedType.TP_ARRAY.toString())) || !target.hasScienceParameters() || fieldSource.getSolarSystemObject().equals(FieldSource.SOLARSYSTEMOBJECT_SUN)) continue;
            this.validateTPOffPositionIsNotTooFarFromSource(target, reference, businessObject, problemListModel);
        }
    }

    private void validateTPOffPositionIsNotTooFarFromSource(@NonNull Target target, @NonNull Reference reference, @NonNull BusinessObject businessObject, @NonNull ProblemListModel problemListModel) {
        double d;
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        if (businessObject == null) {
            throw new NullPointerException("bo is marked non-null but is null");
        }
        if (problemListModel == null) {
            throw new NullPointerException("plm is marked non-null but is null");
        }
        FieldSource fieldSource = target.getFieldSource();
        ReceiverBand receiverBand = target.getSpectralSpec().getReceiverBand();
        if (ReceiverBand.isReceiverBandInSet(receiverBand, 1, 2, 3, 4, 5, 6)) {
            d = 5.0;
        } else if (ReceiverBand.isReceiverBandInSet(receiverBand, 7, 8)) {
            d = 3.0;
        } else {
            return;
        }
        SkyCoordinates skyCoordinates = reference.getFieldCenterCoordinates();
        if (!skyCoordinates.isAbsoluteCoordinates()) {
            skyCoordinates = skyCoordinates.getAbsoluteCoordinates(fieldSource.getSourceCoordinates()).deepCopy();
        }
        SkyPoint skyPoint = skyCoordinates.getAbsoluteSkyPointInICRSDeg();
        SkyPoint skyPoint2 = fieldSource.getSourceCoordinates().getAbsoluteSkyPointInICRSDeg();
        if (WorldCoords.dist((double)skyPoint2.getX(), (double)skyPoint2.getY(), (double)skyPoint.getX(), (double)skyPoint.getY()) > d * 60.0) {
            Problem problem = DefaultProblem.createWarning("TP OFF position is too far from the science target (" + fieldSource.getSourceName() + ")", "Select a new OFF position that is closer to the science target", (IBusinessObject)businessObject);
            problemListModel.add(problem);
        }
    }
}

