/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.calibration;

import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalObsProperties;
import alma.obsprep.services.calibration.CalType;
import alma.valuetypes.Flux;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;

public class AmplitudeCalObs
extends CalObs {
    public AmplitudeCalObs() {
        this.setCalType(CalType.Amplitude);
    }

    public AmplitudeCalObs(ScienceGoal scienceGoal) {
        this();
        this.scienceGoal = scienceGoal;
        this.configure();
    }

    public boolean isResolvedSource() {
        CalObs.SourceObject sourceObject = this.getCalibrator();
        return sourceObject.isNonSiderealMotion();
    }

    @Override
    public boolean atmCalRequired(SchedBlock schedBlock) {
        return true;
    }

    @Override
    public double getDefaultSNR() {
        CalObsProperties calObsProperties = AmplitudeCalObs.getCalObsProperties();
        return this.isResolvedSource() ? calObsProperties.getAmplitudeCalResolvedSNR() : calObsProperties.getAmplitudeCalUnresolvedSNR();
    }

    @Override
    public Flux getDefaultFlux() {
        if (this.isResolvedSource()) {
            return AmplitudeCalObs.getCalObsProperties().getAmplitudeCalResolvedFlux();
        }
        return AmplitudeCalObs.getCalObsProperties().getAmplitudeFlux();
    }

    @Override
    public Frequency getDefaultChannelWidth() {
        if (this.scienceGoal == null || this.scienceGoal.getSpectralSetupParameters().getAbstractScienceSpectralWindowCount() == 0) {
            return Frequency.createFrequencyMHZ(0.48828125);
        }
        return this.scienceGoal.getSpectralSetupParameters().getStringentSpectralWindow().getBandWidth().deepCopy();
    }

    @Override
    public Time rawCycleTime() {
        return AmplitudeCalObs.getCalObsProperties().getAmplitudeCycleTime();
    }
}

