/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.etc;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.ScienceParameters;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.intermediatetarget.TPRasterData;
import alma.valuetypes.Time;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import lombok.NonNull;

public class TotalPowerObservingTimeCalculator {
    final Time oneWayMotionTime = Time.createTimeSec(3.0);
    private final ScienceGoal scienceGoal;
    private final ObservingTimeCalculator otc;

    public TotalPowerObservingTimeCalculator(@NonNull ScienceGoal scienceGoal, @NonNull ObservingTimeCalculator observingTimeCalculator) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (observingTimeCalculator == null) {
            throw new NullPointerException("otc is marked non-null but is null");
        }
        this.scienceGoal = scienceGoal;
        this.otc = observingTimeCalculator;
    }

    public Time getTotalTPExecutionTime(boolean bl, boolean bl2) throws UnableToGenerateTPTimeEstimateException, InvalidObsProgramParametersException, UnknownEntityException {
        Time time = null;
        try {
            time = this.otc.getTotalArraySBScienceIntegrationTime(bl, Array.ARRAY_TP);
        }
        catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
            return time;
        }
        assert (time != null);
        ObsUnitSet obsUnitSet = this.otc.generateSBs(this.scienceGoal);
        assert (obsUnitSet != null);
        List<SchedBlock> list = this.findAllTPScienceSBs(obsUnitSet);
        if (list == null || list.isEmpty()) {
            return Time.createTimeSec(0.0);
        }
        Time time2 = this.getTPCalibrationTime(list);
        Time time3 = bl2 ? this.getTPOverheadTime(list) : Time.createTime();
        Time time4 = (Time)((Time)time.plus((AbstractDoubleWithUnit)time2)).plus((AbstractDoubleWithUnit)time3);
        if (Log.logger(TotalPowerObservingTimeCalculator.class).fine()) {
            Log.logger(TotalPowerObservingTimeCalculator.class).fine("totalTPITOSTime: " + String.valueOf(time));
            Log.logger(TotalPowerObservingTimeCalculator.class).fine("tpTotalOverheadTime: " + String.valueOf(time3));
            Log.logger(TotalPowerObservingTimeCalculator.class).fine("tpTotalCalibrationTime: " + String.valueOf(time2));
            Log.logger(TotalPowerObservingTimeCalculator.class).fine("totalTPSBExecutionTime: " + String.valueOf(time4));
        }
        int n = 1;
        if (!bl) {
            n = this.getNoOfVisits();
        }
        return (Time)time4.multiply(n);
    }

    private int getNoOfVisits() {
        int n = 1;
        PerformanceParameters performanceParameters = this.scienceGoal.getPerformanceParameters();
        if (performanceParameters.getIsTimeConstrained()) {
            boolean bl;
            String string = performanceParameters.getTimingConstraintsType();
            boolean bl2 = bl = string != null && string.equals(PerformanceParameters.TIMINGCONSTRAINTSTYPE_MULTIPLEVISITS);
            if (bl) {
                n = performanceParameters.getVisitConstraintCount();
            }
        }
        return n;
    }

    private Time getTPOverheadTime(@NonNull List<SchedBlock> list) throws UnableToGenerateTPTimeEstimateException {
        if (list == null) {
            throw new NullPointerException("allTPSScienceSBs is marked non-null but is null");
        }
        Time time = Time.createTime();
        for (SchedBlock schedBlock : list) {
            if (!schedBlock.isTotalPowerScienceSB()) {
                throw new IllegalArgumentException("SBs in list are not TP science SBs");
            }
            Time time2 = (Time)((Time)ObservingTimeCalculator.SB_EXEC_OVERHEAD.plus((AbstractDoubleWithUnit)this.getFocusCalOverheadTime())).plus((AbstractDoubleWithUnit)this.getPointingCalOverheadTime());
            for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
                ScienceParameters scienceParameters = target.getFirstScienceParameters().orElseThrow(UnableToGenerateTPTimeEstimateException::new);
                TPRasterData tPRasterData = scienceParameters.getTPRasterData().orElseThrow(UnableToGenerateTPTimeEstimateException::new);
                int n = tPRasterData.getN_rows();
                double d = tPRasterData.getT_rect().getSecs();
                double d2 = scienceParameters.getIntegrationTime().getSecs();
                long l = Math.round(d2 / d);
                time2.aggregate((Time)ObservingTimeCalculator.SCAN_LATENCY.multiply(l));
                long l2 = l * (long)n * 2L;
                time2.aggregate((Time)ObservingTimeCalculator.SUBSCAN_LATENCY.multiply(l2));
                time2.aggregate((Time)this.oneWayMotionTime.multiply(l2));
            }
            time2.aggregate(ObservingTimeCalculator.SCAN_LATENCY);
            int n = schedBlock.getSchedBlockControl().getExecutionCount();
            time.aggregate((Time)time2.multiply(n));
        }
        return time;
    }

    private Time getPointingCalOverheadTime() {
        Time time = (Time)this.oneWayMotionTime.multiply(2.0);
        time.aggregate(ObservingTimeCalculator.SCAN_LATENCY);
        return time;
    }

    private Time getFocusCalOverheadTime() {
        Time time = Time.createTime();
        if (!this.getFocusCalTime().isZero()) {
            time.aggregate((Time)this.oneWayMotionTime.multiply(2.0));
            time.aggregate(ObservingTimeCalculator.SCAN_LATENCY);
        }
        return time;
    }

    private Time getTPCalibrationTime(List<SchedBlock> list) throws InvalidObsProgramParametersException, UnableToGenerateTPTimeEstimateException {
        if (list == null || list.isEmpty()) {
            throw new NullPointerException("Illegal argument. The argument cannot be null or empty: allTPSScienceSBs");
        }
        Time time = Time.createTime();
        for (SchedBlock schedBlock : list) {
            time.aggregate(this.getTPCalibrationTime(schedBlock));
        }
        return time;
    }

    private Time getTPCalibrationTime(@NonNull SchedBlock schedBlock) throws InvalidObsProgramParametersException, UnableToGenerateTPTimeEstimateException {
        if (schedBlock == null) {
            throw new NullPointerException("tpScienceSB is marked non-null but is null");
        }
        if (!schedBlock.isTotalPowerScienceSB()) {
            throw new IllegalArgumentException("Illegal argument: tpScienceSB.isTotalPowerScienceSB() (" + schedBlock.isTotalPowerScienceSB() + ") did not pass the test: tpScienceSB.isTotalPowerScienceSB() test");
        }
        Time time = this.getTimeObservingOFFPosition(schedBlock);
        Time time2 = this.getFocusCalTime();
        Time time3 = Time.createTimeSec(120.0);
        int n = schedBlock.getSchedBlockControl().getExecutionCount();
        return (Time)((Time)((Time)time.plus((AbstractDoubleWithUnit)time2)).plus((AbstractDoubleWithUnit)time3)).multiply(n);
    }

    private Time getFocusCalTime() {
        Time time = Time.createTime();
        ReceiverBand receiverBand = this.scienceGoal.getReceiverBand();
        if (receiverBand == null) {
            throw new WizardSBGenerationException("Unable to determine the rxb");
        }
        if (ReceiverBand.getReceiverBands(7, 8).contains(receiverBand)) {
            time.aggregate(Time.createTimeMin(2.5));
        }
        return time;
    }

    private Time getTimeObservingOFFPosition(@NonNull SchedBlock schedBlock) throws UnableToGenerateTPTimeEstimateException {
        if (schedBlock == null) {
            throw new NullPointerException("schedBlock is marked non-null but is null");
        }
        Time time = Time.createTime();
        for (Target target : schedBlock.getAllTargets(ScienceParameters.scienceParametersFilter)) {
            double d = target.getFieldSource().getReference()[0].getSubScanDuration().getSecs();
            ScienceParameters scienceParameters = target.getFirstScienceParameters().orElseThrow(UnableToGenerateTPTimeEstimateException::new);
            TPRasterData tPRasterData = scienceParameters.getTPRasterData().orElseThrow(UnableToGenerateTPTimeEstimateException::new);
            double d2 = scienceParameters.getIntegrationTime().getSecs();
            long l = Math.round(d2 / tPRasterData.getT_rect().getSecs());
            time.aggregate(Time.createTimeSec(d * (double)tPRasterData.getN_rows() * (double)l));
        }
        return time;
    }

    private List<SchedBlock> findAllTPScienceSBs(@NonNull ObsUnitSet obsUnitSet) throws UnknownEntityException {
        if (obsUnitSet == null) {
            throw new NullPointerException("rootOUS is marked non-null but is null");
        }
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        SchedBlockWorker.findSBsUnderOUS(arrayList, obsUnitSet);
        return arrayList.stream().filter(schedBlock -> schedBlock.isTotalPowerScienceSB()).toList();
    }

    public Time getOverheadTimes(Boolean bl, EnumSet<ObservingTimeCalculator.CalibrationOverheads> enumSet) throws UnableToGenerateTPTimeEstimateException, UnknownEntityException, InvalidObsProgramParametersException {
        ObsUnitSet obsUnitSet;
        try {
            obsUnitSet = this.otc.generateSBs(this.scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new UnableToGenerateTPTimeEstimateException();
        }
        assert (obsUnitSet != null);
        List<SchedBlock> list = this.findAllTPScienceSBs(obsUnitSet);
        if (list == null || list.isEmpty()) {
            return Time.createTime();
        }
        Time time = enumSet.contains((Object)ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONEXECTIMES) ? this.getTPCalibrationTime(list) : Time.createTime();
        Time time2 = enumSet.contains((Object)ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONOVERHEADS) ? this.getTPOverheadTime(list) : Time.createTime();
        int n = bl != false ? 1 : this.getNoOfVisits();
        return (Time)((Time)time.plus((AbstractDoubleWithUnit)time2)).multiply(n);
    }

    public static class UnableToGenerateTPTimeEstimateException
    extends Exception {
    }
}

