/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.capabilities.OTConfigurationHelper;
import alma.observatorycharacteristics.configuration.VLBIFrequencyBands;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.valuetypes.Frequency;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public class VLBIExpert {
    public static boolean IS_VLBI_SPECTRALLINE_ENABLED = false;

    public static void setToVLBIDefaultSpectralConfiguration(@NonNull ObsProposal obsProposal) throws InvalidVLBIModeException {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        List<ScienceGoal> list = Arrays.asList(obsProposal.getAbstractScienceGoalScienceGoal());
        list.stream().forEach(scienceGoal -> {
            try {
                VLBIExpert.setToVLBIDefaultSpectralConfiguration(scienceGoal);
            }
            catch (InvalidVLBIModeException invalidVLBIModeException) {
                Log.logger(VLBIExpert.class).warning("Unable to determine ");
            }
        });
    }

    public static void setToVLBIDefaultSpectralConfiguration(@NonNull ScienceGoal scienceGoal) throws InvalidVLBIModeException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = ObsProposal.isProposalVLBI();
            bl2 = ObsProposal.isProposalPhasedArray();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(VLBIExpert.class).warning("Unable to determine if VLBI " + unknownEntityException.getMessage());
        }
        if (!bl && !bl2 || bl2 && bl) {
            throw new InvalidVLBIModeException("Unable to determine VLBI mode");
        }
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        VLBIFrequencyBands vLBIFrequencyBands = bl ? almaCapabilities.getVLBIBands() : almaCapabilities.getVLBIPhaserBands();
        VLBIFrequencyBands.VLBIBands vLBIBands = vLBIFrequencyBands.getVLBIBands().get(0);
        assert (vLBIBands != null);
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        spectralSetupParameters.setSpectralType(SpectralSetupParameters.SpectralSetupTypeChoice.SINGLECONTINUUM);
        List<Frequency> list = OTConfigurationHelper.getFrequencyList(vLBIBands.getSPWFrequency());
        spectralSetupParameters.createContinuumVLBIWindows(list);
        spectralSetupParameters.setSingleContinuumFrequency(OTConfigurationHelper.getFrequency(vLBIBands.getLO1Frequency()));
        spectralSetupParameters.setSingleContinuumCorrelatorMode(SpectralSetupParameters.SINGLECONTINUUMCORRELATORMODE_HIGHRES);
    }

    public static boolean isPassivePhasingEnabled(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        return Arrays.asList(scienceGoal.getTargetParameters()).stream().anyMatch(targetParameters -> targetParameters.getExpectedProperties().getIsPassivePhasing());
    }

    public static boolean isScienceGoalLegalVLBISpectralLine(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (!IS_VLBI_SPECTRALLINE_ENABLED) {
            return false;
        }
        boolean bl = false;
        try {
            bl = ObsProposal.isVLBIRelated();
        }
        catch (Exception exception) {
            return false;
        }
        return bl && scienceGoal.getSpectralSetupParameters().isSpectralLine();
    }

    static {
        IS_VLBI_SPECTRALLINE_ENABLED = AlmaPolicies.getInstance().isVLBISpectralLineEnabled();
        Log.logger(VLBIExpert.class).info("VLBI spectral line mode is " + (IS_VLBI_SPECTRALLINE_ENABLED ? "enabled" : "disabled"));
    }

    public static class InvalidVLBIModeException
    extends Exception {
        InvalidVLBIModeException(String string) {
            super(string);
        }
    }
}

