/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.calibrators;

import alma.common.sourcecatalog.Measurement;
import alma.common.sourcecatalog.utilities.TextUtils;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.mvc.InvalidCoordException;
import alma.obsprep.guiutil.mvc.OutOfRangeException;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.services.experts.calibrators.MeasurementTableModel;
import alma.obsprep.util.Convert;
import alma.valuetypes.Latitude;
import alma.valuetypes.Longitude;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CalibratorExpertDialog
implements ActionListener,
WindowListener {
    private JDialog dialog;
    private final MeasurementTableModel model;
    private final int[] rows;
    private GridBagLayout l;
    private GridBagConstraints c;
    private OTButtonGroup copySpectralSpec;
    private JCheckBox useAsAmplitude;
    private JCheckBox useAsPhase;
    private JCheckBox useAsPointing;
    private JCheckBox useAsPolarization;
    private JCheckBox useAsFocus;
    private JCheckBox useAsBandpass;
    private JCheckBox useAsAtmospheric;
    private JCheckBox useAsDelay;
    private JCheckBox useAsCheckSource;
    private JCheckBox useAsSidebandRatio;
    private JCheckBox useAsDGCReference;
    private JCheckBox useAsDGCScience;
    private static boolean defaultUseAsAmplitude = true;
    private static boolean defaultUseAsPhase = true;
    private static boolean defaultUseAsPointing = true;
    private static boolean defaultUseAsPolarization = true;
    private static boolean defaultUseAsFocus = true;
    private static boolean defaultUseAsBandpass = true;
    private static boolean defaultUseAsAtmospheric = true;
    private static boolean defaultUseAsDelay = true;
    private static boolean defaultUseAsCheckSource = true;
    private static boolean defaultUseAsSidebandRatio = true;
    private static boolean defaultUseAsDGCReference = true;
    private JButton okButton;
    private JButton cancelButton;
    private boolean okPressed = false;
    private boolean cancelPressed = false;
    public static final String SPECTRALSPEC_COPY = "Copy to new setup";
    public static final String SPECTRALSPEC_LINK = "Link to same setup";
    public static final String SPECTRALSPEC_NOTHING = "Do nothing";
    String[] spectralSpecOptions = new String[]{"Copy to new setup", "Link to same setup", "Do nothing"};

    public CalibratorExpertDialog(Frame frame, String string, MeasurementTableModel measurementTableModel, int[] nArray, int n, boolean bl) {
        this.model = measurementTableModel;
        this.rows = nArray;
        this.buildDialog(frame, string, n, bl);
    }

    private void buildDialog(Frame frame, String string, int n, boolean bl) {
        this.dialog = new JDialog(frame, string, true);
        this.l = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.c.gridy = -1;
        this.c.anchor = 18;
        this.dialog.getContentPane().setLayout(this.l);
        this.addCalibratorTable();
        this.addGroups(n, bl);
        this.addButtons();
        this.dialog.setDefaultCloseOperation(1);
        this.dialog.addWindowListener(this);
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    private void addButtons() {
        this.okButton = new JButton("OK");
        this.cancelButton = new JButton("Cancel");
        this.okButton.setMinimumSize(this.cancelButton.getMinimumSize());
        this.okButton.setPreferredSize(this.cancelButton.getPreferredSize());
        this.okButton.setMaximumSize(this.cancelButton.getMaximumSize());
        this.newline();
        this.c.gridwidth = 1;
        for (int i = 0; i < 4; ++i) {
            Component component = Box.createRigidArea(this.cancelButton.getPreferredSize());
            this.add(component);
            ++this.c.gridx;
        }
        this.add(this.okButton);
        ++this.c.gridx;
        this.add(this.cancelButton);
        ++this.c.gridx;
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    private void addGroups(int n, boolean bl) {
        this.newline();
        this.c.fill = 2;
        this.c.gridwidth = 3;
        this.add(this.createTypeGroup(n));
        this.c.gridx += 3;
        this.add(this.createCopyGroup(bl));
        this.c.fill = 0;
    }

    private JComponent createCopyGroup(boolean bl) {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = -1;
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createTitledBorder("Copy SpectralSpec"));
        this.copySpectralSpec = new OTButtonGroup(this.spectralSpecOptions, 1);
        this.copySpectralSpec.setSelectedItem(SPECTRALSPEC_COPY);
        this.copySpectralSpec.setEnabled(bl);
        this.copySpectralSpec.setToolTipText("Select \"Copy\" or \"Link\" to copy or link the Observing Target's spectral spec and source velocity to the new calibrator(s)");
        this.newline(gridBagConstraints);
        gridBagLayout.setConstraints(this.copySpectralSpec, gridBagConstraints);
        jPanel.add(this.copySpectralSpec);
        ++gridBagConstraints.gridx;
        return jPanel;
    }

    private JComponent createTypeGroup(int n) {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = -1;
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createTitledBorder("Calibrator type"));
        this.useAsAmplitude = new JCheckBox();
        this.useAsPhase = new JCheckBox();
        this.useAsPointing = new JCheckBox();
        this.useAsPolarization = new JCheckBox();
        this.useAsFocus = new JCheckBox();
        this.useAsBandpass = new JCheckBox();
        this.useAsAtmospheric = new JCheckBox();
        this.useAsDelay = new JCheckBox();
        this.useAsSidebandRatio = new JCheckBox();
        this.useAsDGCReference = new JCheckBox();
        this.useAsDGCScience = new JCheckBox();
        if (n == 6) {
            this.useAsAmplitude.setSelected(defaultUseAsAmplitude);
            this.useAsPhase.setSelected(defaultUseAsPhase);
            this.useAsPointing.setSelected(defaultUseAsPointing);
            this.useAsPolarization.setSelected(defaultUseAsPolarization);
            this.useAsFocus.setSelected(defaultUseAsFocus);
            this.useAsBandpass.setSelected(defaultUseAsBandpass);
            this.useAsAtmospheric.setSelected(defaultUseAsAtmospheric);
            this.useAsDelay.setSelected(defaultUseAsDelay);
            this.useAsCheckSource.setSelected(defaultUseAsCheckSource);
            this.useAsSidebandRatio.setSelected(defaultUseAsSidebandRatio);
            this.useAsDGCReference.setSelected(defaultUseAsDGCReference);
            this.useAsDGCScience.setSelected(defaultUseAsDGCReference);
        } else {
            this.useAsAmplitude.setSelected(n == 0);
            this.useAsPhase.setSelected(n == 1);
            this.useAsPointing.setSelected(n == 2);
            this.useAsPolarization.setSelected(n == 3);
            this.useAsFocus.setSelected(n == 4);
            this.useAsBandpass.setSelected(n == 5);
        }
        this.newline(gridBagConstraints);
        gridBagLayout.setConstraints(this.useAsAmplitude, gridBagConstraints);
        jPanel.add(this.useAsAmplitude);
        ++gridBagConstraints.gridx;
        JLabel jLabel = new JLabel("Amplitude");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.newline(gridBagConstraints);
        gridBagLayout.setConstraints(this.useAsPhase, gridBagConstraints);
        jPanel.add(this.useAsPhase);
        ++gridBagConstraints.gridx;
        jLabel = new JLabel("Phase");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.newline(gridBagConstraints);
        gridBagLayout.setConstraints(this.useAsPointing, gridBagConstraints);
        jPanel.add(this.useAsPointing);
        ++gridBagConstraints.gridx;
        jLabel = new JLabel("Pointing");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.newline(gridBagConstraints);
        gridBagLayout.setConstraints(this.useAsPolarization, gridBagConstraints);
        jPanel.add(this.useAsPolarization);
        ++gridBagConstraints.gridx;
        jLabel = new JLabel("Polarization");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.newline(gridBagConstraints);
        gridBagLayout.setConstraints(this.useAsFocus, gridBagConstraints);
        jPanel.add(this.useAsFocus);
        ++gridBagConstraints.gridx;
        jLabel = new JLabel("Focus");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.newline(gridBagConstraints);
        gridBagLayout.setConstraints(this.useAsBandpass, gridBagConstraints);
        jPanel.add(this.useAsBandpass);
        ++gridBagConstraints.gridx;
        jLabel = new JLabel("Bandpass");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.newline(gridBagConstraints);
        gridBagLayout.setConstraints(this.useAsAtmospheric, gridBagConstraints);
        jPanel.add(this.useAsAtmospheric);
        ++gridBagConstraints.gridx;
        jLabel = new JLabel("Atmospheric");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.newline(gridBagConstraints);
        gridBagLayout.setConstraints(this.useAsDelay, gridBagConstraints);
        jPanel.add(this.useAsDelay);
        ++gridBagConstraints.gridx;
        jLabel = new JLabel("Delay");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.newline(gridBagConstraints);
        gridBagLayout.setConstraints(this.useAsCheckSource, gridBagConstraints);
        jPanel.add(this.useAsCheckSource);
        ++gridBagConstraints.gridx;
        jLabel = new JLabel("Check Source");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.newline(gridBagConstraints);
        gridBagLayout.setConstraints(this.useAsSidebandRatio, gridBagConstraints);
        jPanel.add(this.useAsSidebandRatio);
        ++gridBagConstraints.gridx;
        jLabel = new JLabel("Sideband Ratio");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        return jPanel;
    }

    private void newline(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
    }

    private void newline() {
        this.newline(this.c);
    }

    private void add(Component component) {
        this.l.setConstraints(component, this.c);
        this.dialog.getContentPane().add(component);
    }

    private void addCalibratorTable() {
        JLabel jLabel = this.rows.length == 1 ? new JLabel("1 calibrator selected") : new JLabel(this.rows.length + " calibrators selected");
        this.newline();
        this.c.gridwidth = 6;
        this.add(jLabel);
        this.newline();
        this.c.gridwidth = 2;
        this.add(new JLabel("Source Name"));
        this.c.gridx += 2;
        this.add(new JLabel("RA"));
        this.c.gridx += 2;
        this.add(new JLabel("Dec"));
        for (int i = 0; i < this.rows.length; ++i) {
            Object object;
            int n = this.rows[i];
            Measurement measurement = this.model.get(n);
            this.newline();
            this.add(new JLabel(TextUtils.join((Collection)measurement.getNames(), (String)";")));
            this.c.gridx += 2;
            String string = "N/A";
            if (measurement.getRa() != null) {
                object = Longitude.createLongitude((double)measurement.getRa(), (String)Longitude.UNIT_DEG);
                string = object.toString();
                try {
                    string = Convert.degToHHMMSS(object.getContent());
                }
                catch (OutOfRangeException outOfRangeException) {
                }
                catch (InvalidCoordException invalidCoordException) {
                    // empty catch block
                }
            }
            this.add(new JLabel(string));
            this.c.gridx += 2;
            string = "N/A";
            if (measurement.getDec() != null) {
                object = Latitude.createLatitude((double)measurement.getDec(), (String)Latitude.UNIT_DEG);
                string = object.toString();
                try {
                    string = Convert.degToDDMMSS(object.getContent());
                }
                catch (InvalidCoordException | OutOfRangeException exception) {
                    // empty catch block
                }
            }
            this.add(new JLabel(string));
            this.c.gridx += 2;
        }
    }

    public String getCopySpectralSpec() {
        return this.copySpectralSpec.getSelectedItem();
    }

    public boolean getUseAsAmplitude() {
        return this.useAsAmplitude.isSelected();
    }

    public boolean getUseAsPhase() {
        return this.useAsPhase.isSelected();
    }

    public boolean getUseAsPointing() {
        return this.useAsPointing.isSelected();
    }

    public boolean getUseAsPolarization() {
        return this.useAsPolarization.isSelected();
    }

    public boolean getUseAsFocus() {
        return this.useAsFocus.isSelected();
    }

    public boolean getUseAsBandpass() {
        return this.useAsBandpass.isSelected();
    }

    public boolean getUseAsAtmospheric() {
        return this.useAsAtmospheric.isSelected();
    }

    public boolean getUseAsDelay() {
        return this.useAsDelay.isSelected();
    }

    public boolean getUseAsCheckSource() {
        return this.useAsCheckSource.isSelected();
    }

    public boolean getUseAsSidebandRatio() {
        return this.useAsSidebandRatio.isSelected();
    }

    public boolean cancelPressed() {
        return this.cancelPressed;
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)actionEvent.getSource();
        if (jButton.equals(this.okButton)) {
            defaultUseAsAmplitude = this.useAsAmplitude.isSelected();
            defaultUseAsPhase = this.useAsPhase.isSelected();
            defaultUseAsPointing = this.useAsPointing.isSelected();
            defaultUseAsPolarization = this.useAsPolarization.isSelected();
            defaultUseAsFocus = this.useAsFocus.isSelected();
            defaultUseAsBandpass = this.useAsBandpass.isSelected();
            defaultUseAsAtmospheric = this.useAsAtmospheric.isSelected();
            defaultUseAsDelay = this.useAsDelay.isSelected();
            defaultUseAsSidebandRatio = this.useAsSidebandRatio.isSelected();
            this.okPressed = true;
            this.dialog.setVisible(false);
        } else if (jButton.equals(this.cancelButton)) {
            this.cancelPressed = true;
            this.dialog.setVisible(false);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        Log.logger((Object)this).finest("windowActivated(ev)");
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        Log.logger((Object)this).finest("windowClosed(ev)");
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.cancelPressed = true;
        Log.logger((Object)this).finest("windowClosing(ev)");
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        Log.logger((Object)this).finest("windowDeactivated(ev)");
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        Log.logger((Object)this).finest("windowDeiconified(ev)");
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        Log.logger((Object)this).finest("windowIconified(ev)");
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        Log.logger((Object)this).finest("windowOpened(ev)");
    }

    public boolean getUseAsDGCReference() {
        return this.useAsDGCReference.isSelected();
    }

    public boolean getUseAsDGCScience() {
        return this.useAsDGCScience.isSelected();
    }
}

