/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.experts.spectralline.gui;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.services.experts.spectralline.SlapParser;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.experts.spectralline.SpectralLineCatalogue;
import alma.obsprep.services.experts.spectralline.gui.FilteredCatalogueControlPanel;
import alma.obsprep.services.experts.spectralline.gui.MaxFrequencyToBandConverter;
import alma.obsprep.services.experts.spectralline.gui.MinFrequencyToBandConverter;
import alma.obsprep.services.experts.spectralline.gui.RestrictedSearchButton;
import alma.obsprep.services.experts.spectralline.gui.UndeletableSuffixNavigationFilter;
import alma.obsprep.services.network.AlmaSlapCatalog;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.UnitMapConfigurator;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import jsky.catalog.BasicQueryArgs;
import jsky.catalog.Catalog;
import jsky.catalog.QueryArgs;
import jsky.catalog.QueryResult;
import jsky.catalog.vo.VoTable;
import jsky.util.gui.ProgressException;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;

public class SearchDialog
extends JDialog
implements ItemListener {
    private static final long serialVersionUID = -5806628305309957986L;
    public static final DialogId SLAP_RESULTS_NOTIFICATION = new DialogId("SlapService.results");
    public static final URL SLAP_URL;
    private static final String prefix = "*";
    private static final String suffix = "*";
    private JSlider almaBandSlider;
    private JPanel cards;
    private JComboBox<String> frequencyConstraintComboBox;
    private JSpinner maxFrequencySpinner;
    private JSpinner minFrequencySpinner;
    private RestrictedSearchButton searchButton;
    private OTTextField speciesTextField;
    private String chemicalSpecies = null;
    private static final String ALMA_BAND_CARD = "ALMA Band";
    private static final String FREQUENCY_CARD = "Sky Frequency (GHz)";
    private final Velocity velocity;
    private JCheckBox exactMatchCheckBox;
    private UndeletableSuffixNavigationFilter speciesFieldFilter;
    private boolean isExactTextMatchRequested = false;

    public SearchDialog(Frame frame) {
        this((Window)frame, Velocity.createVelocity());
    }

    public SearchDialog(Window window, Velocity velocity) {
        super(window);
        this.velocity = velocity.deepCopy();
        this.initComponents();
    }

    public void setPartialFilter(String string) {
        String string2 = string.replace("*", "");
        this.speciesTextField.setText("*" + string2 + "*");
    }

    public void setFullFilter(String string) {
        String string2 = string.replace("*", "");
        this.speciesTextField.setText(string2);
    }

    public void setBand(int n) {
        this.frequencyConstraintComboBox.setSelectedItem(ALMA_BAND_CARD);
        this.almaBandSlider.setValue(n);
    }

    public void setFrequencies(Frequency frequency, Frequency frequency2) {
        this.frequencyConstraintComboBox.setSelectedItem(FREQUENCY_CARD);
        this.minFrequencySpinner.setValue(frequency.getContentInGHz());
        this.maxFrequencySpinner.setValue(frequency2.getContentInGHz());
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        this.speciesTextField = new OTTextField("**");
        JLabel jLabel2 = new JLabel("e.g. *NH3*");
        jLabel2.setFont(new Font("Helvetica", 2, 10));
        this.speciesFieldFilter = new UndeletableSuffixNavigationFilter("*".length(), "*".length(), this.speciesTextField);
        this.speciesTextField.setNavigationFilter(this.speciesFieldFilter);
        JLabel jLabel3 = new JLabel("Note: no quantum numbers or descriptions");
        jLabel3.setFont(jLabel3.getFont().deriveFont(jLabel3.getFont().getStyle() | 2));
        JLabel jLabel4 = new JLabel();
        JSeparator jSeparator = new JSeparator();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.frequencyConstraintComboBox = new JComboBox();
        JLabel jLabel5 = new JLabel();
        this.cards = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.almaBandSlider = new JSlider();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel6 = new JLabel();
        JLabel jLabel7 = new JLabel();
        this.maxFrequencySpinner = new JSpinner();
        this.minFrequencySpinner = new JSpinner();
        JSeparator jSeparator2 = new JSeparator();
        this.searchButton = new RestrictedSearchButton("*".length(), "*".length());
        JLabel jLabel8 = new JLabel();
        this.exactMatchCheckBox = new JCheckBox("Exact text match");
        this.exactMatchCheckBox.setName("SearchDialog.exactSearchMatch");
        this.exactMatchCheckBox.setToolTipText("When selected, indicates that a exact match on the species entered is expected");
        this.exactMatchCheckBox.addItemListener(this);
        this.setDefaultCloseOperation(2);
        this.setTitle("Search Online");
        this.setResizable(false);
        jLabel.setFont(jLabel.getFont().deriveFont(jLabel.getFont().getStyle() | 1));
        jLabel.setText("Species");
        jLabel4.setText("Search species for");
        jPanel.setLayout(new BorderLayout());
        this.frequencyConstraintComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{ALMA_BAND_CARD, FREQUENCY_CARD}));
        this.frequencyConstraintComboBox.addItemListener(itemEvent -> this.frequencyConstraintComboBoxItemStateChanged(itemEvent));
        jLabel5.setText("Search by");
        GroupLayout groupLayout = new GroupLayout(jPanel2);
        jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.frequencyConstraintComboBox, -2, -1, -2)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel5).addComponent(this.frequencyConstraintComboBox, -2, -1, -2)));
        jPanel.add((Component)jPanel2, "Center");
        this.cards.setLayout(new CardLayout());
        new Hashtable();
        Collection<ReceiverBand> collection = ReceiverBand.getKnownReceiverBands();
        Optional<ReceiverBand> optional = collection.stream().min((receiverBand, receiverBand2) -> Integer.compare(receiverBand.getNumber(), receiverBand2.getNumber()));
        this.almaBandSlider.setMinimum(optional.get().getNumber());
        this.almaBandSlider.setMajorTickSpacing(1);
        this.almaBandSlider.setMaximum(10);
        this.almaBandSlider.setPaintLabels(true);
        this.almaBandSlider.setPaintTicks(true);
        this.almaBandSlider.setSnapToTicks(true);
        this.almaBandSlider.setValue(optional.get().getNumber());
        this.almaBandSlider.setPaintTrack(false);
        GroupLayout groupLayout2 = new GroupLayout(jPanel3);
        jPanel3.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.almaBandSlider, -1, 265, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.almaBandSlider, -2, 54, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.cards.add((Component)jPanel3, ALMA_BAND_CARD);
        jLabel6.setLabelFor(this.minFrequencySpinner);
        jLabel6.setText("Min");
        jLabel7.setLabelFor(this.maxFrequencySpinner);
        jLabel7.setText("Max");
        ReceiverBand receiverBand3 = optional.get();
        double d = receiverBand3.getRFMin();
        double d2 = receiverBand3.getRFMax();
        this.minFrequencySpinner.setModel(new SpinnerNumberModel(d, d, 950.0, 1.0));
        this.maxFrequencySpinner.setModel(new SpinnerNumberModel(d2, d, 950.0, 1.0));
        GroupLayout groupLayout3 = new GroupLayout(jPanel4);
        jPanel4.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minFrequencySpinner, -2, 69, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxFrequencySpinner, -2, 69, Short.MAX_VALUE).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel6).addComponent(jLabel7).addComponent(this.maxFrequencySpinner, -2, -1, -2).addComponent(this.minFrequencySpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cards.add((Component)jPanel4, FREQUENCY_CARD);
        jPanel.add((Component)this.cards, "Last");
        this.searchButton.setText("Search");
        this.searchButton.addActionListener(this::searchButtonActionPerformed);
        jLabel8.setFont(jLabel8.getFont().deriveFont(jLabel8.getFont().getStyle() | 1));
        jLabel8.setText("Sky Frequency");
        GroupLayout groupLayout4 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel, -1, 233, Short.MAX_VALUE).addComponent(jSeparator, -1, 233, Short.MAX_VALUE).addComponent(jLabel).addGroup(groupLayout4.createSequentialGroup().addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.speciesTextField, -1, 118, Short.MAX_VALUE)).addComponent(jLabel2).addComponent(jLabel3).addComponent(jLabel8).addComponent(jSeparator2, -1, 233, Short.MAX_VALUE).addComponent(this.searchButton, -1, 233, Short.MAX_VALUE)).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(jLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.speciesTextField, -2, -1, -2).addComponent(jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel2, -2, -1, -2).addComponent(jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jSeparator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel, -2, -1, -2).addComponent(jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchButton).addContainerGap(-1, Short.MAX_VALUE)));
        BindingGroup bindingGroup = new BindingGroup();
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.minFrequencySpinner, (Property)BeanProperty.create((String)"value"), (Object)this.almaBandSlider, (Property)BeanProperty.create((String)"value"));
        autoBinding.setConverter((Converter)new MinFrequencyToBandConverter());
        bindingGroup.addBinding((Binding)autoBinding);
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.maxFrequencySpinner, (Property)BeanProperty.create((String)"value"), (Object)this.almaBandSlider, (Property)BeanProperty.create((String)"value"));
        autoBinding.setConverter((Converter)new MaxFrequencyToBandConverter());
        bindingGroup.addBinding((Binding)autoBinding);
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.minFrequencySpinner, (Property)BeanProperty.create((String)"value"), (Object)this.searchButton, (Property)BeanProperty.create((String)"minFrequency"));
        bindingGroup.addBinding((Binding)autoBinding);
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.maxFrequencySpinner, (Property)BeanProperty.create((String)"value"), (Object)this.searchButton, (Property)BeanProperty.create((String)"maxFrequency"));
        bindingGroup.addBinding((Binding)autoBinding);
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.speciesTextField, (Property)BeanProperty.create((String)"text"), (Object)this.searchButton, (Property)BeanProperty.create((String)"species"));
        bindingGroup.addBinding((Binding)autoBinding);
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.exactMatchCheckBox, (Property)BeanProperty.create((String)"value"), (Object)this.searchButton, (Property)BeanProperty.create((String)"s"));
        bindingGroup.addBinding((Binding)autoBinding);
        bindingGroup.bind();
        this.pack();
        jPanel3.setName("SearchDialog.almaBandCard");
        this.almaBandSlider.setName("SearchDialog.almaBandSlider");
        this.cards.setName("SearchDialog.cards");
        jPanel2.setName("SearchDialog.comboBoxPane");
        jPanel4.setName("SearchDialog.frequencyCard");
        this.frequencyConstraintComboBox.setName("SearchDialog.frequencyConstraintComboBox");
        jLabel5.setName("SearchDialog.frequencyConstraintLabel");
        jPanel.setName("SearchDialog.frequencyConstraintPanel");
        jLabel7.setName("SearchDialog.maxFrequencyLabel");
        this.maxFrequencySpinner.setName("SearchDialog.maxFrequencySpinner");
        this.searchButton.setName("SearchDialog.searchButton");
        jSeparator.setName("SearchDialog.separator1");
        jSeparator2.setName("SearchDialog.separator2");
        jLabel8.setName("SearchDialog.skyFrequencyTitle");
        jLabel3.setName("SearchDialog.speciesHint");
        jLabel4.setName("SearchDialog.speciesLabel");
        this.speciesTextField.setName("SearchDialog.speciesTextField");
        jLabel.setName("SearchDialog.speciesTitle");
    }

    private void frequencyConstraintComboBoxItemStateChanged(ItemEvent itemEvent) {
        CardLayout cardLayout = (CardLayout)this.cards.getLayout();
        cardLayout.show(this.cards, (String)itemEvent.getItem());
    }

    private double getMinWavelength() {
        Double d = (Double)this.maxFrequencySpinner.getValue();
        Frequency frequency = Frequency.createFrequencyGHZ(d);
        Frequency frequency2 = this.velocity.reverseShift(frequency);
        return 2.99792458E8 / frequency2.getContentInUnits(Frequency.UNIT_HZ);
    }

    private double getMaxWavelength() {
        Double d = (Double)this.minFrequencySpinner.getValue();
        Frequency frequency = Frequency.createFrequencyGHZ(d);
        Frequency frequency2 = this.velocity.reverseShift(frequency);
        return 2.99792458E8 / frequency2.getContentInUnits(Frequency.UNIT_HZ);
    }

    private void searchButtonActionPerformed(ActionEvent actionEvent) {
        this.searchButton.setSearchInProgress(true);
        final String string = this.speciesTextField.getText();
        final double d = this.getMinWavelength();
        final double d2 = this.getMaxWavelength();
        SwingWorker<List<SpectralLine>, Void> swingWorker = new SwingWorker<List<SpectralLine>, Void>(){
            private boolean tooManyResults = false;

            private QueryArgs constructQueryArgs(AlmaSlapCatalog almaSlapCatalog) {
                BasicQueryArgs basicQueryArgs = new BasicQueryArgs((Catalog)almaSlapCatalog);
                if (string.length() > "*".length() + "*".length()) {
                    try {
                        SearchDialog.this.chemicalSpecies = SearchDialog.this.isExactTextMatchRequested ? URLEncoder.encode(string, Charset.defaultCharset().name()) : URLEncoder.encode(string.substring("*".length(), string.length() - "*".length()), Charset.defaultCharset().name());
                        assert (SearchDialog.this.chemicalSpecies != null);
                        basicQueryArgs.setParamValue("CHEMICAL_ELEMENT", (Object)SearchDialog.this.chemicalSpecies);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                    }
                }
                String string2 = Double.toString(d) + "/" + Double.toString(d2);
                basicQueryArgs.setParamValue("WAVELENGTH", (Object)string2);
                return basicQueryArgs;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected List<SpectralLine> doInBackground() throws Exception {
                AlmaSlapCatalog almaSlapCatalog = new AlmaSlapCatalog("Splatalogue Simple Line Access Service", SLAP_URL);
                QueryArgs queryArgs = this.constructQueryArgs(almaSlapCatalog);
                QueryResult queryResult = null;
                Log.logger((Object)this).info("SLAP server query to server " + String.valueOf(SLAP_URL) + "?REQUEST=queryData&" + String.valueOf(queryArgs));
                try {
                    queryResult = almaSlapCatalog.query(queryArgs);
                }
                catch (ProgressException progressException) {
                    this.cancel(true);
                    throw progressException;
                }
                if (queryResult instanceof VoTable) {
                    VoTable voTable = (VoTable)queryResult;
                    if (voTable.getRowCount() >= 10000) {
                        this.tooManyResults = true;
                        return Collections.emptyList();
                    }
                    SlapParser slapParser = new SlapParser();
                    List<SpectralLine> list = slapParser.parse(voTable, SearchDialog.this.chemicalSpecies, SearchDialog.this.isExactTextMatchRequested);
                    ArrayList<SpectralLine> arrayList = new ArrayList<SpectralLine>();
                    for (SpectralLine spectralLine : list) {
                        double d3 = spectralLine.getFrequencyInGHz();
                        if (!Double.isInfinite(d3) && !Double.isNaN(d3)) continue;
                        arrayList.add(spectralLine);
                    }
                    list.removeAll(arrayList);
                    Iterator<SpectralLine> iterator = SpectralLineCatalogue.getInstance().getRootCatalogue();
                    iterator.getReadWriteLock().writeLock().lock();
                    try {
                        iterator.addAll(list);
                    }
                    finally {
                        iterator.getReadWriteLock().writeLock().unlock();
                    }
                    return list;
                }
                return Collections.emptyList();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void done() {
                block18: {
                    try {
                        List list;
                        if (this.isDone() && this.isCancelled()) {
                            return;
                        }
                        try {
                            list = (List)this.get();
                        }
                        catch (InterruptedException | CancellationException exception) {
                            SearchDialog.this.searchButton.setSearchInProgress(false);
                            return;
                        }
                        catch (ExecutionException executionException) {
                            Throwable throwable = executionException.getCause();
                            if (throwable instanceof UnknownHostException) {
                                GUIUtilities.info(null, "Could not contact the Splatalogue server\nPlease check your network connection and try again");
                            } else if (!(throwable instanceof ProgressException)) {
                                if (throwable instanceof IOException) {
                                    GUIUtilities.info(null, "A problem was encountered communicating with the Splatalogue server\nPlease try again later");
                                } else {
                                    GUIUtilities.error(null, "Error while searching for lines", executionException);
                                }
                            }
                            SearchDialog.this.searchButton.setSearchInProgress(false);
                            return;
                        }
                        if (this.tooManyResults) {
                            GUIUtilities.info(null, "Your search space was too large.\nPlease try again with a more specific species and/or a reduced frequency range.");
                            return;
                        }
                        Object object = list.isEmpty() ? "No results found" : (list.size() == 1 ? "Added 1 spectral line to the pool" : "Added " + list.size() + " spectral lines to the pool");
                        if (!list.isEmpty()) {
                            FilteredCatalogueControlPanel filteredCatalogueControlPanel = FilteredCatalogueControlPanel.getInstance();
                            Double d3 = (Double)SearchDialog.this.minFrequencySpinner.getValue();
                            Double d22 = (Double)SearchDialog.this.maxFrequencySpinner.getValue();
                            filteredCatalogueControlPanel.setFrequencyRange(d3, d22);
                            filteredCatalogueControlPanel.setFilter(string);
                        }
                        GUIUtilities.infoWithDoNotShowAgain(SLAP_RESULTS_NOTIFICATION, object);
                        break block18;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        SearchDialog.this.searchButton.setSearchInProgress(false);
                    }
                }
            }
        };
        swingWorker.execute();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.exactMatchCheckBox)) {
            this.isExactTextMatchRequested = itemEvent.getStateChange() == 1;
            String string = this.speciesTextField.getText();
            if (this.isExactTextMatchRequested) {
                this.searchButton.setPrefixLength(0);
                this.searchButton.setSuffixLength(0);
                this.speciesFieldFilter.setPrefixLength(0);
                this.speciesFieldFilter.setSuffixLength(0);
                this.setFullFilter(string);
            } else {
                this.searchButton.setPrefixLength("*".length());
                this.searchButton.setSuffixLength("*".length());
                this.speciesFieldFilter.setPrefixLength("*".length());
                this.speciesFieldFilter.setSuffixLength("*".length());
                this.setPartialFilter(string);
            }
        }
    }

    public static void main(String[] stringArray) {
        System.setProperty("otData.dir", "config/otData/");
        UnitMapConfigurator.configureUnitMaps();
        EventQueue.invokeLater(() -> {
            SearchDialog searchDialog = new SearchDialog(new JFrame());
            searchDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            searchDialog.setVisible(true);
        });
    }

    static {
        String string = System.getProperty("obsprep.slap.url");
        if (string == null) {
            string = "https://splatalogue.online/splata-slap/slap";
        }
        try {
            SLAP_URL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Invalid SLAP URL", malformedURLException);
        }
    }
}

