/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.schedblock.AmplitudeCalParameters;
import alma.obsprep.bo.schedblock.AtmosphericCalParameters;
import alma.obsprep.bo.schedblock.BandpassCalParameters;
import alma.obsprep.bo.schedblock.CalibratorParameters;
import alma.obsprep.bo.schedblock.CheckSourceCalParameters;
import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.DGCScienceCalParameters;
import alma.obsprep.bo.schedblock.DelayCalParameters;
import alma.obsprep.bo.schedblock.FocusCalParameters;
import alma.obsprep.bo.schedblock.PhaseCalParameters;
import alma.obsprep.bo.schedblock.PointingCalParameters;
import alma.obsprep.bo.schedblock.PolarizationCalParameters;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.bo.schedblock.SidebandRatioCalParameters;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.generator.CalibratorParametersFactory;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.Time;
import alma.valuetypes.UserAngle;

public abstract class AbstractCalibratorParametersFactory
implements CalibratorParametersFactory {
    protected final CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(CorrelatorType.BL);
    protected final Time integrationTime;
    protected final SpectralSpec spectralSpec;

    public AbstractCalibratorParametersFactory(SpectralSpec spectralSpec) {
        this.spectralSpec = spectralSpec;
        this.integrationTime = this.spectralSpec.getCorrelatorConfiguration().getIntegrationDuration();
    }

    public Time getAlignedSubscanDuration(double d) {
        return this.getAlignedSubscanDuration(Time.createTimeSec(d));
    }

    private Time getAlignedSubscanDuration(Time time) {
        double d = time.getContentInUnits(Time.UNIT_S);
        double d2 = this.integrationTime.getContentInUnits(Time.UNIT_S);
        double d3 = this.correlatorExpert.calcSubscanDuration(d, d2, null);
        return Time.createTime((double)d3, (String)Time.UNIT_S);
    }

    @Override
    public AmplitudeCalParameters getAmplitudeCalParameters(int n) {
        AmplitudeCalParameters amplitudeCalParameters = AmplitudeCalParameters.createAmplitudeCalParameters();
        amplitudeCalParameters.setCycleTime(Time.createTime((double)2.0, (String)Time.UNIT_H));
        amplitudeCalParameters.setName("");
        amplitudeCalParameters.setDefaultIntegrationTime(Time.createTime((double)3.0, (String)Time.UNIT_MIN));
        this.setMissingParameters((CalibratorParameters)((Object)amplitudeCalParameters), n);
        return amplitudeCalParameters;
    }

    @Override
    public AtmosphericCalParameters getAtmosphericCalParameters(int n) {
        AtmosphericCalParameters atmosphericCalParameters = AtmosphericCalParameters.createAtmosphericCalParameters();
        atmosphericCalParameters.setDefaultIntegrationTime(Time.createTime((double)5.0, (String)Time.UNIT_S));
        atmosphericCalParameters.setUseHotLoad(true);
        double d = this.integrationTime.getContentInUnits(Time.UNIT_S);
        double d2 = this.correlatorExpert.calcSubscanDuration(5.0, d, 4);
        atmosphericCalParameters.setSubScanDuration(Time.createTime((double)d2, (String)Time.UNIT_S));
        this.setMissingParameters((CalibratorParameters)((Object)atmosphericCalParameters), n);
        return atmosphericCalParameters;
    }

    @Override
    public BandpassCalParameters getBandpassCalParameters(int n) {
        BandpassCalParameters bandpassCalParameters = BandpassCalParameters.createBandpassCalParameters();
        bandpassCalParameters.setDesiredPhaseAccuracy(Angle.createAngle((double)1.0, (String)Angle.UNIT_ARCSEC));
        bandpassCalParameters.setMaximumElapsedTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
        this.setMissingParameters((CalibratorParameters)((Object)bandpassCalParameters), n);
        return bandpassCalParameters;
    }

    @Override
    public CalibratorParameters getCalibratorParameters(String string, int n) {
        if (string.equals(QuerySource.INTENDEDUSE_AMPLITUDE)) {
            return this.getAmplitudeCalParameters(n);
        }
        if (string.equals(QuerySource.INTENDEDUSE_ATMOSPHERIC)) {
            return this.getAtmosphericCalParameters(n);
        }
        if (string.equals(QuerySource.INTENDEDUSE_BANDPASS)) {
            return this.getBandpassCalParameters(n);
        }
        if (string.equals(QuerySource.INTENDEDUSE_DELAY)) {
            return this.getDelayCalParameters(n);
        }
        if (string.equals(QuerySource.INTENDEDUSE_CHECKSOURCE)) {
            return this.getCheckSourceCalParameters(n);
        }
        if (string.equals(QuerySource.INTENDEDUSE_FOCUS)) {
            return this.getFocusCalParameters(n);
        }
        if (string.equals(QuerySource.INTENDEDUSE_PHASE)) {
            return this.getPhaseCalParameters(n);
        }
        if (string.equals(QuerySource.INTENDEDUSE_POINTING)) {
            return this.getPointingCalParameters(n);
        }
        if (string.equals(QuerySource.INTENDEDUSE_SIDEBANDRATIO)) {
            return this.getSidebandRatioCalParameters(n);
        }
        if (string.equals(QuerySource.INTENDEDUSE_POLARIZATION)) {
            return this.getPolarizationCalParameters(n);
        }
        if (string.equals(QuerySource.INTENDEDUSE_DGCSCIENCE)) {
            return this.getDGCScienceCalParameters(n);
        }
        if (string.equals(QuerySource.INTENDEDUSE_DGCREFERENCE)) {
            return this.getDGCReferenceCalParameters(n);
        }
        throw new AssertionError((Object)("Unhandled calibrator intent: " + string));
    }

    @Override
    public CheckSourceCalParameters getCheckSourceCalParameters(int n) {
        CheckSourceCalParameters checkSourceCalParameters = CheckSourceCalParameters.createCheckSourceCalParameters();
        checkSourceCalParameters.setDefaultIntegrationTime(Time.createTime((double)2.0, (String)Time.UNIT_S));
        checkSourceCalParameters.setCycleTime(Time.createTime((double)4.0, (String)Time.UNIT_H));
        this.setMissingParameters((CalibratorParameters)((Object)checkSourceCalParameters), n);
        return checkSourceCalParameters;
    }

    @Override
    public DelayCalParameters getDelayCalParameters(int n) {
        DelayCalParameters delayCalParameters = DelayCalParameters.createDelayCalParameters();
        delayCalParameters.setDefaultIntegrationTime(Time.createTime((double)2.0, (String)Time.UNIT_S));
        delayCalParameters.setCycleTime(Time.createTime((double)4.0, (String)Time.UNIT_H));
        this.setMissingParameters((CalibratorParameters)((Object)delayCalParameters), n);
        return delayCalParameters;
    }

    @Override
    public DGCReferenceCalParameters getDGCReferenceCalParameters(int n) {
        DGCReferenceCalParameters dGCReferenceCalParameters = DGCReferenceCalParameters.createDGCReferenceCalParameters();
        dGCReferenceCalParameters.setDefaultIntegrationTime(Time.createTimeSec(12.0));
        dGCReferenceCalParameters.setSubScanDuration(this.getAlignedSubscanDuration(12.0));
        this.setMissingParameters((CalibratorParameters)((Object)dGCReferenceCalParameters), n);
        return dGCReferenceCalParameters;
    }

    @Override
    public DGCScienceCalParameters getDGCScienceCalParameters(int n) {
        DGCScienceCalParameters dGCScienceCalParameters = DGCScienceCalParameters.createDGCScienceCalParameters();
        dGCScienceCalParameters.setDefaultIntegrationTime(Time.createTimeSec(24.0));
        dGCScienceCalParameters.setSubScanDuration(this.getAlignedSubscanDuration(24.0));
        dGCScienceCalParameters.setInternalCycleCount(3);
        dGCScienceCalParameters.setExternalCycleTime(Time.createTimeMin(360.0));
        this.setMissingParameters((CalibratorParameters)((Object)dGCScienceCalParameters), n);
        return dGCScienceCalParameters;
    }

    @Override
    public FocusCalParameters getFocusCalParameters(int n) {
        FocusCalParameters focusCalParameters = FocusCalParameters.createFocusCalParameters();
        this.setMissingParameters((CalibratorParameters)((Object)focusCalParameters), n);
        return focusCalParameters;
    }

    @Override
    public PhaseCalParameters getPhaseCalParameters(int n) {
        PhaseCalParameters phaseCalParameters = PhaseCalParameters.createPhaseCalParameters();
        phaseCalParameters.setCycleTime(Time.createTime((double)6.0, (String)Time.UNIT_MIN));
        phaseCalParameters.setName("");
        phaseCalParameters.setDefaultIntegrationTime(Time.createTime((double)30.0, (String)Time.UNIT_S));
        this.setMissingParameters((CalibratorParameters)((Object)phaseCalParameters), n);
        return phaseCalParameters;
    }

    @Override
    public PointingCalParameters getPointingCalParameters(int n) {
        PointingCalParameters pointingCalParameters = PointingCalParameters.createPointingCalParameters();
        pointingCalParameters.setDataOrigin(PointingCalParameters.DATAORIGIN_CHANNEL_AVERAGE_CROSS);
        pointingCalParameters.setMaximumElapsedTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
        Frequency frequency = this.spectralSpec.getRestFrequency();
        UserAngle userAngle = UserAngle.createUserAngle(0.5, UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, frequency);
        Angle angle = Angle.createAngle((double)userAngle.getContentInUnits(Angle.UNIT_ARCSEC), (String)Angle.UNIT_ARCSEC);
        pointingCalParameters.setExcursion(angle);
        pointingCalParameters.setDesiredAccuracy(pointingCalParameters.getExcursion().deepCopy());
        this.setMissingParameters((CalibratorParameters)((Object)pointingCalParameters), n);
        return pointingCalParameters;
    }

    @Override
    public PolarizationCalParameters getPolarizationCalParameters(int n) {
        PolarizationCalParameters polarizationCalParameters = PolarizationCalParameters.createPolarizationCalParameters();
        this.setMissingParameters((CalibratorParameters)((Object)polarizationCalParameters), n);
        return polarizationCalParameters;
    }

    @Override
    public SidebandRatioCalParameters getSidebandRatioCalParameters(int n) {
        SidebandRatioCalParameters sidebandRatioCalParameters = SidebandRatioCalParameters.createSidebandRatioCalParameters();
        this.setMissingParameters((CalibratorParameters)((Object)sidebandRatioCalParameters), n);
        return sidebandRatioCalParameters;
    }

    protected void setMissingParameters(CalibratorParameters calibratorParameters, int n) {
        if (calibratorParameters.getDefaultIntegrationTime().getContent() == 0.0) {
            calibratorParameters.setDefaultIntegrationTime(this.integrationTime.deepCopy());
        }
        if (calibratorParameters.getSubScanDuration().getContent() == 0.0) {
            double d = calibratorParameters.getDefaultIntegrationTime().getContentInUnits(Time.UNIT_S);
            double d2 = this.integrationTime.getContentInUnits(Time.UNIT_S);
            double d3 = this.correlatorExpert.calcSubscanDuration(d, d2, null);
            calibratorParameters.setSubScanDuration(Time.createTime((double)d3, (String)Time.UNIT_S));
        }
        if (calibratorParameters.getCycleTime().getContent() == 0.0) {
            calibratorParameters.setCycleTime(Time.createTime((double)99999.0, (String)Time.UNIT_H));
        }
    }
}

