/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator;

import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.OpticalPointingScienceGoal;
import alma.obsprep.bo.obsproject.OpticalPointingTargetParameters;
import alma.obsprep.bo.schedblock.FieldPattern;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.OpticalCameraSpec;
import alma.obsprep.bo.schedblock.OpticalPointingParameters;
import alma.obsprep.bo.schedblock.OrderedTarget;
import alma.obsprep.bo.schedblock.PointingPattern;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.experts.ObservingModeExpert;
import alma.obsprep.services.generator.SchedBlockGenerator;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Status;
import java.util.EnumSet;

public class OptPointSBGenerator
implements SchedBlockGenerator {
    private OpticalPointingScienceGoal opwParams;
    private ObsUnitSet obsUnitSet;
    static final String mode = "Optical Pointing";

    public OptPointSBGenerator(AbstractScienceGoal abstractScienceGoal, ObsUnitSet obsUnitSet) {
        this.opwParams = (OpticalPointingScienceGoal)((Object)abstractScienceGoal);
        this.obsUnitSet = obsUnitSet;
    }

    @Override
    public void generate() {
        if (!(this.opwParams instanceof OpticalPointingScienceGoal)) {
            return;
        }
        OpticalPointingScienceGoal opticalPointingScienceGoal = this.opwParams;
        String string = opticalPointingScienceGoal.getSchedBlockName();
        if (string.trim().equals("")) {
            string = "OpticalPointing";
        }
        this.obsUnitSet.setName(string);
        SchedBlock schedBlock = SchedBlock.createSchedBlock();
        SBGenerationContext sBGenerationContext = new SBGenerationContext();
        sBGenerationContext.setArray(RequestedArray.TWELVE_M).setSBGenerationSchema(EnumSet.of(SBGeneratorTemplate.SBGenerationSchema.STANDARD)).setSBType(SBGeneratorTemplate.SchedBlockType.TWELVEMEXTENDEDCONFIGURATION);
        schedBlock.setSbGenerationContext(sBGenerationContext);
        schedBlock.setName(string);
        schedBlock.setStatus(Status.STATE_NEWPHASE2);
        schedBlock.getSchedBlockControl().setSBMaximumTime(opticalPointingScienceGoal.getSBMaximumTime());
        schedBlock.getSchedBlockControl().setIndefiniteRepeat(true);
        schedBlock.setModeName(mode);
        ObservingModeExpert observingModeExpert = ObservingModeExpert.getInstance();
        observingModeExpert.updateSchedBlock(schedBlock, mode);
        this.obsUnitSet.addSchedBlock(schedBlock);
        schedBlock.setObsUnitSet(this.obsUnitSet);
        ObservingGroup observingGroup = schedBlock.createObservingGroup();
        Target target = null;
        SkyCoordinates skyCoordinates = null;
        OpticalPointingTargetParameters opticalPointingTargetParameters = null;
        OpticalPointingParameters opticalPointingParameters = schedBlock.createOpticalPointingParameters();
        opticalPointingParameters.setRandomizeOrder(opticalPointingScienceGoal.getRandomizeOrder());
        opticalPointingParameters.setElevationLimit(opticalPointingScienceGoal.getElevationLimit());
        opticalPointingParameters.setAntennaPositionTolerance(opticalPointingScienceGoal.getAntennaPositionTolerance());
        opticalPointingParameters.setMinMagnitude(opticalPointingScienceGoal.getMinMagnitude());
        opticalPointingParameters.setMaxMagnitude(opticalPointingScienceGoal.getMaxMagnitude());
        OpticalCameraSpec opticalCameraSpec = schedBlock.createOpticalCameraSpec();
        opticalCameraSpec.setName(opticalPointingScienceGoal.getOpticalCameraSpec().getName());
        opticalCameraSpec.setFilter(opticalPointingScienceGoal.getOpticalCameraSpec().getFilter());
        opticalCameraSpec.setMinIntegrationTime(opticalPointingScienceGoal.getOpticalCameraSpec().getMinIntegrationTime());
        for (int i = 0; i < opticalPointingScienceGoal.getOpticalPointingTargetParametersCount(); ++i) {
            opticalPointingTargetParameters = opticalPointingScienceGoal.getOpticalPointingTargetParameters(i);
            skyCoordinates = opticalPointingTargetParameters.getSourceCoordinates();
            target = schedBlock.createTarget();
            target.addOpticalPointingParameters(opticalPointingParameters);
            FieldSource fieldSource = schedBlock.createFieldSource();
            target.setFieldSource(fieldSource);
            fieldSource.getSourceCoordinates().getLongitude().setContent(skyCoordinates.getLongitude().getContent());
            fieldSource.getSourceCoordinates().getLatitude().setContent(skyCoordinates.getLatitude().getContent());
            fieldSource.setName("Optical" + opticalPointingTargetParameters.getSourceName());
            fieldSource.setSourceName(opticalPointingTargetParameters.getSourceName());
            fieldSource.setPMRA(opticalPointingTargetParameters.getPmRA().deepCopy());
            fieldSource.setPMDec(opticalPointingTargetParameters.getPmDec().deepCopy());
            fieldSource.setParallax(opticalPointingTargetParameters.getParallax().deepCopy());
            try {
                fieldSource.setVisibleMagnitude(opticalPointingTargetParameters.getVisibleMagnitude());
            }
            catch (NullPointerException nullPointerException) {
                throw new RuntimeException(nullPointerException);
            }
            PointingPattern pointingPattern = PointingPattern.createPointingPattern();
            pointingPattern.addPhaseCenterCoordinates(SkyCoordinates.createOffsetCoordinates());
            fieldSource.setFieldPattern((FieldPattern)((Object)pointingPattern));
            if (target.getOpticalCameraSpec() == null) {
                target.setOpticalCameraSpec(opticalCameraSpec);
            }
            OrderedTarget orderedTarget = observingGroup.createOrderedTarget();
            orderedTarget.setTarget(target);
        }
    }
}

