/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.dgcpostprocessor;

import alma.obsprep.bo.schedblock.DGCReferenceCalParameters;
import alma.obsprep.bo.schedblock.DGCScienceCalParameters;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.services.generator.refactored.SchedBlockWorker;
import alma.obsprep.services.generator.refactored.dgcpostprocessor.DGCObservingParametersFactory;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Time;
import java.util.List;
import lombok.NonNull;

public class BWSWACADGCParameterConfigurator
implements DGCObservingParametersFactory.DGCParameterConfiguratorInterface {
    private static final int ACA_DGC_ITOS_DEFAULT_S = 30;
    @NonNull
    SchedBlock sb;

    @Override
    public void configureDGCRefCalibrators() {
        if (!this.sb.getSbGenerationContext().getSBType().equals((Object)SBGeneratorTemplate.SchedBlockType.ACA7M)) {
            return;
        }
        List<Target> list = this.sb.getAllTargets(DGCReferenceCalParameters.DGCReferenceCalParametersFilter);
        if (list.isEmpty()) {
            return;
        }
        Time time = Time.createTimeSec(30.0);
        list.forEach(target -> target.getFirstDGCReferenceParameters().ifPresent(dGCReferenceCalParameters -> {
            dGCReferenceCalParameters.setDefaultIntegrationTime(time);
            dGCReferenceCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(time, target));
        }));
    }

    @Override
    public void configureDGCScienceCalibrators() {
        if (!this.sb.getSbGenerationContext().getSBType().equals((Object)SBGeneratorTemplate.SchedBlockType.ACA7M)) {
            return;
        }
        List<Target> list = this.sb.getAllTargets(DGCScienceCalParameters.DGCScienceCalParametersFilter);
        if (list.isEmpty()) {
            return;
        }
        Time time = Time.createTimeSec(30.0);
        list.forEach(target -> target.getFirstDGCScienceParameters().ifPresent(dGCScienceCalParameters -> {
            dGCScienceCalParameters.setDefaultIntegrationTime(time);
            dGCScienceCalParameters.setSubScanDuration(SchedBlockWorker.getAlignedSubscanDuration(time, target));
        }));
    }

    public BWSWACADGCParameterConfigurator(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        this.sb = schedBlock;
    }
}

