/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.obsparams;

import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationTimerInterface;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.valuetypes.Time;
import lombok.NonNull;

abstract class CalibrationTimer
implements CalibrationTimerInterface {
    protected static final Time FIVE_MINS = Time.createTimeMin(5.0);
    @NonNull
    protected SpectralSpec ss = null;
    @NonNull
    protected SBGenerationContext sbContext = null;

    @Override
    public Time getScanDuration() {
        return this.getScanDuration(this.getDefaultIntegrationTime());
    }

    protected Time getAlignedSubscanDuration(@NonNull Time time) {
        if (time == null) {
            throw new NullPointerException("desiredSubscanDuration is marked non-null but is null");
        }
        double d = time.getContentInUnits(Time.UNIT_S);
        double d2 = this.ss.getCorrelatorConfiguration().getIntegrationDuration().getContentInUnits(Time.UNIT_S);
        double d3 = this.ss.getCorrelatorExpert().calcSubscanDuration(d, d2, null);
        return Time.createTime((double)d3, (String)Time.UNIT_S);
    }

    @Override
    public Time getScanDuration(@NonNull Time time) {
        if (time == null) {
            throw new NullPointerException("integrationTime is marked non-null but is null");
        }
        if (time.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)FIVE_MINS)) {
            double d = time.getContentInUnits(Time.UNIT_S);
            long l = Math.round(d % FIVE_MINS.getSecs());
            if (l > 0L) {
                return Time.createTimeSec(60.48);
            }
            return Time.createTimeSec(302.4);
        }
        return this.getAlignedSubscanDuration(time);
    }

    public CalibrationTimer(@NonNull SpectralSpec spectralSpec, @NonNull SBGenerationContext sBGenerationContext) {
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        this.ss = spectralSpec;
        this.sbContext = sBGenerationContext;
    }
}

