/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.sbbuilder;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.intermediatetarget.IntermediateTarget;
import alma.obsprep.services.generator.refactored.sbbuilder.InterferometrySchedBlockGenerator;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGeneratorTemplate;
import alma.valuetypes.Frequency;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

public class ACASBGenerator
extends InterferometrySchedBlockGenerator {
    public ACASBGenerator(@NonNull ScienceGoal scienceGoal) {
        super(RequestedArray.SEVEN_M);
        if (scienceGoal == null) {
            throw new NullPointerException("clusteredSG is marked non-null but is null");
        }
        this.sbContext.setArray(this.array).setSBType(SBGeneratorTemplate.SchedBlockType.ACA7M);
        try {
            if (!scienceGoal.isStandAloneACA()) {
                this.sbContext.setPrimaryConfiguration(this.determineConfigurationToBeUsed(scienceGoal, SBGeneratorTemplate.ArrayPriority.PRIMARY));
                this.sbContext.setConfiguration(this.determineConfigurationToBeUsed(scienceGoal, SBGeneratorTemplate.ArrayPriority.SECONDARY));
            }
        }
        catch (Configuration.UnableToDetermineConfigurationException | InvalidConfigurationParametersException | InvalidObsProgramParametersException exception) {
            throw new WizardSBGenerationException("Unable to determine configuration " + exception.getMessage());
        }
    }

    private Configuration determineConfigurationToBeUsed(@NonNull ScienceGoal scienceGoal, @NonNull SBGeneratorTemplate.ArrayPriority arrayPriority) throws InvalidObsProgramParametersException, InvalidConfigurationParametersException, Configuration.UnableToDetermineConfigurationException {
        if (scienceGoal == null) {
            throw new NullPointerException("goal is marked non-null but is null");
        }
        if (arrayPriority == null) {
            throw new NullPointerException("arrayPriority is marked non-null but is null");
        }
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Frequency frequency = scienceGoal.getRepresentativeFrequencyInSky();
        Configuration configuration = null;
        try {
            configuration = Configuration.getBestConfiguration(performanceParameters.getDesiredAngularResolution(), frequency, RequestedArray.TWELVE_M, scienceGoal);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            Log.logger((Object)this).severe("Cannot establish the best array configuration for a desired angular resolution of " + String.valueOf(performanceParameters.getDesiredAngularResolution()) + " with a rep. freq of " + String.valueOf((Object)frequency));
            throw new InvalidObsProgramParametersException(invalidConfigurationParametersException);
        }
        boolean bl = arrayPriority.equals((Object)SBGeneratorTemplate.ArrayPriority.SECONDARY);
        return bl ? Configuration.getACAConfiguration() : configuration;
    }

    @Override
    protected void addDGCCalibrators(@NonNull ScienceGoal scienceGoal, @NonNull Integer n, @NonNull List<IntermediateTarget> list, @NonNull EnumSet<SBGeneratorTemplate.SBGenerationSchema> enumSet) {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (n == null) {
            throw new NullPointerException("tuningIndex is marked non-null but is null");
        }
        if (list == null) {
            throw new NullPointerException("intermediateTargets is marked non-null but is null");
        }
        if (enumSet == null) {
            throw new NullPointerException("sbGenerationSchema is marked non-null but is null");
        }
        if (scienceGoal.getCalibrationSetupParameters().getIsDGCOverride()) {
            return;
        }
        Set<DGCExpert.DGCTypeEnum> set = DGCExpert.getExpert(false).dgcObservingStrategiesRequired(scienceGoal, true);
        if (set.containsAll(DGCExpert.allDGCStrategies) || set.equals(EnumSet.of(DGCExpert.DGCTypeEnum.DGCBandwidthSwitching))) {
            enumSet.add(SBGeneratorTemplate.SBGenerationSchema.DGC_BWSW);
            super.addDGCCalibrators(scienceGoal, n, list, enumSet);
        } else if (set.contains((Object)DGCExpert.DGCTypeEnum.DGCBandToBand)) {
            enumSet.add(SBGeneratorTemplate.SBGenerationSchema.DGC_B2B);
            super.addDGCCalibrators(scienceGoal, n, list, enumSet);
        }
    }

    @Override
    public double getAntennaMultiplier(ScienceGoal scienceGoal) throws InvalidObsProgramParametersException {
        return Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACA7M, scienceGoal);
    }

    @Override
    public Collection<Collection<SchedBlock>> getSchedBlocks(ScienceGoal scienceGoal) {
        Collection<Collection<SchedBlock>> collection = super.getSchedBlocks(scienceGoal);
        for (Collection<SchedBlock> collection2 : collection) {
            for (SchedBlock schedBlock : collection2) {
                schedBlock.getSbGenerationContext().setSBType(this.sbContext.getSBType());
            }
        }
        return collection;
    }
}

