/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.generator.refactored.targetcreator;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.calibrationconfigurationbindings.ReceiverCalibrationParameters;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.FieldSource;
import alma.obsprep.bo.schedblock.QuerySource;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import alma.obsprep.services.etc.ClusterGeometricMeanCalculator;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.obsprep.services.generator.refactored.ObsType;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.services.generator.refactored.obsparams.CalibrationConfigurationHelper;
import alma.obsprep.services.generator.refactored.obsparams.UnableToDetermineCalibrationParametersException;
import alma.obsprep.services.generator.refactored.sbbuilder.SBGenerationContext;
import alma.obsprep.services.generator.refactored.targetcreator.CalibratorFieldSourceWorker;
import alma.obsprep.services.generator.refactored.targetcreator.FieldSourceWorkers;
import alma.valuetypes.Angle;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Velocity;
import java.io.FileNotFoundException;
import javax.xml.bind.JAXBException;
import lombok.NonNull;

final class QuerySourceFieldSourceWorker
extends CalibratorFieldSourceWorker {
    public static FieldSource getFieldSource(@NonNull alma.obsprep.bo.obsproject.QuerySource querySource, @NonNull RequestedArray requestedArray, @NonNull SpectralSpec spectralSpec, @NonNull SBGenerationContext sBGenerationContext) {
        boolean bl;
        if (querySource == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (requestedArray == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        if (spectralSpec == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        FieldSource fieldSource = QuerySourceFieldSourceWorker.createCalibratorFieldSource();
        QuerySource querySource2 = QuerySource.createQuerySource(querySource);
        QuerySourceFieldSourceWorker.setQuerySourceCentralCoordinates(sBGenerationContext, querySource2);
        switch (querySource.getObsType()) {
            case AMPLITUDE: {
                querySource2.setSearchRadius(Angle.createAngle((double)0.0, (String)Angle.UNIT_DEG));
                break;
            }
            case BANDPASS: {
                querySource2.setSearchRadius(Angle.createAngle((double)120.0, (String)Angle.UNIT_DEG));
                break;
            }
            case PHASE: 
            case CHECKSOURCE: {
                querySource2.setSearchRadius(QuerySourceFieldSourceWorker.getCalibratorSearchRadius(sBGenerationContext, querySource.getObsType()));
                break;
            }
            case POINTING: {
                querySource2.setSearchRadius(Angle.createAngle((double)15.0, (String)Angle.UNIT_DEG));
                break;
            }
        }
        fieldSource.setIsQuery(true);
        fieldSource.setQuerySource(querySource2);
        fieldSource.setName(querySource.getIntendedUse());
        fieldSource.setSourceName("query");
        fieldSource.setSourceVelocity(Velocity.createVelocity());
        boolean bl2 = bl = RequestedArray.TP.equals((Object)requestedArray) && ObsType.AMPLITUDE.equals((Object)querySource.getObsType());
        if (bl) {
            QuerySourceFieldSourceWorker.setUpTPAmplitudeRasterScan(fieldSource, spectralSpec);
        }
        FieldSourceWorkers fieldSourceWorkers = FieldSourceWorkers.builder().isScienceTarget(false).spectralSpec(spectralSpec).fieldSource(fieldSource).build();
        fieldSource.addReference(fieldSourceWorkers.getAtmosphericReferencePosition());
        return fieldSource;
    }

    private static void setQuerySourceCentralCoordinates(@NonNull SBGenerationContext sBGenerationContext, @NonNull QuerySource querySource) {
        SummaryTableRow summaryTableRow;
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        if (querySource == null) {
            throw new NullPointerException("querySource is marked non-null but is null");
        }
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        try {
            summaryTableRow = new ClusterGeometricMeanCalculator().getGeometricMeanOfCluster(scienceGoal);
            querySource.setQueryCenter((SkyCoordinates)summaryTableRow);
        }
        catch (ClusterGeometricMeanCalculator.UnableToCalculateGeometricMeanException unableToCalculateGeometricMeanException) {
            Log.logger(QuerySourceFieldSourceWorker.class).warning("Unable to calculate the geometric mean of science goal " + scienceGoal.getName() + ": using the rep. target coords");
        }
        if (querySource.getQueryCenter().isDefaultCoordinates()) {
            summaryTableRow = sBGenerationContext.getGoal().getKeyTargetParameters();
            querySource.setQueryCenter(summaryTableRow.getFieldCenterCoordinates().deepCopy());
        }
    }

    public static Angle getCalibratorSearchRadius(@NonNull SBGenerationContext sBGenerationContext, @NonNull ObsType obsType) {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        if (obsType == null) {
            throw new NullPointerException("calibrationType is marked non-null but is null");
        }
        ScienceGoal scienceGoal = sBGenerationContext.getGoal();
        ReceiverBand receiverBand = scienceGoal.getReceiverBand();
        if (receiverBand == null) {
            throw new WizardSBGenerationException();
        }
        int n = receiverBand.getNumber();
        boolean bl = scienceGoal.getSpectralSetupParameters().isWalshSwitching();
        try {
            Configuration configuration = QuerySourceFieldSourceWorker.getMostExtendedScheduledConfiguration(sBGenerationContext);
            CalibrationConfigurationHelper calibrationConfigurationHelper = CalibrationConfigurationHelper.getInstance();
            ReceiverCalibrationParameters receiverCalibrationParameters = calibrationConfigurationHelper.getCalibrationParameters(configuration, obsType, CorrelatorType.BL, n, bl);
            return CalibrationConfigurationHelper.getSeparationAngle(receiverCalibrationParameters);
        }
        catch (Configuration.UnableToDetermineConfigurationException | UnableToDetermineCalibrationParametersException | FileNotFoundException | JAXBException throwable) {
            throw new WizardSBGenerationException(throwable);
        }
    }

    private static Configuration getMostExtendedScheduledConfiguration(@NonNull SBGenerationContext sBGenerationContext) throws Configuration.UnableToDetermineConfigurationException {
        if (sBGenerationContext == null) {
            throw new NullPointerException("sbContext is marked non-null but is null");
        }
        if (sBGenerationContext.isTM1SB()) {
            try {
                return Configuration.getConfigurationsToBeScheduled(sBGenerationContext.getGoal()).getMostExtendedTM1Configuration();
            }
            catch (Configuration.UnableToDetermineConfigurationException | InvalidObsProgramParametersException exception) {
                throw new WizardSBGenerationException("Unable to determine most extended TM1 configuration for setup: " + exception.getMessage());
            }
        }
        if (sBGenerationContext.isTM2SB()) {
            try {
                return Configuration.getConfigurationsToBeScheduled(sBGenerationContext.getGoal()).getMostExtendedTM2Configuration();
            }
            catch (Configuration.UnableToDetermineConfigurationException | InvalidObsProgramParametersException exception) {
                throw new WizardSBGenerationException("Unable to determine most extended TM2 configuration for setup: " + exception.getMessage());
            }
        }
        if (sBGenerationContext.is7mSB()) {
            return Configuration.getACAConfiguration();
        }
        return sBGenerationContext.getConfiguration();
    }

    private QuerySourceFieldSourceWorker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

