/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.network.roledirectory;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.ot.gui.toplevel.UserAuthenticator;
import alma.obsprep.roledirectory.DenyAllBecauseServerNotFound;
import alma.obsprep.roledirectory.DenyAllBecauseUrlInvalid;
import alma.obsprep.roledirectory.DenyAllBecauseUserCancelled;
import alma.obsprep.roledirectory.DenyAllFromStart;
import alma.obsprep.roledirectory.OTOperation;
import alma.obsprep.roledirectory.OnlineRoleDirectory;
import alma.obsprep.roledirectory.OnlineRoleDirectorySimulation;
import alma.obsprep.roledirectory.RoleDirectory;
import alma.obsprep.services.network.NetworkService;
import alma.obsprep.services.network.exceptions.ConnectionException;
import alma.obsprep.util.GUIUtilities;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import lombok.NonNull;

public class RoleDirectoryService
implements NetworkService,
RoleDirectory {
    private static Collection<UserAuthenticatesListener> userAuthenticationListeners = Collections.synchronizedList(new ArrayList());
    private static final String WEBAPP_URL = "/ObsprepSubmissionService";
    private URL webappUrl;
    private RoleDirectory state;
    private final UserAuthenticator userAuthenticator;
    private final RoleDirectory denyAllBecauseServerNotFound = new DenyAllBecauseServerNotFound();
    private final RoleDirectory denyAllBecauseUrlInvalid = new DenyAllBecauseUrlInvalid();
    private final RoleDirectory denyAllBecauseUserCancelled = new DenyAllBecauseUserCancelled();
    private final RoleDirectory denyAllFromStart = new DenyAllFromStart();
    private final OnlineRoleDirectory online;

    public RoleDirectoryService(@NonNull UserAuthenticator userAuthenticator) {
        OnlineRoleDirectory onlineRoleDirectory = this.online = Boolean.getBoolean("alma.obsprep.allowprivileged") ? new OnlineRoleDirectorySimulation() : new OnlineRoleDirectory();
        if (userAuthenticator == null) {
            throw new NullPointerException("userAuthenticator is marked non-null but is null");
        }
        this.userAuthenticator = userAuthenticator;
        this.setState(this.denyAllFromStart);
    }

    public boolean setServerUrl(String string) throws MalformedURLException {
        if (string != null) {
            boolean bl = false;
            while (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            String string2 = string + WEBAPP_URL;
            if (this.webappUrl == null || !string2.equals(this.webappUrl.toString())) {
                try {
                    this.webappUrl = new URL(string2);
                    bl = false;
                    this.online.setWebappUrl(this.webappUrl);
                }
                catch (MalformedURLException malformedURLException) {
                    this.webappUrl = null;
                    throw malformedURLException;
                }
            } else {
                bl = true;
            }
            return !bl;
        }
        return false;
    }

    public void setCredentials(String string, String string2) {
        this.online.setCredentials(string, string2);
    }

    private void setState(@NonNull RoleDirectory roleDirectory) {
        if (roleDirectory == null) {
            throw new NullPointerException("newStrategy is marked non-null but is null");
        }
        if (this.state == null || this.state.getClass() != roleDirectory.getClass()) {
            Log.logger((Object)this).fine("Running with role permissions: " + roleDirectory.getClass().getSimpleName());
        }
        this.state = roleDirectory;
    }

    public boolean isSimulation() {
        return this.online instanceof OnlineRoleDirectorySimulation;
    }

    private ExternalState.Code state2externalcode() {
        if (this.state == this.denyAllBecauseServerNotFound) {
            return ExternalState.Code.offline_notfound;
        }
        if (this.state == this.denyAllBecauseUrlInvalid) {
            return ExternalState.Code.offline_badurl;
        }
        if (this.state == this.denyAllBecauseUserCancelled) {
            return ExternalState.Code.online_loggedout;
        }
        if (this.state == this.denyAllFromStart) {
            return ExternalState.Code.offline_default;
        }
        if (this.state == this.online) {
            if (this.online.isAuthenticated()) {
                return ExternalState.Code.online_loggedin;
            }
            return ExternalState.Code.online_loggedout;
        }
        throw new IllegalStateException(this.state.getClass().toString());
    }

    public ExternalState attemptConnection() {
        String string = this.userAuthenticator.getServerUrl();
        try {
            this.setServerUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.tryConnect();
        ExternalState externalState = new ExternalState();
        externalState.url = string;
        externalState.code = this.state2externalcode();
        return externalState;
    }

    public ExternalState attemptConnectionAndLogin() {
        boolean bl = this.userAuthenticator.launchPasswordDialog("Please enter the account credentials that you want to use");
        if (!bl) {
            return null;
        }
        String string = this.userAuthenticator.getServerUrl();
        this.tryConnect();
        if (this.state != this.online) {
            ExternalState externalState = new ExternalState();
            externalState.url = string;
            externalState.code = this.state2externalcode();
            return externalState;
        }
        this.tryLogin("Login");
        if (this.isLoggedIn()) {
            ExternalState externalState = new ExternalState();
            externalState.url = string;
            externalState.code = this.state2externalcode();
            return externalState;
        }
        return this.attemptConnection();
    }

    public void ensureLoggedIn(@NonNull String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("explainWhy is marked non-null but is null");
        }
        this.tryConnect();
        int n = this.tryLogin(string);
        switch (n) {
            case -1: {
                throw new IOException("server not accessible");
            }
            case 0: {
                throw new IOException("user cancelled login");
            }
        }
    }

    public boolean login() throws IOException {
        if (this.state == this.online) {
            boolean bl = this.online.login();
            if (bl) {
                userAuthenticationListeners.stream().forEach(UserAuthenticatesListener::userHasAuthenticated);
            }
            return bl;
        }
        return false;
    }

    private boolean isLoggedIn() {
        if (this.state == this.online) {
            return this.online.isAuthenticated();
        }
        return false;
    }

    private int tryLogin(String string) {
        boolean bl = true;
        boolean bl2 = this.isLoggedIn();
        while (!bl2) {
            String[] stringArray;
            if (bl) {
                stringArray = this.userAuthenticator.getCredentials(string);
                bl = false;
            } else {
                stringArray = this.userAuthenticator.getCredentialsAgain();
            }
            if (stringArray == null) {
                return 0;
            }
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            this.setCredentials(string2, string3);
            try {
                bl2 = this.login();
            }
            catch (IOException iOException) {
                return -1;
            }
        }
        return 1;
    }

    private void suggestLogin(String string) {
        int n = this.tryLogin(string);
        if (n == 0) {
            this.setState(this.denyAllBecauseUserCancelled);
            GUIUtilities.warning(null, "Login cancelled.\n\nTo re-attempt login, open the OT Connection preferences menu.");
        }
        if (n == -1) {
            this.setState(this.denyAllBecauseServerNotFound);
            GUIUtilities.error(null, "Failed to contact server.\nPlease try to repeat this operation at a later time.");
        }
    }

    private void tryConnect() {
        if (this.webappUrl == null) {
            this.setState(this.denyAllBecauseUrlInvalid);
            return;
        }
        try {
            this.online.canExecute(OTOperation.SERVICE_PING);
            this.setState(this.online);
        }
        catch (IOException iOException) {
            this.setState(this.denyAllBecauseServerNotFound);
        }
    }

    @Override
    public void goOnline() throws ConnectionException {
        this.tryConnect();
        if (this.state == this.denyAllBecauseServerNotFound) {
            throw new ConnectionException("No permission server found at " + this.webappUrl.toString());
        }
    }

    @Override
    public boolean canExecute(OTOperation oTOperation) throws IOException {
        if (this.state == this.denyAllFromStart) {
            this.tryConnect();
            if (this.state == this.online) {
                this.suggestLogin(oTOperation.getDescription());
            }
        }
        RoleDirectory roleDirectory = this.state;
        return roleDirectory.canExecute(oTOperation);
    }

    public static void addUserAuthenticatesListener(UserAuthenticatesListener userAuthenticatesListener) {
        userAuthenticationListeners.add(userAuthenticatesListener);
    }

    public static class ExternalState {
        public Code code;
        public String url;

        public boolean isOnlineState() {
            return this.code == Code.online_loggedout || this.code == Code.online_loggedin;
        }

        public static enum Code {
            offline_default,
            offline_badurl,
            offline_notfound,
            online_loggedout,
            online_loggedin;

        }
    }

    public static interface UserAuthenticatesListener {
        public void userHasAuthenticated();
    }
}

