/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.hla.runtime.obsprep.bo.Entity;
import alma.hla.runtime.obsprep.bo.EntityIDFactory;
import alma.hla.runtime.obsprep.bo.EntityPart;
import alma.hla.runtime.obsprep.util.CannotAssignIdException;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.services.summaryfeedback.AllScienceGoalsExporter;
import alma.obsprep.services.summaryfeedback.DefaultPdfExporter;
import alma.obsprep.services.summaryfeedback.JointProposalCoverSheetExporter;
import alma.obsprep.services.summaryfeedback.JointProposalSummaryModel;
import alma.obsprep.services.summaryfeedback.JointProposalSummaryParameters;
import alma.obsprep.services.summaryfeedback.JointProposalSummaryView;
import alma.obsprep.services.summaryfeedback.ProposalCoverSheetExporter;
import alma.obsprep.services.summaryfeedback.ProposalSummaryModel;
import alma.obsprep.services.summaryfeedback.ProposalSummaryParameters;
import alma.obsprep.services.summaryfeedback.ProposalSummaryView;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryModel;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryView;
import alma.obsprep.services.summaryfeedback.SummaryDocument;
import alma.obsprep.util.LogLoggerProviderImpl;
import alma.obsprep.util.UnitMapConfigurator;
import com.itextpdf.text.Document;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.net.URL;
import java.util.Random;
import javax.swing.SwingUtilities;
import lombok.NonNull;

public class CompleteProposalExporter
extends DefaultPdfExporter {
    private ObsProposal proposal;
    private final DefaultPdfExporter proposalExporter;
    private final AllScienceGoalsExporter allScienceGoalExporter;
    private DefaultPdfExporter jointProposalExporter;

    protected CompleteProposalExporter(@NonNull ProposalSummaryView proposalSummaryView, @NonNull JointProposalSummaryView jointProposalSummaryView, @NonNull ScienceGoalSummaryView scienceGoalSummaryView) {
        if (proposalSummaryView == null) {
            throw new NullPointerException("propOffView is marked non-null but is null");
        }
        if (jointProposalSummaryView == null) {
            throw new NullPointerException("jointProposalOffView is marked non-null but is null");
        }
        if (scienceGoalSummaryView == null) {
            throw new NullPointerException("sgOffView is marked non-null but is null");
        }
        this.proposalExporter = new ProposalCoverSheetExporter(proposalSummaryView);
        this.jointProposalExporter = new JointProposalCoverSheetExporter(jointProposalSummaryView);
        this.allScienceGoalExporter = new AllScienceGoalsExporter(scienceGoalSummaryView);
    }

    protected void setObsProposal(ObsProposal obsProposal) {
        this.proposal = obsProposal;
        this.allScienceGoalExporter.setObsProposal(obsProposal);
    }

    @Override
    public void exportToPdf(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (this.proposal == null) {
            return;
        }
        super.exportToPdf(file);
    }

    @Override
    protected void exportToPdfPage(@NonNull Document document, @NonNull PdfWriter pdfWriter, @NonNull Rectangle rectangle) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (pdfWriter == null) {
            throw new NullPointerException("writer is marked non-null but is null");
        }
        if (rectangle == null) {
            throw new NullPointerException("pageSize is marked non-null but is null");
        }
        this.proposalExporter.exportToPdfPage(document, pdfWriter, rectangle);
        document.newPage();
        if (this.proposal.getJointProposal().getIsJointProposal()) {
            this.jointProposalExporter.exportToPdfPage(document, pdfWriter, rectangle);
            document.newPage();
        }
        this.allScienceGoalExporter.exportToPdfPage(document, pdfWriter, rectangle);
    }

    public static void main(String[] stringArray) {
        System.setProperty("java.awt.headless", "true");
        UnitMapConfigurator.configureUnitMaps();
        ObservingToolController.getMyInstance();
        Log.setRuntimeImplementation((Log.LoggerProvider)new LogLoggerProviderImpl());
        final Random random = new Random();
        EntityIDFactory.setRuntimeImplementation((EntityIDFactory)new EntityIDFactory(){

            public String assignUniqueEntityId(Entity entity) {
                return "entityId-" + random.nextInt();
            }

            public void destroy() {
            }

            public String assignEntityPartId(EntityPart entityPart) throws CannotAssignIdException {
                return "entityPartId-" + random.nextInt();
            }
        });
        SwingUtilities.invokeLater(() -> {
            SummaryDocument summaryDocument;
            ObsProposal obsProposal = null;
            try {
                InitServices.init();
                obsProposal = ImpexFactory.getInstance().importObsProject(new URL("file://" + new File(stringArray[0]).getAbsolutePath())).getObsProposal();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            ProposalSummaryParameters proposalSummaryParameters = new ProposalSummaryParameters(obsProposal);
            ProposalSummaryModel proposalSummaryModel = new ProposalSummaryModel();
            proposalSummaryParameters.collectInfo();
            proposalSummaryModel.setDocument(proposalSummaryParameters);
            boolean bl = obsProposal.getJointProposal().getIsJointProposal();
            JointProposalSummaryModel jointProposalSummaryModel = new JointProposalSummaryModel();
            if (bl) {
                summaryDocument = new JointProposalSummaryParameters(obsProposal);
                ((JointProposalSummaryParameters)summaryDocument).collectInfo();
                jointProposalSummaryModel.setDocument(proposalSummaryParameters);
            }
            summaryDocument = new ScienceGoalSummaryParameters();
            ScienceGoalSummaryModel scienceGoalSummaryModel = new ScienceGoalSummaryModel();
            scienceGoalSummaryModel.setDocument(summaryDocument);
            ProposalSummaryView proposalSummaryView = new ProposalSummaryView(proposalSummaryModel);
            JointProposalSummaryView jointProposalSummaryView = new JointProposalSummaryView(jointProposalSummaryModel);
            ScienceGoalSummaryView scienceGoalSummaryView = new ScienceGoalSummaryView(scienceGoalSummaryModel);
            CompleteProposalExporter completeProposalExporter = new CompleteProposalExporter(proposalSummaryView, jointProposalSummaryView, scienceGoalSummaryView);
            completeProposalExporter.setObsProposal(obsProposal);
            completeProposalExporter.exportToPdf(new File(stringArray[1]));
        });
    }
}

