/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.services.summaryfeedback;

import alma.obsprep.services.summaryfeedback.ScienceGoalSummaryParameters;
import alma.obsprep.services.summaryfeedback.TargetInfo;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Velocity;
import javax.swing.table.AbstractTableModel;

public class TargetListTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1876554980398888656L;
    private final int tableNumber;
    private ScienceGoalSummaryParameters document;
    private final String[] longValues = new String[]{"NN", "1-Long Name Target", " 17:42:30, -28:55:00 ", "   nnnnnnkm/s, lsr, RELATIVISTIC   "};

    public TargetListTableModel(int n) {
        this.tableNumber = n;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public int getColumnCount() {
        return TargetListCols.getColumnCount();
    }

    @Override
    public int getRowCount() {
        ScienceGoalSummaryParameters scienceGoalSummaryParameters = this.getParameters();
        if (scienceGoalSummaryParameters == null || scienceGoalSummaryParameters.targetInfoLists.size() <= this.tableNumber || scienceGoalSummaryParameters.targetInfoLists.get(this.tableNumber) == null) {
            return 0;
        }
        return scienceGoalSummaryParameters.targetInfoLists.get(this.tableNumber).size();
    }

    private boolean hasNoTargets() {
        return 0 == this.getRowCount();
    }

    @Override
    public String getColumnName(int n) {
        TargetListCols targetListCols = TargetListCols.getColumnDescriptor(n);
        return targetListCols.getColumnName();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ScienceGoalSummaryParameters scienceGoalSummaryParameters = this.getParameters();
        if (this.hasNoTargets()) {
            return null;
        }
        TargetInfo targetInfo = scienceGoalSummaryParameters.targetInfoLists.get(this.tableNumber).get(n);
        int n3 = 60 * this.tableNumber + n + 1;
        TargetListCols targetListCols = TargetListCols.getColumnDescriptor(n2);
        switch (targetListCols) {
            case INDEX: {
                return n3;
            }
            case TARGETNAME: {
                return n3 + "-" + targetInfo.targetName;
            }
            case SKYCOORDINATES: {
                return targetInfo.coordinates != null ? targetInfo.coordinates : targetInfo.galactic;
            }
            case VELOCITY: {
                return targetInfo.sourceVelocity;
            }
        }
        String string = "Invalid column index : " + n2 + "(descriptor = " + String.valueOf((Object)targetListCols) + ")";
        throw new IllegalArgumentException(string);
    }

    public ScienceGoalSummaryParameters getParameters() {
        return this.document;
    }

    public void setDocument(ScienceGoalSummaryParameters scienceGoalSummaryParameters) {
        this.document = scienceGoalSummaryParameters;
    }

    public String[] getLongValues() {
        return this.longValues;
    }

    public static enum TargetListCols {
        INDEX("No. ", Integer.class),
        TARGETNAME("Target", String.class),
        SKYCOORDINATES("Ra,Dec ", SkyCoordinates.class),
        VELOCITY("V,def,frame --OR--z", Velocity.class);

        public final String columnName;
        public final Class<?> columnClass;

        protected static int getColumnCount() {
            return TargetListCols.values().length;
        }

        protected static TargetListCols getColumnDescriptor(int n) {
            return TargetListCols.values()[n];
        }

        private TargetListCols(String string2, Class<?> clazz) {
            this.columnName = string2;
            this.columnClass = clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Class<?> getColumnClass() {
            return this.columnClass;
        }
    }
}

