/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class OverlayedIcon
implements Icon {
    protected Icon icon1;
    protected Icon icon2;
    protected Image image1;
    protected Image image2;

    public OverlayedIcon(Icon icon, Icon icon2) {
        this.icon1 = icon;
        this.icon2 = icon2;
    }

    @Override
    public int getIconWidth() {
        return this.icon1.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.icon1.getIconHeight();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.image1 != null || this.image2 == null) {
            this.image1 = this.makeImageFromIcon(this.icon1, component, n, n2);
            this.image2 = this.makeImageFromIcon(this.icon2, component, n, n2);
        }
        graphics.drawImage(this.image1, n, n2, null);
        graphics.drawImage(this.image2, n, n2, null);
    }

    private Image makeImageFromIcon(Icon icon, Component component, int n, int n2) {
        if (icon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)icon;
            return imageIcon.getImage();
        }
        Image image = component.createImage(icon.getIconWidth(), icon.getIconHeight());
        Graphics graphics = image.getGraphics();
        graphics.setColor(component.getBackground());
        graphics.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
        icon.paintIcon(component, graphics, n, n2);
        return image;
    }
}

