/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util;

import alma.hla.runtime.obsprep.util.UnitException;
import alma.hla.runtime.obsprep.util.UnitMap;
import alma.obsprep.bo.enumerations.Antenna;
import alma.obsprep.util.FrequencyDependentUnitMap;
import alma.valuetypes.Angle;
import alma.valuetypes.UserAngle;
import alma.valuetypes.UserUnitValueUnitPair;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UserAngleUnitMap
extends FrequencyDependentUnitMap {
    public static final String DEFAULT_UNIT = UnitMap.getAngleUnits().getDefaultUnit();
    private Antenna antenna = Antenna.ANTENNA_12M;
    private final Set<String> frequencyDependingUnits = new HashSet<String>();

    public UserAngleUnitMap(UserUnitValueUnitPair userUnitValueUnitPair) {
        super(userUnitValueUnitPair);
    }

    @Override
    protected UnitMap getStaticNonModelUnitMap() {
        UnitMap unitMap = new UnitMap();
        unitMap.put(UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, 1.0);
        unitMap.put(UserAngle.USERUNIT_H, 900.0);
        this.frequencyDependingUnits.add(UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM);
        return unitMap;
    }

    @Override
    protected void initializeUnitMap() {
        UnitMap unitMap = UnitMap.getUnits((String)"Angle");
        this.putAll((Map)unitMap);
        this.setDefaultUnit(unitMap.getDefaultUnit());
        if (this.isNonModelUnitsAccepted) {
            this.addNonModelUnits();
        }
    }

    @Override
    protected void updateNonModelUnitsScale() throws UnitException {
        double d = this.getScale(UserAngle.USERUNIT_ARCSEC);
        Angle angle = this.antenna.getBeamSize(this.getNonZeroObservingFrequency());
        double d2 = angle.getContentInUnits(UserAngle.USERUNIT_ARCSEC);
        if (Math.abs(d) < 1.0E-5 || Math.abs(d2) < 1.0E-5) {
            return;
        }
        double d3 = d * d2;
        this.put(UserAngle.USERUNIT_FRACTION_OF_MAIN_BEAM, d3);
    }

    public void setAntenna(Antenna antenna) {
        if (this.isNonModelUnitsAccepted && antenna == null) {
            throw new NullPointerException("Antenna must not be null when non model units are accepted.");
        }
        this.antenna = antenna;
        this.updateUnitMap();
    }

    @Override
    public Set<String> getFrequencyDependingUnits() {
        return this.frequencyDependingUnits;
    }
}

