/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.util.job;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.util.job.JobMethod;
import alma.obsprep.util.job.JobUtility;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public abstract class AbstractJob
implements JobMethod,
Runnable {
    public Info info = new Info();
    private Executor exe;
    public Throwable exception;
    protected boolean stop;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this){

        @Override
        public void firePropertyChange(final PropertyChangeEvent propertyChangeEvent) {
            if (SwingUtilities.isEventDispatchThread()) {
                super.firePropertyChange(propertyChangeEvent);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractJob.this.pcs.firePropertyChange(propertyChangeEvent);
                    }
                });
            }
        }
    };
    protected int progress = 0;
    protected SwingWorker.StateValue state = SwingWorker.StateValue.PENDING;

    public AbstractJob(String string, boolean bl) {
        this(string, bl, JobUtility.inline);
    }

    public AbstractJob(String string, boolean bl, Executor executor) {
        this.info.description = string;
        this.info.isImportant = bl;
        this.setExecutor(executor);
    }

    public void setExecutor(Executor executor) {
        this.exe = executor;
    }

    public AbstractJob go() {
        this.exe.execute(this);
        return this;
    }

    @Override
    public void run() {
        try {
            this.exception = null;
            this.fireState(SwingWorker.StateValue.STARTED);
            this.job();
        }
        catch (Throwable throwable) {
            this.exception = throwable;
            this.handle(throwable);
        }
        finally {
            this.fireState(SwingWorker.StateValue.DONE);
        }
    }

    protected void handle(Throwable throwable) {
        String string = this.info.description;
        if (string == null) {
            string = this.toString();
        }
        String string2 = "Problem executing job '" + string + "': " + String.valueOf(throwable);
        if (this.info.isImportant) {
            Log.logger((Object)this).log(Level.WARNING, string2, throwable);
        } else {
            Log.logger((Object)this).log(Level.INFO, string2, throwable);
        }
    }

    public void stop() {
        this.stop = true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    protected void fireProgress(int n) {
        int n2 = this.progress;
        this.progress = n;
        this.pcs.firePropertyChange("progress", n2, n);
    }

    private void fireState(SwingWorker.StateValue stateValue) {
        SwingWorker.StateValue stateValue2 = this.state;
        this.state = stateValue;
        this.pcs.firePropertyChange("state", (Object)stateValue2, (Object)stateValue);
    }

    public class Info {
        public String description;
        public boolean isImportant;
    }
}

