/*
 * Decompiled with CFR 0.152.
 */
package alma.valuetypes;

import alma.entity.xmlbinding.valuetypes.VelocityT;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.TemporalParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.services.experts.BaryCentricVelocity;
import alma.obsprep.services.experts.VLBIExpert;
import alma.valuetypes.Angle;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.data.VelocityData;
import com.sun.istack.NotNull;
import java.time.ZonedDateTime;
import java.util.Optional;
import lombok.NonNull;

public class Velocity
extends VelocityData {
    public boolean isForceTopocentricConversionEnabled = false;
    public static final double C = 2.99792458E8;
    public static final double GIGAHERTZ_TO_HERTZ = 1.0E9;
    public static final String defaultDopplerCalcType = DOPPLERCALCTYPE_RADIO;
    private static double[] SOLAR_MOTIONS = new double[]{-0.29, 17.31726, -10.00141};

    public Velocity(VelocityT velocityT) {
        super(velocityT);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setDopplerCalcType(defaultDopplerCalcType);
        this.setReferenceSystem(REFERENCESYSTEM_LSRK);
        this.setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
    }

    public Frequency dopplerShift(@NonNull Frequency frequency) {
        if (frequency == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        double d = this.getDopplerShiftFactor();
        Frequency frequency2 = Frequency.createFrequency((double)(frequency.getContent() * d), (String)frequency.getUnit());
        return frequency2;
    }

    public Frequency reverseShift(@NonNull Frequency frequency) {
        if (frequency == null) {
            throw new NullPointerException("f is marked non-null but is null");
        }
        double d = this.getDopplerShiftFactor();
        Frequency frequency2 = Frequency.createFrequency((double)(frequency.getContent() / d), (String)frequency.getUnit());
        return frequency2;
    }

    private double getDopplerShiftFactor() {
        double d;
        double d2 = this.getCenterVelocity().getContentInUnits(Speed.UNIT_M_S) / 2.99792458E8;
        String string = this.checkType();
        if (string.equals(DOPPLERCALCTYPE_RELATIVISTIC)) {
            d = Math.sqrt((1.0 - d2) / (1.0 + d2));
        } else if (string.equals(DOPPLERCALCTYPE_OPTICAL)) {
            d = 1.0 / (1.0 + d2);
        } else if (string.equals(DOPPLERCALCTYPE_RADIO)) {
            d = 1.0 - d2;
        } else {
            assert (false);
            throw new IllegalArgumentException("Unknown DopplerCalcType : " + string);
        }
        if (Double.isNaN(d) || d < 0.0 || Double.isInfinite(d)) {
            d = 1.0;
        }
        return d;
    }

    private String checkType() {
        String string = this.getDopplerCalcType();
        if (string == null) {
            Log.logger((Object)((Object)this)).warning("DopplerCalcType is not set. Assuming \"" + defaultDopplerCalcType + "\"");
            string = defaultDopplerCalcType;
        }
        return string;
    }

    public double asRedshift() {
        double d = this.getCenterVelocity().getContentInUnits(Speed.UNIT_M_S) / 2.99792458E8;
        String string = this.checkType();
        double d2 = 0.0;
        if (string.equals(DOPPLERCALCTYPE_RELATIVISTIC)) {
            d2 = Math.sqrt((1.0 + d) / (1.0 - d)) - 1.0;
        } else if (string.equals(DOPPLERCALCTYPE_OPTICAL)) {
            d2 = d;
        } else if (string.equals(DOPPLERCALCTYPE_RADIO)) {
            d2 = d / (1.0 - d);
        } else {
            assert (false);
            throw new RuntimeException("Unknown DopplerCalcType : " + string);
        }
        return d2;
    }

    public Velocity fromRedshift(double d) {
        String string = this.checkType();
        Speed speed = null;
        if (string.equals(DOPPLERCALCTYPE_RELATIVISTIC)) {
            double d2 = (d + 1.0) * (d + 1.0);
            double d3 = (d2 - 1.0) / (d2 + 1.0);
            speed = Speed.createSpeed((double)(d3 * 2.99792458E8), (String)Speed.UNIT_M_S);
        } else if (string.equals(DOPPLERCALCTYPE_OPTICAL)) {
            speed = Speed.createSpeed((double)(d * 2.99792458E8), (String)Speed.UNIT_M_S);
        } else if (string.equals(DOPPLERCALCTYPE_RADIO)) {
            speed = Speed.createSpeed((double)(d * 2.99792458E8 / (1.0 + d)), (String)Speed.UNIT_M_S);
        } else {
            throw new RuntimeException("Unknown DopplerCalcType : " + string);
        }
        Velocity velocity = Velocity.createVelocity();
        velocity.setCenterVelocity(speed);
        velocity.setDopplerCalcType(this.getDopplerCalcType());
        return velocity;
    }

    public Velocity getVelocityInDefaultReferenceFrame(@NonNull SkyCoordinates skyCoordinates, @NonNull Optional<ScienceGoal> optional) {
        Velocity velocity;
        Object object;
        if (skyCoordinates == null) {
            throw new NullPointerException("sourceCoordinates is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        boolean bl = false;
        TemporalParameters temporalParameters = null;
        if (VLBIExpert.IS_VLBI_SPECTRALLINE_ENABLED && optional.isPresent() || this.isForceTopocentricConversionEnabled) {
            boolean bl2 = false;
            boolean bl3 = false;
            object = optional.get();
            bl3 = object.getSpectralSetupParameters().isSpectralLine();
            if (bl3 || this.isForceTopocentricConversionEnabled) {
                try {
                    bl2 = this.isForceTopocentricConversionEnabled || ObsProposal.isVLBIRelated();
                }
                catch (UnknownEntityException unknownEntityException) {
                    Log.logger(Velocity.class).warning("Unable to determine if the project is VLBI related");
                }
                if (bl2 || this.isForceTopocentricConversionEnabled) {
                    try {
                        temporalParameters = object.getPerformanceParameters().getTemporalParameters(0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (temporalParameters == null) {
                        temporalParameters = TemporalParameters.createTemporalParameters();
                        temporalParameters.setStartTimeInDate(TemporalParameters.nowInUTC());
                        temporalParameters.setEndTimeInDate(TemporalParameters.nowInUTC());
                    }
                }
            }
            bl = bl2 && bl3;
        }
        String string = this.getReferenceSystem();
        object = Optional.empty();
        if (bl) {
            object = Optional.of(this.getVSunEarth(this, skyCoordinates, temporalParameters));
        }
        if (REFERENCESYSTEM_BAR == string || REFERENCESYSTEM_HEL == string) {
            velocity = bl ? Velocity.applyBarycentricToTopoCorrection(skyCoordinates, this, object) : this.deepCopy();
        } else if (REFERENCESYSTEM_LSR == string || REFERENCESYSTEM_LSRK == string) {
            velocity = Velocity.applyLSRKToBarycentricCorrection(skyCoordinates, this, object);
            if (bl) {
                velocity.setReferenceSystem(REFERENCESYSTEM_TOPO);
            }
        } else {
            velocity = this.deepCopy();
        }
        assert (velocity != null);
        return velocity;
    }

    private Velocity getVSunEarth(@NonNull Velocity velocity, @NonNull SkyCoordinates skyCoordinates, @NonNull TemporalParameters temporalParameters) {
        if (velocity == null) {
            throw new NullPointerException("velocityToTransform is marked non-null but is null");
        }
        if (skyCoordinates == null) {
            throw new NullPointerException("sourceCoordinates is marked non-null but is null");
        }
        if (temporalParameters == null) {
            throw new NullPointerException("visitConstraint is marked non-null but is null");
        }
        SkyCoordinates skyCoordinates2 = skyCoordinates;
        if (!skyCoordinates.isICRS()) {
            skyCoordinates2 = skyCoordinates.getICRSSkyCoordinates();
        }
        ZonedDateTime zonedDateTime = temporalParameters.getStartTimeInDate();
        Velocity velocity2 = BaryCentricVelocity.calculateSunEarthBaryVelocityForDate(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), zonedDateTime.getDayOfMonth(), zonedDateTime.getHour(), 2000.0, skyCoordinates2, velocity);
        return velocity2;
    }

    public static Velocity getVelocityOfLSRKFrameRelativeToSun(@NotNull SkyCoordinates skyCoordinates, @NotNull Velocity velocity) {
        SkyCoordinates skyCoordinates2 = skyCoordinates.getJ2000SkyCoordinates();
        double d = skyCoordinates2.getLongitude().getContentInUnits(Angle.UNIT_RAD);
        double d2 = skyCoordinates2.getLatitude().getContentInUnits(Angle.UNIT_RAD);
        double d3 = Velocity.solarRadialVelocityLsrk(d, d2);
        Velocity velocity2 = velocity.deepCopy();
        velocity2.setCenterVelocity(Speed.createSpeed((double)d3, (String)Speed.UNIT_KM_S));
        return velocity2;
    }

    public static Velocity applyLSRKToBarycentricCorrection(@NotNull SkyCoordinates skyCoordinates, @NotNull Velocity velocity, Optional<Velocity> optional) {
        Velocity velocity2 = Velocity.getVelocityOfLSRKFrameRelativeToSun(skyCoordinates, velocity);
        double d = velocity2.getDopplerShiftFactor();
        double d2 = velocity.getDopplerShiftFactor();
        double d3 = d2 * d;
        if (optional.isPresent()) {
            d3 *= optional.get().getDopplerShiftFactor();
        }
        Velocity velocity3 = velocity.fromRedshift(1.0 / d3 - 1.0);
        velocity3.setReferenceSystem(REFERENCESYSTEM_BAR);
        return velocity3;
    }

    public static Velocity applyBarycentricToTopoCorrection(@NonNull SkyCoordinates skyCoordinates, @NonNull Velocity velocity, @NonNull Optional<Velocity> optional) {
        if (skyCoordinates == null) {
            throw new NullPointerException("skyCoordinates is marked non-null but is null");
        }
        if (velocity == null) {
            throw new NullPointerException("sourceVelocity is marked non-null but is null");
        }
        if (optional == null) {
            throw new NullPointerException("vSunEarth is marked non-null but is null");
        }
        if (velocity.getReferenceSystem().equals(REFERENCESYSTEM_TOPO)) {
            return velocity.deepCopy();
        }
        if (!velocity.getReferenceSystem().equals(REFERENCESYSTEM_BAR) && !velocity.getReferenceSystem().equals(REFERENCESYSTEM_HEL)) {
            throw new IllegalArgumentException("Reference system of input velocity must be bary or hel");
        }
        double d = velocity.getDopplerShiftFactor();
        double d2 = optional.orElseThrow(() -> new IllegalArgumentException("vSunEarth not specified")).getDopplerShiftFactor();
        double d3 = d * d2;
        Velocity velocity2 = velocity.fromRedshift(1.0 / d3 - 1.0);
        velocity2.setReferenceSystem(REFERENCESYSTEM_TOPO);
        return velocity2;
    }

    public void setReferenceSystem(String string) {
        String string2 = string;
        if (string.equals(REFERENCESYSTEM_LSR)) {
            string2 = REFERENCESYSTEM_LSRK;
        }
        super.setReferenceSystem(string2);
    }

    public String getReferenceSystem() {
        String string = super.getReferenceSystem();
        if (string.equals(REFERENCESYSTEM_LSR)) {
            string = REFERENCESYSTEM_LSRK;
            super.setReferenceSystem(REFERENCESYSTEM_LSRK);
        }
        return string;
    }

    private static double solarRadialVelocityLsrk(double d, double d2) {
        return Velocity.scalarProduct(SOLAR_MOTIONS, Velocity.spherical2cosine(d, d2));
    }

    private static double scalarProduct(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    private static double[] spherical2cosine(double d, double d2) {
        double[] dArray = new double[3];
        double d3 = Math.cos(d2);
        dArray[0] = Math.cos(d) * d3;
        dArray[1] = Math.sin(d) * d3;
        dArray[2] = Math.sin(d2);
        return dArray;
    }

    public void updateLocalReference() {
        this.getReferenceSystem();
    }

    public String toString() {
        return this.getCenterVelocity().getContentInUnits(Speed.UNIT_KM_S) + " km/s";
    }

    public boolean isTopocentric() {
        return this.getReferenceSystem().equals(REFERENCESYSTEM_TOPO);
    }

    public void setForceTopocentricConversionEnabled(boolean bl) {
        this.isForceTopocentricConversionEnabled = bl;
    }
}

