/*
 * Decompiled with CFR 0.152.
 */
package com.apporiented.algorithm.clustering;

import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.Distance;

public class ClusterPair
implements Comparable<ClusterPair> {
    private static long globalIndex = 0L;
    private Cluster lCluster;
    private Cluster rCluster;
    private Double linkageDistance;

    public ClusterPair() {
    }

    public ClusterPair(Cluster cluster, Cluster cluster2, Double d) {
        this.lCluster = cluster;
        this.rCluster = cluster2;
        this.linkageDistance = d;
    }

    public Cluster getOtherCluster(Cluster cluster) {
        return this.lCluster == cluster ? this.rCluster : this.lCluster;
    }

    public Cluster getlCluster() {
        return this.lCluster;
    }

    public void setlCluster(Cluster cluster) {
        this.lCluster = cluster;
    }

    public Cluster getrCluster() {
        return this.rCluster;
    }

    public void setrCluster(Cluster cluster) {
        this.rCluster = cluster;
    }

    public Double getLinkageDistance() {
        return this.linkageDistance;
    }

    public void setLinkageDistance(Double d) {
        this.linkageDistance = d;
    }

    public ClusterPair reverse() {
        return new ClusterPair(this.getrCluster(), this.getlCluster(), this.getLinkageDistance());
    }

    @Override
    public int compareTo(ClusterPair clusterPair) {
        int n = clusterPair == null || clusterPair.getLinkageDistance() == null ? -1 : (this.getLinkageDistance() == null ? 1 : this.getLinkageDistance().compareTo(clusterPair.getLinkageDistance()));
        return n;
    }

    public Cluster agglomerate(String object) {
        if (object == null) {
            object = "clstr#" + ++globalIndex;
        }
        Cluster cluster = new Cluster((String)object);
        cluster.setDistance(new Distance(this.getLinkageDistance()));
        cluster.addChild(this.lCluster);
        cluster.addChild(this.rCluster);
        this.lCluster.setParent(cluster);
        this.rCluster.setParent(cluster);
        Double d = this.lCluster.getWeightValue();
        Double d2 = this.rCluster.getWeightValue();
        double d3 = d + d2;
        cluster.getDistance().setWeight(d3);
        return cluster;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.lCluster != null) {
            stringBuilder.append(this.lCluster.getName());
        }
        if (this.rCluster != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" + ");
            }
            stringBuilder.append(this.rCluster.getName());
        }
        stringBuilder.append(" : ").append(this.linkageDistance);
        return stringBuilder.toString();
    }
}

