/*
 * Decompiled with CFR 0.152.
 */
package com.apporiented.algorithm.clustering;

import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.ClusterPair;
import com.apporiented.algorithm.clustering.Distance;
import com.apporiented.algorithm.clustering.DistanceMap;
import com.apporiented.algorithm.clustering.LinkageStrategy;
import java.util.ArrayList;
import java.util.List;

public class HierarchyBuilder {
    private DistanceMap distances;
    private List<Cluster> clusters;

    public DistanceMap getDistances() {
        return this.distances;
    }

    public List<Cluster> getClusters() {
        return this.clusters;
    }

    public HierarchyBuilder(List<Cluster> list, DistanceMap distanceMap) {
        this.clusters = list;
        this.distances = distanceMap;
    }

    public void agglomerate(LinkageStrategy linkageStrategy) {
        ClusterPair clusterPair = this.distances.removeFirst();
        if (clusterPair != null) {
            this.clusters.remove(clusterPair.getrCluster());
            this.clusters.remove(clusterPair.getlCluster());
            Cluster cluster = clusterPair.getlCluster();
            Cluster cluster2 = clusterPair.getrCluster();
            Cluster cluster3 = clusterPair.agglomerate(null);
            for (Cluster cluster4 : this.clusters) {
                Double d;
                Comparable<Double> comparable;
                ClusterPair clusterPair2 = this.findByClusters(cluster4, cluster);
                ClusterPair clusterPair3 = this.findByClusters(cluster4, cluster2);
                ClusterPair clusterPair4 = new ClusterPair();
                clusterPair4.setlCluster(cluster4);
                clusterPair4.setrCluster(cluster3);
                ArrayList<Distance> arrayList = new ArrayList<Distance>();
                if (clusterPair2 != null) {
                    comparable = clusterPair2.getLinkageDistance();
                    d = clusterPair2.getOtherCluster(cluster4).getWeightValue();
                    arrayList.add(new Distance((Double)comparable, d));
                    this.distances.remove(clusterPair2);
                }
                if (clusterPair3 != null) {
                    comparable = clusterPair3.getLinkageDistance();
                    d = clusterPair3.getOtherCluster(cluster4).getWeightValue();
                    arrayList.add(new Distance((Double)comparable, d));
                    this.distances.remove(clusterPair3);
                }
                comparable = linkageStrategy.calculateDistance(arrayList);
                clusterPair4.setLinkageDistance(((Distance)comparable).getDistance());
                this.distances.add(clusterPair4);
            }
            this.clusters.add(cluster3);
        }
    }

    private ClusterPair findByClusters(Cluster cluster, Cluster cluster2) {
        return this.distances.findByCodePair(cluster, cluster2);
    }

    public boolean isTreeComplete() {
        return this.clusters.size() == 1;
    }

    public Cluster getRootCluster() {
        if (!this.isTreeComplete()) {
            throw new RuntimeException("No root available");
        }
        return this.clusters.get(0);
    }
}

