/*
 * Decompiled with CFR 0.152.
 */
package com.apporiented.algorithm.clustering;

import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.ClusterPair;
import com.apporiented.algorithm.clustering.ClusteringAlgorithm;
import com.apporiented.algorithm.clustering.DistanceMap;
import com.apporiented.algorithm.clustering.HierarchyBuilder;
import com.apporiented.algorithm.clustering.LinkageStrategy;
import java.util.ArrayList;
import java.util.List;

public class PDistClusteringAlgorithm
implements ClusteringAlgorithm {
    @Override
    public Cluster performClustering(double[][] dArray, String[] stringArray, LinkageStrategy linkageStrategy) {
        if (dArray == null || dArray.length == 0) {
            throw new IllegalArgumentException("Invalid distance matrix");
        }
        if (dArray[0].length != stringArray.length * (stringArray.length - 1) / 2) {
            throw new IllegalArgumentException("Invalid cluster name array");
        }
        if (linkageStrategy == null) {
            throw new IllegalArgumentException("Undefined linkage strategy");
        }
        List<Cluster> list = this.createClusters(stringArray);
        DistanceMap distanceMap = this.createLinkages(dArray, list);
        HierarchyBuilder hierarchyBuilder = new HierarchyBuilder(list, distanceMap);
        while (!hierarchyBuilder.isTreeComplete()) {
            hierarchyBuilder.agglomerate(linkageStrategy);
        }
        return hierarchyBuilder.getRootCluster();
    }

    @Override
    public Cluster performWeightedClustering(double[][] dArray, String[] stringArray, double[] dArray2, LinkageStrategy linkageStrategy) {
        return this.performClustering(dArray, stringArray, linkageStrategy);
    }

    private DistanceMap createLinkages(double[][] dArray, List<Cluster> list) {
        DistanceMap distanceMap = new DistanceMap();
        for (int i = 0; i < list.size(); ++i) {
            Cluster cluster = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                ClusterPair clusterPair = new ClusterPair();
                Double d = dArray[0][PDistClusteringAlgorithm.accessFunction(j, i, list.size())];
                clusterPair.setLinkageDistance(d);
                clusterPair.setlCluster(cluster);
                clusterPair.setrCluster(list.get(j));
                distanceMap.add(clusterPair);
            }
        }
        return distanceMap;
    }

    private List<Cluster> createClusters(String[] stringArray) {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (String string : stringArray) {
            Cluster cluster = new Cluster(string);
            arrayList.add(cluster);
        }
        return arrayList;
    }

    private static int accessFunction(int n, int n2, int n3) {
        return n3 * n2 - n2 * (n2 + 1) / 2 + n - 1 - n2;
    }
}

