/*
 * Decompiled with CFR 0.152.
 */
package net.boplicity.xmleditor;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import net.boplicity.xmleditor.XmlEditorKit;

public class XmlTextPane
extends JTextPane {
    private static final long serialVersionUID = 6270183148379328084L;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public XmlTextPane() {
        this.setEditorKitForContentType("text/xml", new XmlEditorKit());
        this.setContentType("text/xml");
        this.addKeyListener(new IndentKeyListener());
    }

    private class IndentKeyListener
    implements KeyListener {
        private boolean enterFlag;
        private final Character NEW_LINE = Character.valueOf('\n');

        private IndentKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.enterFlag = false;
            if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() == 0 && XmlTextPane.this.getSelectionStart() == XmlTextPane.this.getSelectionEnd()) {
                this.enterFlag = true;
                keyEvent.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiers() == 0 && this.enterFlag) {
                keyEvent.consume();
                String string = XmlTextPane.this.getText();
                int n = XmlTextPane.this.getCaretPosition();
                try {
                    if (string.charAt(n) == this.NEW_LINE.charValue()) {
                        --n;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                try {
                    int n2;
                    if (string.charAt(n2) != this.NEW_LINE.charValue()) {
                        int n3;
                        for (n3 = n2 = string.lastIndexOf(this.NEW_LINE.charValue(), n) + 1; n3 < string.length() && Character.isWhitespace(string.charAt(n3)) && string.charAt(n3) != this.NEW_LINE.charValue(); ++n3) {
                        }
                        if (n3 > n2) {
                            XmlTextPane.this.getDocument().insertString(XmlTextPane.this.getCaretPosition(), this.NEW_LINE + string.substring(n2, n3), null);
                        } else {
                            XmlTextPane.this.getDocument().insertString(XmlTextPane.this.getCaretPosition(), this.NEW_LINE.toString(), null);
                        }
                    } else {
                        XmlTextPane.this.getDocument().insertString(XmlTextPane.this.getCaretPosition(), this.NEW_LINE.toString(), null);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    try {
                        XmlTextPane.this.getDocument().insertString(XmlTextPane.this.getCaretPosition(), this.NEW_LINE.toString(), null);
                    }
                    catch (BadLocationException badLocationException) {
                        XmlTextPane.this.logger.log(Level.WARNING, badLocationException.toString());
                    }
                }
                catch (BadLocationException badLocationException) {
                    XmlTextPane.this.logger.log(Level.WARNING, badLocationException.toString());
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }
}

