/*
 * Decompiled with CFR 0.152.
 */
package net.boplicity.xmleditor;

import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public class XmlView
extends PlainView {
    private static HashMap<Pattern, Color> patternColors;
    private static String GENERIC_XML_NAME;
    private static String TAG_PATTERN;
    private static String TAG_END_PATTERN;
    private static String TAG_ATTRIBUTE_PATTERN;
    private static String TAG_ATTRIBUTE_VALUE;
    private static String TAG_COMMENT;
    private static String TAG_CDATA;

    public XmlView(Element element) {
        super(element);
        this.getDocument().putProperty("tabSize", 4);
    }

    @Override
    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        Document document = this.getDocument();
        String string = document.getText(n3, n4 - n3);
        Segment segment = this.getLineBuffer();
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Color> treeMap2 = new TreeMap<Integer, Color>();
        for (Map.Entry<Pattern, Color> object : patternColors.entrySet()) {
            Matcher matcher = object.getKey().matcher(string);
            while (matcher.find()) {
                treeMap.put(matcher.start(1), matcher.end());
                treeMap2.put(matcher.start(1), object.getValue());
            }
        }
        int n5 = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            int n6 = (Integer)entry.getKey();
            int n7 = (Integer)entry.getValue();
            if (n5 < n6) {
                graphics.setColor(Color.black);
                document.getText(n3 + n5, n6 - n5, segment);
                n = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n5);
            }
            graphics.setColor((Color)treeMap2.get(n6));
            n5 = n7;
            document.getText(n3 + n6, n5 - n6, segment);
            n = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n6);
        }
        if (n5 < string.length()) {
            graphics.setColor(Color.black);
            document.getText(n3 + n5, string.length() - n5, segment);
            n = Utilities.drawTabbedText(segment, n, n2, graphics, (TabExpander)this, n5);
        }
        return n;
    }

    static {
        GENERIC_XML_NAME = "[A-Za-z]+[A-Za-z0-9\\-_]*(:[A-Za-z]+[A-Za-z0-9\\-_]+)?";
        TAG_PATTERN = "(</?" + GENERIC_XML_NAME + ")";
        TAG_END_PATTERN = "(>|/>)";
        TAG_ATTRIBUTE_PATTERN = "(" + GENERIC_XML_NAME + ")\\w*\\=";
        TAG_ATTRIBUTE_VALUE = "\\w*\\=\\w*(\"[^\"]*\")";
        TAG_COMMENT = "(<\\!--[\\w ]*-->)";
        TAG_CDATA = "(<\\!\\[CDATA\\[.*\\]\\]>)";
        patternColors = new LinkedHashMap<Pattern, Color>();
        Color color = new Color(63, 127, 127);
        patternColors.put(Pattern.compile(TAG_PATTERN), color);
        patternColors.put(Pattern.compile(TAG_CDATA), Color.GRAY);
        patternColors.put(Pattern.compile(TAG_ATTRIBUTE_PATTERN), new Color(127, 0, 127));
        patternColors.put(Pattern.compile(TAG_END_PATTERN), color);
        patternColors.put(Pattern.compile(TAG_ATTRIBUTE_VALUE), new Color(42, 0, 255));
        patternColors.put(Pattern.compile(TAG_COMMENT), Color.BLUE);
    }
}

