/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.archive;

import com.cosylab.logging.LoggingClient;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.swing.ImageIcon;

public class ArchiveConnectionManager {
    private final String ARCHIVE_CLASS_NAME = "alma.archive.logging.ArchiveLoggingQuery";
    private final String METHOD_NAME = "getLog";
    private DBState status;
    private Object archive = null;
    private Method getLogMethod;
    private LoggingClient logging;

    public ArchiveConnectionManager(LoggingClient loggingClient) {
        if (loggingClient == null) {
            throw new IllegalArgumentException("Invalid null LoggingClient reference");
        }
        this.logging = loggingClient;
        this.archive = this.loadArchiveClass();
        if (this.archive == null) {
            this.status = DBState.DATABASE_NOP;
            this.showDBStatus("Database connection not available");
        } else {
            this.getLogMethod = this.getMethod(this.archive);
            if (this.getLogMethod == null) {
                this.status = DBState.DATABASE_NOP;
                this.showDBStatus("Database connection not available");
            } else {
                this.status = DBState.DATABASE_OK;
                this.showDBStatus("Database ready");
            }
        }
    }

    private Object loadArchiveClass() {
        try {
            Thread t = Thread.currentThread();
            ClassLoader loader = t.getContextClassLoader();
            Class<?> cl = loader.loadClass("alma.archive.logging.ArchiveLoggingQuery");
            Class[] classes = new Class[]{Class.forName("java.util.logging.Logger")};
            Constructor<?> constructor = cl.getConstructor(classes);
            Object obj = constructor.newInstance(new Object[]{null});
            return cl.cast(obj);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private Method getMethod(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Invalid null parameter in getMethod");
        }
        Method ret = null;
        Class<?> cl = obj.getClass();
        try {
            cl = Class.forName("alma.archive.logging.ArchiveLoggingQuery");
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        Class[] paramClasses = null;
        try {
            paramClasses = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.String"), Short.TYPE, Short.TYPE, Class.forName("java.lang.String"), Class.forName("java.lang.String"), Class.forName("java.lang.String"), Integer.TYPE};
        }
        catch (Exception e) {
            return null;
        }
        try {
            ret = cl.getMethod("getLog", paramClasses);
        }
        catch (Throwable t) {
            System.out.println("This mehtod does not exist in " + cl.getName());
            System.out.println("\tgetLog(");
            for (int temp = 0; temp < paramClasses.length; ++temp) {
                System.out.println("\t\t" + paramClasses[temp].getName() + ",");
            }
            System.out.println("\t\t(\n\tDatabase connection not available:\n" + t.getMessage());
            t.printStackTrace();
            return null;
        }
        if (!ret.getReturnType().getName().equals("java.util.Collection")) {
            System.out.println("The method returns " + ret.getReturnType().getName() + " instead of java.util.Collection");
            System.out.println("Database connection not available");
            return null;
        }
        return ret;
    }

    private void showDBStatus(String msg) {
        this.logging.showDBStatus(this.status.icon, msg);
    }

    public DBState getDBStatus() {
        if (this.logging.inDebugMode()) {
            return DBState.DATABASE_OK;
        }
        return this.status;
    }

    public Collection getLogs(String from, String to, short minType, short maxType, String routine, String source, String process, int maxRows) throws Exception {
        this.status = DBState.DATABASE_WORKING;
        this.showDBStatus("Executing a query");
        Object[] params = new Object[]{from, to, minType, maxType, routine, source, process, maxRows};
        Object ret = null;
        try {
            ret = this.getLogMethod.invoke(this.archive, params);
        }
        catch (Throwable t) {
            this.status = DBState.DATABASE_OK;
            this.showDBStatus("Database ready.");
            System.out.println("Exception thrown: " + t);
            throw new Exception("Error executing a query.", t);
        }
        this.status = DBState.DATABASE_OK;
        this.showDBStatus("Database ready");
        return (Collection)ret;
    }

    public static enum DBState {
        DATABASE_OK("/databaseLink.png"),
        DATABASE_NOP("/databaseNOP.png"),
        DATABASE_WORKING("/databaseBusy.png");

        public final ImageIcon icon;

        private DBState(String iconStr) {
            this.icon = new ImageIcon(ArchiveConnectionManager.class.getResource(iconStr));
        }
    }
}

