/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.dialogs.error;

import alma.acs.logging.dialogs.error.ErrorLogFile;
import com.cosylab.logging.engine.log.LogTypeHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ErrorLogDialog
extends JDialog
implements ActionListener {
    private final JTextArea logTA = new JTextArea("", 20, 60);
    private PlainDocument document = new PlainDocument();
    private JButton closeBtn;
    private JButton cleanAllBtn;
    private JButton saveAllBtn;
    private JToolBar toolBar;
    private long maxLength;
    private final String ERRORLOG_SIZE_PROP_NAME = "jlog.errorlog.size";
    private final long ERROR_LOG_DEFAULT_SIZE = 50000000L;
    private ErrorLogFile outFile = null;

    public ErrorLogDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.setDefaultCloseOperation(1);
        this.maxLength = Long.getLong("jlog.errorlog.size", 50000000L);
        System.out.println("Max length of in-memory error log " + this.maxLength);
        this.outFile = new ErrorLogFile(30, "jlog.", ".error.log", System.getProperty("ACS.tmp"), true, false);
        this.initGUI();
        this.pack();
        this.setVisible(false);
        this.toFront();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGUI() {
        ImageIcon icon = new ImageIcon(LogTypeHelper.class.getResource("/errorLogIcon.png"));
        this.setIconImage(icon.getImage());
        JTextArea jTextArea = this.logTA;
        synchronized (jTextArea) {
            this.logTA.setDocument(this.document);
            this.logTA.setEditable(false);
        }
        JScrollPane logSP = new JScrollPane(this.logTA);
        JRootPane mainPnl = this.getRootPane();
        mainPnl.setLayout(new BorderLayout());
        mainPnl.add((Component)logSP, "Center");
        JPanel btnPnl = new JPanel(new FlowLayout());
        this.closeBtn = new JButton("Close");
        this.closeBtn.addActionListener(this);
        btnPnl.add(this.closeBtn);
        mainPnl.add((Component)btnPnl, "South");
        this.toolBar = new JToolBar();
        JPanel toolBarPanel = new JPanel(new FlowLayout(0));
        ImageIcon cleanIcon = new ImageIcon(ErrorLogDialog.class.getResource("/delete.png"));
        this.cleanAllBtn = new JButton("<HTML><Font size=\"-1\">Clean</FONT></HTML>", cleanIcon);
        this.cleanAllBtn.addActionListener(this);
        this.cleanAllBtn.setToolTipText("Delete log");
        ImageIcon saveIcon = new ImageIcon(ErrorLogDialog.class.getResource("/disk.png"));
        this.saveAllBtn = new JButton("<HTML><Font size=\"-1\">Save</FONT></HTML>", saveIcon);
        this.saveAllBtn.addActionListener(this);
        this.saveAllBtn.setToolTipText("Save log");
        toolBarPanel.add(this.cleanAllBtn);
        toolBarPanel.add(this.saveAllBtn);
        this.toolBar.add(toolBarPanel);
        mainPnl.add((Component)this.toolBar, "First");
        this.rationalizeButtons();
    }

    public synchronized void appendText(String str) {
        class RunAsyncAppend
        implements Runnable {
            private String theString;

            public RunAsyncAppend(String str) {
                this.theString = str;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int len = ErrorLogDialog.this.document.getLength();
                JTextArea jTextArea = ErrorLogDialog.this.logTA;
                synchronized (jTextArea) {
                    if (ErrorLogDialog.this.maxLength > 0L && (long)len > ErrorLogDialog.this.maxLength) {
                        String strToFlush;
                        try {
                            strToFlush = ErrorLogDialog.this.logTA.getText(0, this.theString.length());
                        }
                        catch (BadLocationException ble) {
                            System.out.println("Error removing text from the TextArea: " + ble.getMessage());
                            ble.printStackTrace();
                            return;
                        }
                        ErrorLogDialog.this.logTA.replaceRange("", 0, this.theString.length());
                        try {
                            ErrorLogDialog.this.outFile.append(strToFlush);
                        }
                        catch (Throwable t) {
                            JOptionPane.showInternalMessageDialog(ErrorLogDialog.this.logTA, "<HTML>Error saving errors in temp file: <I>" + t.getMessage() + "</I><BR>saving is limited to the content of the text area.</HTML>", "Error saving errors ", 1);
                        }
                    }
                    ErrorLogDialog.this.logTA.append(this.theString);
                }
                ErrorLogDialog.this.rationalizeButtons();
            }
        }
        RunAsyncAppend runAppend = new RunAsyncAppend(str);
        SwingUtilities.invokeLater(runAppend);
    }

    public synchronized void clearAll() {
        Runnable clearTA = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JTextArea jTextArea = ErrorLogDialog.this.logTA;
                synchronized (jTextArea) {
                    if (ErrorLogDialog.this.document.getLength() > 0) {
                        ErrorLogDialog.this.logTA.replaceRange("", 0, ErrorLogDialog.this.document.getLength());
                    }
                }
            }
        };
        SwingUtilities.invokeLater(clearTA);
        this.outFile.clear();
        this.rationalizeButtons();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeBtn) {
            this.setVisible(false);
        } else if (e.getSource() == this.saveAllBtn) {
            this.saveAllLog();
        } else if (e.getSource() == this.cleanAllBtn) {
            this.clearAll();
        } else {
            System.err.println("Action unknown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAllLog() {
        File f = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle("Save error log");
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        f = chooser.getSelectedFile();
        FileOutputStream fStream = null;
        try {
            fStream = new FileOutputStream(f);
        }
        catch (FileNotFoundException fnfe) {
            JOptionPane.showMessageDialog(this, "Error opening the file", "Error saving the log", 0);
            System.out.println(fnfe.getMessage());
            fnfe.printStackTrace();
            return;
        }
        BufferedOutputStream bufOutStream = new BufferedOutputStream(fStream);
        try {
            this.outFile.copy(bufOutStream);
        }
        catch (Exception e) {
            System.err.println("Error saving the logs on disk: " + e.getMessage());
            JOptionPane.showMessageDialog(this, "Error saving logs from temp file", "Error saving error log", 0);
            e.printStackTrace();
            return;
        }
        JTextArea e = this.logTA;
        synchronized (e) {
            try {
                bufOutStream.write(this.logTA.getText().getBytes());
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, "Error writing on file", "Error saving the log", 0);
                System.out.println(ioe.getMessage());
                ioe.printStackTrace();
                return;
            }
        }
        try {
            bufOutStream.flush();
            bufOutStream.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Error closing the file", "Error saving the log", 0);
            System.out.println(ioe.getMessage());
            ioe.printStackTrace();
            return;
        }
    }

    private void rationalizeButtons() {
        Runnable ratio = new Runnable(){

            @Override
            public void run() {
                ErrorLogDialog.this.saveAllBtn.setEnabled(ErrorLogDialog.this.document.getLength() > 0);
                ErrorLogDialog.this.cleanAllBtn.setEnabled(ErrorLogDialog.this.document.getLength() > 0);
            }
        };
        SwingUtilities.invokeLater(ratio);
    }

    @Override
    public void dispose() {
        if (this.outFile != null) {
            this.outFile.close();
        }
        super.dispose();
    }

    public void setVisible(boolean visible, Component c) {
        super.setVisible(visible);
        if (visible) {
            this.setLocationRelativeTo(c);
        }
    }
}

