/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.preferences;

import alma.acs.logging.preferences.UserPreferences;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;

public class ExpertPrefsDlg
extends JDialog
implements ActionListener {
    private UserPreferences preferences;
    private UserPreferences originalPreferences;
    private JButton okBtn;
    private JButton cancelBtn;
    private JButton restoreBtn;
    private boolean okBtnPressed = false;
    private Component owner;
    private JComboBox maxLogsInTableCB = new JComboBox<NumberOption>(NumberOption.values());
    private JComboBox timeFrameCB = new JComboBox<TimeOption>(TimeOption.values());
    private JTextField inputRateTF = new JTextField("0", 8);
    private JTextField outputRateTF = new JTextField("0", 8);
    private JTextField dynThresholdTF = new JTextField("0", 6);
    private JTextField dynDampingTF = new JTextField("0", 6);
    private JTextField dynIntervalTF = new JTextField("0", 6);

    public ExpertPrefsDlg(Component owner, UserPreferences prefs) {
        if (owner == null) {
            throw new IllegalArgumentException("The owner can't be null");
        }
        if (prefs == null) {
            throw new IllegalArgumentException("The preferences can't be null");
        }
        this.setTitle("Preferences");
        this.setName("ExpertPrefsDlg");
        this.owner = owner;
        this.originalPreferences = prefs;
        try {
            this.preferences = prefs.clone();
            System.out.println("Prefs: " + this.preferences.getMaxNumOfLogs() + ", " + this.preferences.getMinuteTimeFrame() + ", " + this.preferences.getMaxInputRate() + ", " + this.preferences.getMaxOutputRate());
        }
        catch (CloneNotSupportedException e) {
            this.preferences = new UserPreferences(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.buildWidgets();
        this.initGUI();
        this.ratioWidgets();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            this.enableOption((JCheckBox)e.getSource());
        } else if (e.getSource() == this.okBtn) {
            this.okBtnPressed = true;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.cancelBtn) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.restoreBtn) {
            try {
                this.preferences = this.originalPreferences.clone();
            }
            catch (CloneNotSupportedException ce) {
                this.preferences = new UserPreferences(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            this.ratioWidgets();
        } else {
            System.err.println("Event not handled " + e.getSource());
        }
    }

    private void initGUI() {
        JRootPane mainPnl = this.getRootPane();
        mainPnl.setLayout(new BorderLayout());
        JPanel tablePnl = new JPanel();
        tablePnl.setBorder(BorderFactory.createTitledBorder("Table constraints"));
        tablePnl.setLayout(new GridBagLayout());
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 0;
        constr.fill = 2;
        constr.anchor = 17;
        constr.insets = new Insets(5, 5, 5, 5);
        tablePnl.add((Component)OptionWidgets.MAX_NUM_OF_LOGS.enableCB, constr);
        constr.gridx = 1;
        constr.gridy = 0;
        constr.anchor = 21;
        constr.insets = new Insets(5, 5, 5, 5);
        constr.fill = 2;
        tablePnl.add((Component)this.maxLogsInTableCB, constr);
        constr.gridx = 0;
        constr.gridy = 1;
        constr.anchor = 17;
        constr.insets = new Insets(5, 5, 5, 5);
        tablePnl.add((Component)OptionWidgets.TIME_FRAME.enableCB, constr);
        constr.gridx = 1;
        constr.gridy = 1;
        constr.anchor = 21;
        constr.insets = new Insets(5, 5, 5, 5);
        tablePnl.add((Component)this.timeFrameCB, constr);
        this.timeFrameCB.setEnabled(false);
        OptionWidgets.TIME_FRAME.enableCB.setEnabled(false);
        JPanel enginePnl = new JPanel();
        enginePnl.setBorder(BorderFactory.createTitledBorder("Engine constraints"));
        enginePnl.setLayout(new GridBagLayout());
        constr.gridx = 0;
        constr.gridy = 0;
        constr.anchor = 25;
        constr.insets = new Insets(5, 5, 5, 5);
        enginePnl.add((Component)OptionWidgets.MAX_INPUT_RATE.enableCB, constr);
        constr.gridx = 1;
        constr.gridy = 0;
        constr.anchor = 25;
        constr.insets = new Insets(5, 5, 5, 5);
        enginePnl.add((Component)this.inputRateTF, constr);
        constr.gridx = 0;
        constr.gridy = 1;
        constr.anchor = 25;
        constr.insets = new Insets(5, 5, 5, 5);
        enginePnl.add((Component)OptionWidgets.MAX_OUTPUT_RATE.enableCB, constr);
        constr.gridx = 1;
        constr.gridy = 1;
        constr.anchor = 25;
        constr.insets = new Insets(5, 5, 5, 5);
        enginePnl.add((Component)this.outputRateTF, constr);
        JPanel pnl = new JPanel();
        pnl.setLayout(new GridLayout(3, 2));
        pnl.add((Component)new JLabel("Threshold: "), "1");
        pnl.add((Component)this.dynThresholdTF, "2");
        pnl.add((Component)new JLabel("Damping: "), "3");
        pnl.add((Component)this.dynDampingTF, "4");
        pnl.add((Component)new JLabel("Time: "), "5");
        pnl.add((Component)this.dynIntervalTF, "6");
        constr.gridx = 0;
        constr.gridy = 2;
        constr.fill = 3;
        constr.anchor = 25;
        constr.insets = new Insets(5, 5, 5, 5);
        enginePnl.add((Component)OptionWidgets.DYNAMIC_DISCARD_LEVEL.enableCB, constr);
        constr.gridx = 1;
        constr.gridy = 2;
        constr.anchor = 25;
        constr.insets = new Insets(5, 5, 5, 5);
        enginePnl.add((Component)pnl, constr);
        mainPnl.add((Component)tablePnl, "Center");
        mainPnl.add((Component)enginePnl, "North");
        JPanel buttonsPnl = new JPanel(new BorderLayout());
        JPanel okCancelPnl = new JPanel();
        okCancelPnl.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        BoxLayout boxLayout = new BoxLayout(okCancelPnl, 2);
        okCancelPnl.setLayout(boxLayout);
        okCancelPnl.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.okBtn = new JButton("Ok");
        this.okBtn.addActionListener(this);
        this.cancelBtn = new JButton("Cancel");
        this.cancelBtn.addActionListener(this);
        okCancelPnl.add((Component)this.okBtn, "West");
        okCancelPnl.add(Box.createRigidArea(new Dimension(10, 0)));
        okCancelPnl.add((Component)this.cancelBtn, "East");
        JPanel restoreBtnPnl = new JPanel(new FlowLayout());
        this.restoreBtn = new JButton("Restore");
        this.restoreBtn.addActionListener(this);
        restoreBtnPnl.add(this.restoreBtn);
        buttonsPnl.add((Component)restoreBtnPnl, "West");
        buttonsPnl.add((Component)okCancelPnl, "East");
        mainPnl.add((Component)buttonsPnl, "South");
        this.pack();
    }

    private void buildWidgets() {
        this.maxLogsInTableCB.setEditable(false);
        this.maxLogsInTableCB.setMaximumRowCount(NumberOption.values().length);
        this.timeFrameCB.setEditable(false);
        this.timeFrameCB.setMaximumRowCount(TimeOption.values().length);
        this.inputRateTF.setInputVerifier(new PassVerifier(1));
        this.outputRateTF.setInputVerifier(new PassVerifier(1));
        this.dynThresholdTF.setInputVerifier(new PassVerifier(1024));
        this.dynDampingTF.setInputVerifier(new PassVerifier(0));
        this.dynIntervalTF.setInputVerifier(new PassVerifier(1));
        for (OptionWidgets widget : OptionWidgets.values()) {
            widget.enableCB.addActionListener(this);
        }
    }

    private void ratioWidgets() {
        NumberOption nOpt = NumberOption.fromInt(this.preferences.getMaxNumOfLogs());
        if (nOpt == null) {
            this.maxLogsInTableCB.setSelectedIndex(2);
        } else {
            this.maxLogsInTableCB.setSelectedIndex(nOpt.ordinal());
        }
        OptionWidgets.MAX_NUM_OF_LOGS.enableCB.setSelected(this.maxLogsInTableCB.getSelectedIndex() != 0);
        TimeOption tOpt = TimeOption.fromInt(this.preferences.getMinuteTimeFrame());
        if (tOpt == null) {
            this.timeFrameCB.setSelectedIndex(0);
        } else {
            this.timeFrameCB.setSelectedIndex(tOpt.ordinal());
        }
        OptionWidgets.TIME_FRAME.enableCB.setSelected(this.timeFrameCB.getSelectedIndex() != 0);
        if (this.preferences.getMaxInputRate() == Integer.MAX_VALUE) {
            this.inputRateTF.setText("0");
        } else {
            this.inputRateTF.setText("" + this.preferences.getMaxInputRate());
        }
        OptionWidgets.MAX_INPUT_RATE.enableCB.setSelected(this.preferences.getMaxInputRate() != Integer.MAX_VALUE);
        if (this.preferences.getMaxOutputRate() == Integer.MAX_VALUE) {
            this.outputRateTF.setText("0");
        } else {
            this.outputRateTF.setText("" + this.preferences.getMaxOutputRate());
        }
        OptionWidgets.MAX_OUTPUT_RATE.enableCB.setSelected(this.preferences.getMaxOutputRate() != Integer.MAX_VALUE);
        if (this.preferences.getDynThreshold() == Integer.MAX_VALUE) {
            this.dynThresholdTF.setText("8192");
            this.dynDampingTF.setText("2048");
            this.dynIntervalTF.setText("30");
        }
        OptionWidgets.DYNAMIC_DISCARD_LEVEL.enableCB.setSelected(this.preferences.getDynThreshold() != Integer.MAX_VALUE);
        for (OptionWidgets opt : OptionWidgets.values()) {
            this.enableOption(opt.enableCB);
        }
    }

    private void enableOption(JCheckBox cB) {
        if (cB == null) {
            throw new IllegalArgumentException("The JCheckBox can't be null");
        }
        OptionWidgets opt = OptionWidgets.fromCheckBox(cB);
        switch (opt) {
            case MAX_NUM_OF_LOGS: {
                this.maxLogsInTableCB.setEnabled(cB.isSelected());
                break;
            }
            case TIME_FRAME: {
                this.timeFrameCB.setEnabled(cB.isSelected());
                break;
            }
            case MAX_INPUT_RATE: {
                this.inputRateTF.setEnabled(cB.isSelected());
                break;
            }
            case MAX_OUTPUT_RATE: {
                this.outputRateTF.setEnabled(cB.isSelected());
                break;
            }
            case DYNAMIC_DISCARD_LEVEL: {
                this.dynThresholdTF.setEnabled(cB.isSelected());
                this.dynDampingTF.setEnabled(cB.isSelected());
                this.dynIntervalTF.setEnabled(cB.isSelected());
            }
        }
    }

    public boolean okPressed() {
        return this.okBtnPressed;
    }

    public UserPreferences getPreferences() {
        String val;
        Enum opt;
        if (OptionWidgets.MAX_NUM_OF_LOGS.isOptionEnabled()) {
            System.out.println("A");
            opt = (NumberOption)((Object)this.maxLogsInTableCB.getSelectedItem());
            this.preferences.setMaxLogs(((NumberOption)opt).value);
        } else {
            System.out.println("B");
            this.preferences.setMaxLogs(0);
        }
        if (OptionWidgets.TIME_FRAME.isOptionEnabled()) {
            opt = (TimeOption)((Object)this.timeFrameCB.getSelectedItem());
            this.preferences.setTimeFrame(((TimeOption)opt).value);
        } else {
            this.preferences.setTimeFrame(0);
        }
        if (OptionWidgets.MAX_INPUT_RATE.isOptionEnabled()) {
            val = this.inputRateTF.getText();
            this.preferences.setMaxInputRate(Integer.parseInt(val));
        } else {
            this.preferences.setMaxInputRate(Integer.MAX_VALUE);
        }
        if (OptionWidgets.MAX_OUTPUT_RATE.isOptionEnabled()) {
            val = this.outputRateTF.getText();
            this.preferences.setMaxOutputRate(Integer.parseInt(val));
        } else {
            this.preferences.setMaxOutputRate(Integer.MAX_VALUE);
        }
        if (OptionWidgets.DYNAMIC_DISCARD_LEVEL.isOptionEnabled()) {
            this.preferences.setDynThreshold(Integer.parseInt(this.dynThresholdTF.getText()));
            this.preferences.setDynDamping(Integer.parseInt(this.dynDampingTF.getText()));
            this.preferences.setDynTime(Integer.parseInt(this.dynIntervalTF.getText()));
        } else {
            this.preferences.setDynThreshold(Integer.MAX_VALUE);
            this.preferences.setDynDamping(0);
            this.preferences.setDynTime(30);
        }
        return this.preferences;
    }

    @Override
    public void setVisible(boolean visible) {
        this.setLocationRelativeTo(this.owner);
        this.pack();
        super.setVisible(visible);
        this.toFront();
    }

    public static enum NumberOption {
        UNLIMITED("Unlimited", 0),
        K100("100K", 100000),
        K200("200K", 200000),
        K300("300K", 300000),
        K400("400K", 400000),
        K500("500K", 500000);

        public final String label;
        public final int value;

        private NumberOption(String lbl, int val) {
            this.label = lbl;
            this.value = val;
        }

        public String toString() {
            return this.label;
        }

        public static NumberOption fromInt(int val) {
            for (NumberOption nOpt : NumberOption.values()) {
                if (nOpt.value != val) continue;
                return nOpt;
            }
            return null;
        }
    }

    public static enum TimeOption {
        UNLIMITED("Unlimited", 0),
        H1("1h", 60),
        H3("3h", 180),
        H5("5h", 300),
        H12("12h", 720),
        D1("1d", 1440);

        public final String label;
        public final int value;

        private TimeOption(String lbl, int val) {
            this.label = lbl;
            this.value = val;
        }

        public String toString() {
            return this.label;
        }

        public static TimeOption fromInt(int val) {
            for (TimeOption tOpt : TimeOption.values()) {
                if (tOpt.value != val) continue;
                return tOpt;
            }
            return null;
        }
    }

    public static enum OptionWidgets {
        MAX_NUM_OF_LOGS("Max num. of logs:", null),
        TIME_FRAME("Time frame:", null),
        MAX_INPUT_RATE("Max rate of logs from NC: ", "<HTML><FONT color=red>!</FONT> Use with care: can cause loss of logs"),
        MAX_OUTPUT_RATE("Max rate of logs in table: ", "<HTML><FONT color=red>!</FONT> Use with care: can cause out of memory"),
        DYNAMIC_DISCARD_LEVEL("Dynamic discard level: ", "<HTML><FONT color=red>!</FONT> Use with care: can cause out of memory");

        public final JCheckBox enableCB = new JCheckBox();

        private OptionWidgets(String label, String tooltip) {
            this.enableCB.setText(label);
            this.enableCB.setToolTipText(tooltip);
        }

        public boolean isOptionEnabled() {
            return this.enableCB.isSelected();
        }

        public static OptionWidgets fromCheckBox(JCheckBox cb) {
            if (cb == null) {
                throw new IllegalArgumentException("cb can't be null");
            }
            for (OptionWidgets opt : OptionWidgets.values()) {
                if (opt.enableCB != cb) continue;
                return opt;
            }
            throw new IllegalArgumentException("The passed is not part of TimeOptions.enableCB");
        }
    }

    private static class PassVerifier
    extends InputVerifier {
        private final int limit;

        public PassVerifier(int lowLimit) {
            this.limit = lowLimit;
        }

        @Override
        public boolean verify(JComponent input) {
            JTextField tf = (JTextField)input;
            try {
                boolean ret;
                Integer val = Integer.parseInt(tf.getText());
                boolean bl = ret = val >= this.limit;
                if (ret) {
                    input.setForeground(Color.black);
                } else {
                    input.setForeground(Color.red);
                }
                return ret;
            }
            catch (Exception e) {
                input.setForeground(Color.red);
                return false;
            }
        }
    }
}

