/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.logging.tools;

import alma.acs.logging.engine.io.IOHelper;
import alma.acs.logging.engine.io.IOPorgressListener;
import alma.acs.logging.tools.LogConverter;
import alma.acs.logging.tools.XMLConverter;
import alma.acs.util.IsoDateFormat;
import com.cosylab.logging.engine.ACS.ACSRemoteErrorListener;
import com.cosylab.logging.engine.ACS.ACSRemoteLogListener;
import com.cosylab.logging.engine.log.ILogEntry;
import com.cosylab.logging.engine.log.LogField;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogFileSplitter
implements ACSRemoteLogListener,
ACSRemoteErrorListener,
IOPorgressListener {
    private final String[] inFileNames;
    private String destFileName;
    private int index = 0;
    private Integer number = null;
    private Integer time = null;
    private int logsRead = 0;
    private long firstLogDate = -1L;
    private static final int OUTPUT_BUFFER_SIZE = 8192;
    private BufferedWriter outF = null;
    private final SimpleDateFormat dateFormat = new IsoDateFormat();
    private final LogConverter converter;

    public LogFileSplitter(String[] inputFiles, String outputFiles, Integer num, Integer mins, LogConverter converter) {
        if (outputFiles == null) {
            throw new IllegalArgumentException("The dest file name can't be null");
        }
        if (inputFiles != null && inputFiles.length == 0) {
            throw new IllegalArgumentException("No source files");
        }
        if (num == null && mins == null) {
            throw new IllegalArgumentException("Missing criteria (num and time are null)");
        }
        if (num != null && mins != null) {
            throw new IllegalArgumentException("Number and time criteria requested");
        }
        if (num != null && num <= 0) {
            throw new IllegalArgumentException("Invalid number " + num);
        }
        if (mins != null && mins <= 0) {
            throw new IllegalArgumentException("Invalid minutes " + num);
        }
        if (num != null && num < 50000) {
            System.out.println("Warning splitting for less then 50000 logs can create a big number of files");
        }
        if (converter == null) {
            throw new IllegalArgumentException("The converter can't be null");
        }
        this.converter = converter;
        this.inFileNames = new String[inputFiles.length];
        System.arraycopy(inputFiles, 0, this.inFileNames, 0, inputFiles.length);
        this.destFileName = outputFiles;
        this.number = num;
        if (mins != null) {
            this.time = mins * 60 * 1000;
        }
    }

    public void split() throws Exception {
        IOHelper ioHelper = new IOHelper();
        if (this.inFileNames == null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            ioHelper.loadLogs(in, (ACSRemoteLogListener)this, null, (ACSRemoteErrorListener)this, (IOPorgressListener)this);
        } else {
            for (String inFileName : this.inFileNames) {
                System.out.println("Processing " + inFileName);
                ioHelper.loadLogs(inFileName, (ACSRemoteLogListener)this, null, (ACSRemoteErrorListener)this, (IOPorgressListener)this);
            }
        }
        if (this.outF != null) {
            this.closeOutputFile(this.outF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedWriter getOutputFile(String dest, int idx, Date startingDate) throws IOException {
        StringBuilder name = new StringBuilder(dest);
        name.append('-');
        name.append(idx);
        if (startingDate != null) {
            name.append('-');
            StringBuffer buffer = new StringBuffer();
            SimpleDateFormat simpleDateFormat = this.dateFormat;
            synchronized (simpleDateFormat) {
                this.dateFormat.format(startingDate, buffer, new FieldPosition(0));
            }
            name.append(buffer.toString());
        }
        if (this.converter instanceof XMLConverter) {
            name.append(".xml");
        } else {
            name.append(".txt");
        }
        FileWriter outFile = null;
        outFile = new FileWriter(name.toString(), false);
        System.out.println("Writing logs on " + name);
        return new BufferedWriter(outFile, 8192);
    }

    private void closeOutputFile(BufferedWriter file) throws Exception {
        if (file != null) {
            file.flush();
            file.close();
            file = null;
        }
    }

    public void bytesRead(long bytes) {
    }

    public void bytesWritten(long bytes) {
    }

    public void logsRead(int numOfLogs) {
    }

    public void logsWritten(int numOfLogs) {
    }

    public void errorReceived(String xml) {
        System.err.println("Error parsing the following: [" + xml + "]");
    }

    public void logEntryReceived(ILogEntry logEntry) {
        if (this.number != null) {
            if (this.outF == null || ++this.logsRead > this.number) {
                try {
                    this.closeOutputFile(this.outF);
                }
                catch (Throwable t) {
                    System.err.println("Error closing the output file");
                    t.printStackTrace(System.err);
                }
                try {
                    this.outF = this.getOutputFile(this.destFileName, this.index++, null);
                }
                catch (IOException e) {
                    System.err.println("Error getting a new file for output: " + e.getMessage());
                    e.printStackTrace(System.err);
                }
                this.logsRead = 1;
            }
        } else {
            long logDate = (Long)logEntry.getField(LogField.TIMESTAMP);
            if (this.firstLogDate == -1L || logDate - this.firstLogDate > (long)this.time.intValue()) {
                this.firstLogDate = logDate;
                try {
                    this.closeOutputFile(this.outF);
                }
                catch (Throwable t) {
                    System.err.println("Error closing the output file");
                    t.printStackTrace(System.err);
                }
                try {
                    this.outF = this.getOutputFile(this.destFileName, this.index++, new Date(logDate));
                }
                catch (IOException e) {
                    System.err.println("Error getting a new file for output: " + e.getMessage());
                    e.printStackTrace(System.err);
                }
            }
        }
        try {
            this.outF.write(this.converter.convert(logEntry));
        }
        catch (IOException e) {
            System.err.println("Error writing a log: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }
}

