/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.logging.settings;

import com.cosylab.logging.engine.Filter;
import com.cosylab.logging.engine.log.LogField;
import com.cosylab.logging.engine.log.LogTypeHelper;
import com.cosylab.logging.settings.FilterParameterException;
import com.cosylab.logging.settings.FilterParameterPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FieldClassChooser
extends JComboBox {
    private FilterParameterPanel intEditor = null;
    private FilterParameterPanel doubleEditor = null;
    private FilterParameterPanel stringEditor = null;
    private FilterParameterPanel dateEditor = null;
    private FilterParameterPanel typeEditor = null;
    private FilterParameterPanel currentEditor = null;
    private JPanel mainPanel = null;

    public FieldClassChooser() {
        for (LogField field : LogField.values()) {
            this.addItem(field.getName());
        }
        this.addItemListener(new ChangeListener());
    }

    public FilterParameterPanel getDateEditor() {
        return this.dateEditor;
    }

    public FilterParameterPanel getDoubleEditor() {
        return this.doubleEditor;
    }

    public Filter getFilter() throws FilterParameterException {
        if (this.currentEditor != null) {
            return this.currentEditor.getFilter();
        }
        throw new FilterParameterException("No filter specified");
    }

    public FilterParameterPanel getIntEditor() {
        return this.intEditor;
    }

    public FilterParameterPanel getTypeEditor() {
        return this.typeEditor;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public Class getSelectedClass() {
        return LogField.values()[this.getSelectedIndex()].getType();
    }

    public FilterParameterPanel getStringEditor() {
        return this.stringEditor;
    }

    private void replaceEditor(FilterParameterPanel newEditor) {
        if (this.mainPanel != null) {
            this.mainPanel.removeAll();
            this.currentEditor = newEditor;
            if (newEditor != null) {
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 1;
                c.gridx = 0;
                c.gridy = 0;
                c.weightx = 1.0;
                c.weighty = 1.0;
                newEditor.setFieldIndex(LogField.values()[this.getSelectedIndex()]);
                newEditor.setLethal(false);
                this.mainPanel.add((Component)newEditor, c);
                this.mainPanel.doLayout();
                this.mainPanel.setVisible(false);
                this.mainPanel.setVisible(true);
                this.invalidate();
                this.mainPanel.invalidate();
                this.invalidate();
                this.mainPanel.repaint();
            }
        }
    }

    public void setDateEditor(FilterParameterPanel newDateEditor) {
        this.dateEditor = newDateEditor;
        this.updateEditor();
    }

    public void setDoubleEditor(FilterParameterPanel newDoubleEditor) {
        this.doubleEditor = newDoubleEditor;
        this.updateEditor();
    }

    public void setEditor(Class c) {
        if (c == String.class) {
            this.replaceEditor(this.stringEditor);
        } else if (c == LogTypeHelper.class) {
            this.replaceEditor(this.typeEditor);
        } else if (c == Long.class) {
            this.replaceEditor(this.dateEditor);
        } else if (c == Integer.class) {
            this.replaceEditor(this.intEditor);
        } else {
            JOptionPane.showMessageDialog(null, "Unknown class: " + c.getName(), "Error", 0);
            System.err.println("Unknow class: " + c.getName());
        }
    }

    public void setFilter(Filter f) {
        if (f == null) {
            return;
        }
        this.setSelectedIndex(f.getField().ordinal());
        if (this.currentEditor != null) {
            this.currentEditor.setFilter(f);
        }
    }

    public void setIntEditor(FilterParameterPanel newIntEditor) {
        this.intEditor = newIntEditor;
        this.updateEditor();
    }

    public void setTypeEditor(FilterParameterPanel newTypeEditor) {
        this.typeEditor = newTypeEditor;
    }

    public void setMainPanel(JPanel newMainPanel) {
        this.mainPanel = newMainPanel;
        this.updateEditor();
    }

    public void setStringEditor(FilterParameterPanel newStringEditor) {
        this.stringEditor = newStringEditor;
        this.updateEditor();
    }

    protected void updateEditor() {
        this.setEditor(this.getSelectedClass());
    }

    private class ChangeListener
    implements ItemListener {
        private ChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                FieldClassChooser.this.updateEditor();
            }
        }
    }
}

