/*
 * Decompiled with CFR 0.152.
 */
package jsky.util.gui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jsky.util.Preferences;
import jsky.util.QuickSort;
import jsky.util.Resources;
import jsky.util.gui.BasicWindowMonitor;
import jsky.util.gui.PrintableJTable;
import jsky.util.gui.TableUtil;

public class SortedJTable
extends PrintableJTable
implements MouseListener,
TableModelListener {
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    private static final String SORT_COL_KEY = ".sortCol";
    private static final String SORT_ORDER_KEY = ".sortOrder";
    private TableModel _realModel;
    private int _columnToSort = -1;
    private int _sortType = 1;
    private int[] _mapToSorted;
    private int _numColumns;
    private TableModelListener tableModelListener;
    private static Icon _ascendingIcon = null;
    private static Icon _descendingIcon = null;
    private String _sortColumnPrefsKey;

    public SortedJTable(TableModel model) {
        this();
        this.setModel(model);
    }

    public SortedJTable() {
        this.getTableHeader().addMouseListener(this);
    }

    @Override
    public void setModel(TableModel model) {
        this._realModel = model;
        super.setModel(new ModelWrapper());
        this._numColumns = this.getColumnCount();
        for (int i = 0; i < this._numColumns; ++i) {
            this.setCustomHeaderRenderer(i);
        }
        this.tableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SortedJTable.this.doSort();
                if (e.getColumn() > SortedJTable.this._numColumns || e.getColumn() == -1) {
                    SortedJTable.this._numColumns = SortedJTable.this.getColumnCount();
                    for (int i = 0; i < SortedJTable.this._numColumns; ++i) {
                        SortedJTable.this.setCustomHeaderRenderer(i);
                    }
                }
            }
        };
        this._realModel.removeTableModelListener(this.tableModelListener);
        this._realModel.addTableModelListener(this.tableModelListener);
        this.doSort();
    }

    public int getSortColumn() {
        return this._columnToSort;
    }

    public void setSortColumn(int column) {
        if (column >= this.getColumnCount()) {
            throw new IllegalArgumentException("Column number is out of range.");
        }
        this._columnToSort = column;
        this.sortAndUpdate();
    }

    public int getUnsortedRowIndex(int row) {
        if (this._mapToSorted != null) {
            for (int i = 0; i < this._mapToSorted.length; ++i) {
                if (this._mapToSorted[i] != row) continue;
                return i;
            }
        }
        return row;
    }

    public int getSortedRowIndex(int row) {
        if (this._mapToSorted != null) {
            return this._mapToSorted[row];
        }
        return row;
    }

    public int getSortType() {
        return this._sortType;
    }

    public void setSortType(int type) {
        if (type != 1 && type != -1) {
            throw new IllegalArgumentException("Invalid sort type (must be ASCENDING or DESCENDING).");
        }
        this._sortType = type;
        this.sortAndUpdate();
    }

    public void removeRows(int[] rows) {
        int i;
        if (!(this._realModel instanceof DefaultTableModel)) {
            throw new RuntimeException("removeRows() requires a DefaultTableModel");
        }
        DefaultTableModel model = (DefaultTableModel)this._realModel;
        model.removeTableModelListener(this.tableModelListener);
        if (this._mapToSorted != null) {
            for (i = 0; i < rows.length; ++i) {
                rows[i] = this._mapToSorted[rows[i]];
            }
        }
        QuickSort.sort((int[])rows, (int)0, (int)rows.length);
        for (i = rows.length - 1; i >= 0; --i) {
            model.removeRow(rows[i]);
        }
        this.setModel(model);
    }

    public void addRow(Vector row) {
        if (!(this._realModel instanceof DefaultTableModel)) {
            throw new RuntimeException("addRow() requires a DefaultTableModel");
        }
        DefaultTableModel model = (DefaultTableModel)this._realModel;
        if (row == null) {
            int n = model.getColumnCount();
            row = new Vector<Object>(n);
            for (int i = 0; i < n; ++i) {
                row.add(null);
            }
        }
        model.addRow(row);
        this.setModel(model);
    }

    protected void doSort() {
        if (this._columnToSort < 0) {
            this._mapToSorted = null;
            return;
        }
        int rowCount = this._realModel.getRowCount();
        if (this._mapToSorted == null || this._mapToSorted.length < rowCount) {
            this._mapToSorted = new int[(rowCount / 50 + 1) * 50];
        }
        Object[] a = new Object[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            this._mapToSorted[i] = i;
            a[i] = this._realModel.getValueAt(i, this._columnToSort);
        }
        this.quickSort(a, 0, rowCount - 1);
    }

    protected int compareObjects(Object a, Object b) {
        if (a instanceof Comparable) {
            if (b instanceof Comparable) {
                return ((Comparable)a).compareTo(b) * this._sortType;
            }
            return this._sortType;
        }
        if (b instanceof Comparable) {
            return -1 * this._sortType;
        }
        return 0;
    }

    protected void quickSort(Object[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            Object mid = a[this._mapToSorted[(lo0 + hi0) / 2]];
            while (lo <= hi) {
                while (lo < hi0 && this.compareObjects(a[this._mapToSorted[lo]], mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && this.compareObjects(a[this._mapToSorted[hi]], mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                int tmp = this._mapToSorted[lo];
                this._mapToSorted[lo] = this._mapToSorted[hi];
                this._mapToSorted[hi] = tmp;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent m) {
    }

    @Override
    public void mouseExited(MouseEvent m) {
    }

    @Override
    public void mousePressed(MouseEvent m) {
    }

    @Override
    public void mouseReleased(MouseEvent m) {
    }

    @Override
    public void mouseClicked(MouseEvent m) {
        int targetCol = this.convertColumnIndexToModel(this.getTableHeader().columnAtPoint(m.getPoint()));
        if (targetCol == this._columnToSort) {
            if (this._sortType == 1) {
                this._sortType = -1;
            } else {
                this._columnToSort = -1;
            }
        } else {
            this._columnToSort = targetCol;
            this._sortType = 1;
        }
        this.sortAndUpdate();
    }

    protected void sortAndUpdate() {
        this.getSelectionModel().clearSelection();
        this.doSort();
        this.getTableHeader().repaint();
        if (this._sortColumnPrefsKey != null) {
            this._savePrefs();
        }
    }

    public void rememberSortColumn(String key, int defaultSortCol, int defaultSortOrder) {
        this._sortColumnPrefsKey = key;
        this._columnToSort = defaultSortCol;
        this._sortType = defaultSortOrder;
        if (key != null) {
            this._loadPrefs();
        }
    }

    private void _savePrefs() {
        String sortColumnKey = this._sortColumnPrefsKey + SORT_COL_KEY;
        String sortOrderKey = this._sortColumnPrefsKey + SORT_ORDER_KEY;
        if (this._columnToSort != -1) {
            String sortColStr = String.valueOf(this._columnToSort);
            String sortOrderStr = String.valueOf(this._sortType);
            Preferences.set((String)sortColumnKey, (String)sortColStr);
            Preferences.set((String)sortOrderKey, (String)sortOrderStr);
        } else {
            Preferences.unset((String)sortColumnKey);
            Preferences.unset((String)sortOrderKey);
        }
    }

    private void _loadPrefs() {
        String sortColumnKey = this._sortColumnPrefsKey + SORT_COL_KEY;
        String sortOrderKey = this._sortColumnPrefsKey + SORT_ORDER_KEY;
        String sortColStr = Preferences.get((String)sortColumnKey);
        if (sortColStr != null) {
            this._columnToSort = Integer.parseInt(sortColStr);
            String sortOrderStr = Preferences.get((String)sortOrderKey);
            if (sortOrderStr != null) {
                this._sortType = Integer.parseInt(sortOrderStr);
            }
        }
        this.sortAndUpdate();
    }

    protected void setCustomHeaderRenderer(int i) {
        TableColumn column = this.getColumn(this.getColumnName(i));
        TableCellRenderer rend = TableUtil.getDefaultTableHeaderRenderer(this);
        if (!(rend instanceof CustomHeaderRenderer)) {
            CustomHeaderRenderer newHeader = new CustomHeaderRenderer();
            if (rend instanceof DefaultTableCellRenderer) {
                newHeader.setToolTipText(((DefaultTableCellRenderer)rend).getToolTipText());
            }
            column.setHeaderRenderer(newHeader);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("SortedJTable");
        AbstractTableModel dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 10;
            }

            @Override
            public int getRowCount() {
                return 10;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return row * col;
            }
        };
        SortedJTable table = new SortedJTable(dataModel);
        frame.getContentPane().add((Component)new JScrollPane(table), "Center");
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new BasicWindowMonitor());
    }

    protected class CustomHeaderRenderer
    extends DefaultTableCellRenderer {
        public CustomHeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(4);
            this.setVerticalTextPosition(0);
            if (_ascendingIcon == null) {
                _ascendingIcon = Resources.getIcon((String)"AscendSort.gif");
            }
            if (_descendingIcon == null) {
                _descendingIcon = Resources.getIcon((String)"DescendSort.gif");
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean hasFocus, int row, int col) {
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            this.setText(value == null ? "" : value.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            if (table.convertColumnIndexToModel(col) == SortedJTable.this._columnToSort) {
                this.setIcon(SortedJTable.this._sortType == 1 ? _ascendingIcon : _descendingIcon);
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    protected class ModelWrapper
    implements TableModel {
        protected ModelWrapper() {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            SortedJTable.this._realModel.addTableModelListener(l);
        }

        public Class getColumnClass(int index) {
            return SortedJTable.this._realModel.getColumnClass(index);
        }

        @Override
        public int getColumnCount() {
            return SortedJTable.this._realModel.getColumnCount();
        }

        @Override
        public String getColumnName(int index) {
            return SortedJTable.this._realModel.getColumnName(index);
        }

        @Override
        public int getRowCount() {
            return SortedJTable.this._realModel.getRowCount();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (SortedJTable.this._mapToSorted != null) {
                row = SortedJTable.this._mapToSorted[row];
            }
            return SortedJTable.this._realModel.getValueAt(row, col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (SortedJTable.this._mapToSorted != null) {
                row = SortedJTable.this._mapToSorted[row];
            }
            return SortedJTable.this._realModel.isCellEditable(row, col);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            SortedJTable.this._realModel.removeTableModelListener(l);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (SortedJTable.this._mapToSorted != null) {
                row = SortedJTable.this._mapToSorted[row];
            }
            SortedJTable.this._realModel.setValueAt(value, row, col);
        }
    }
}

