/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResult;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import org.apache.commons.jcs3.jcache.cdi.CDIJCacheHelper;
import org.apache.commons.jcs3.jcache.cdi.CachePutInterceptor;
import org.apache.commons.jcs3.jcache.cdi.CacheRemoveAllInterceptor;
import org.apache.commons.jcs3.jcache.cdi.CacheRemoveInterceptor;
import org.apache.commons.jcs3.jcache.cdi.CacheResultInterceptor;

public class MakeJCacheCDIInterceptorFriendly
implements Extension {
    private static final AtomicInteger id = new AtomicInteger();
    private static final boolean USE_ID = !Boolean.getBoolean("org.apache.commons.jcs3.cdi.skip-id");
    private boolean needHelper = true;

    protected void discoverInterceptorBindings(@Observes BeforeBeanDiscovery beforeBeanDiscoveryEvent, BeanManager bm) {
        bm.createAnnotatedType(CDIJCacheHelper.class);
        for (Class interceptor : Arrays.asList(CachePutInterceptor.class, CacheRemoveInterceptor.class, CacheRemoveAllInterceptor.class, CacheResultInterceptor.class)) {
            beforeBeanDiscoveryEvent.addAnnotatedType(bm.createAnnotatedType(interceptor));
        }
        for (Class interceptor : Arrays.asList(CachePut.class, CacheRemove.class, CacheRemoveAll.class, CacheResult.class)) {
            beforeBeanDiscoveryEvent.addInterceptorBinding(interceptor, new Annotation[0]);
        }
    }

    protected void addHelper(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager bm) {
        if (!this.needHelper) {
            return;
        }
        AnnotatedType annotatedType = bm.createAnnotatedType(CDIJCacheHelper.class);
        InjectionTarget injectionTarget = bm.createInjectionTarget(annotatedType);
        HelperBean bean = new HelperBean((AnnotatedType<CDIJCacheHelper>)annotatedType, (InjectionTarget<CDIJCacheHelper>)injectionTarget, this.findIdSuffix());
        afterBeanDiscovery.addBean((Bean)bean);
    }

    protected void vetoScannedCDIJCacheHelperQualifiers(@Observes ProcessAnnotatedType<CDIJCacheHelper> pat) {
        if (!this.needHelper) {
            pat.veto();
        }
        this.needHelper = false;
    }

    private String findIdSuffix() {
        if (USE_ID) {
            return "lib" + id.incrementAndGet();
        }
        return "default";
    }

    public static class HelperBean
    implements Bean<CDIJCacheHelper>,
    PassivationCapable {
        private final AnnotatedType<CDIJCacheHelper> at;
        private final InjectionTarget<CDIJCacheHelper> it;
        private final HashSet<Annotation> qualifiers;
        private final String id;

        public HelperBean(AnnotatedType<CDIJCacheHelper> annotatedType, InjectionTarget<CDIJCacheHelper> injectionTarget, String id) {
            this.at = annotatedType;
            this.it = injectionTarget;
            this.id = "JCS#CDIHelper#" + id;
            this.qualifiers = new HashSet();
            this.qualifiers.add((Annotation)new AnnotationLiteral<Default>(){
                private static final long serialVersionUID = 3314657767813459983L;
            });
            this.qualifiers.add((Annotation)new AnnotationLiteral<Any>(){
                private static final long serialVersionUID = 7419841275942488170L;
            });
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.it.getInjectionPoints();
        }

        public Class<?> getBeanClass() {
            return this.at.getJavaClass();
        }

        public boolean isNullable() {
            return false;
        }

        public Set<Type> getTypes() {
            return this.at.getTypeClosure();
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }

        public String getName() {
            return null;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return false;
        }

        public CDIJCacheHelper create(CreationalContext<CDIJCacheHelper> context) {
            CDIJCacheHelper produce = (CDIJCacheHelper)this.it.produce(context);
            this.it.inject((Object)produce, context);
            this.it.postConstruct((Object)produce);
            return produce;
        }

        public void destroy(CDIJCacheHelper instance, CreationalContext<CDIJCacheHelper> context) {
            this.it.preDestroy((Object)instance);
            this.it.dispose((Object)instance);
            context.release();
        }

        public String getId() {
            return this.id;
        }
    }
}

