/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.adql.convert;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class ADQLs2DOMParser {
    protected Document doc = null;
    protected Node parent = null;
    protected int indent = -1;
    protected short nsmode = 0;
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final short MODE_ALWAYS_QUALIFIED = 0;
    public static final short MODE_DEFAULT_NS = 1;
    protected static final short MODE_COUNT = 2;

    public ADQLs2DOMParser() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.newDocument();
            this.parent = this.doc;
        }
        catch (ParserConfigurationException pce) {
            throw new InternalError("programmer error: DOM new doc failure");
        }
    }

    public ADQLs2DOMParser(Node parent) {
        this.parent = parent;
        this.doc = parent.getOwnerDocument();
    }

    public abstract Element parseSelect() throws TransformerException;

    public abstract Element parseWhere() throws TransformerException;

    protected abstract Element createADQLElement(String var1);

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public void indent() {
        Element parent = this.doc.getDocumentElement();
        if (parent == null || this.indent < 0) {
            return;
        }
        this.indent(parent, "\n", this.indent);
    }

    public void indent(Element parent, String indent, int incr) {
        Text txt;
        if (!parent.hasChildNodes()) {
            return;
        }
        if (indent == null) {
            indent = "\n";
        }
        String childIndent = ADQLs2DOMParser.addIndentation(indent, incr);
        boolean skipElement = false;
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() == 3) {
                skipElement = true;
                continue;
            }
            if (!skipElement) {
                txt = this.doc.createTextNode(childIndent);
                parent.insertBefore(txt, child);
            }
            if (child.getNodeType() == 1) {
                this.indent((Element)child, childIndent, incr);
            }
            skipElement = false;
        }
        if (!skipElement) {
            txt = this.doc.createTextNode(indent);
            parent.appendChild(txt);
        }
    }

    public static String addIndentation(String base, int spaceCount) {
        StringBuffer sb = new StringBuffer(base);
        for (int i = 0; i < spaceCount; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public void setNSMode(short mode) {
        if (mode >= 2) {
            throw new IllegalArgumentException("Undefined namespace qualification modes (" + mode + ")");
        }
        this.nsmode = mode;
    }

    public short getNSMode(short mode) {
        return this.nsmode;
    }

    protected Element getChildByTag(Element el, String name) {
        for (Node child = el.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !child.getNodeName().equals(name)) continue;
            return (Element)child;
        }
        return null;
    }

    protected boolean matchesXSIType(Element el, String qtype) {
        String type = el.getAttributeNS(XSI_NS, "xsi:type");
        return type != null && type.length() > 0 && type.equals(qtype);
    }

    protected Element renameADQLElement(Element el, String newname, Node parent) {
        Element out = this.createADQLElement(newname);
        Attr attr = null;
        NamedNodeMap attrs = el.getAttributes();
        while (attrs.getLength() > 0 && (attr = (Attr)attrs.item(0)) != null) {
            el.removeAttributeNode(attr);
            out.setAttributeNode(attr);
        }
        Node node = el.getFirstChild();
        while (node != null) {
            el.removeChild(node);
            out.appendChild(node);
            node = el.getFirstChild();
        }
        if (parent != null) {
            parent.insertBefore(out, el);
            parent.removeChild(el);
        }
        return out;
    }
}

