/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.xpath.XPath;
import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.FieldActivator;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.XSTypeDefinition;

public class Selector {
    protected final XPath fXPath;
    protected final IdentityConstraint fIdentityConstraint;
    protected IdentityConstraint fIDConstraint;

    public Selector(XPath xpath, IdentityConstraint identityConstraint) {
        this.fXPath = xpath;
        this.fIdentityConstraint = identityConstraint;
    }

    public org.apache.xerces.impl.xpath.XPath getXPath() {
        return this.fXPath;
    }

    public IdentityConstraint getIDConstraint() {
        return this.fIdentityConstraint;
    }

    public XPathMatcher createMatcher(FieldActivator activator, int initialDepth) {
        return new Matcher(this.fXPath, activator, initialDepth);
    }

    public String toString() {
        return this.fXPath.toString();
    }

    public static class XPath
    extends org.apache.xerces.impl.xpath.XPath {
        public XPath(String xpath, SymbolTable symbolTable, NamespaceContext context) throws XPathException {
            super(XPath.normalize(xpath), symbolTable, context);
            for (int i = 0; i < this.fLocationPaths.length; ++i) {
                XPath.Axis axis = this.fLocationPaths[i].steps[this.fLocationPaths[i].steps.length - 1].axis;
                if (axis.type != 2) continue;
                throw new XPathException("c-selector-xpath");
            }
        }

        private static String normalize(String xpath) {
            StringBuffer modifiedXPath = new StringBuffer(xpath.length() + 5);
            int unionIndex = -1;
            while (true) {
                if (!XMLChar.trim(xpath).startsWith("/") && !XMLChar.trim(xpath).startsWith(".")) {
                    modifiedXPath.append("./");
                }
                if ((unionIndex = xpath.indexOf(124)) == -1) break;
                modifiedXPath.append(xpath.substring(0, unionIndex + 1));
                xpath = xpath.substring(unionIndex + 1, xpath.length());
            }
            modifiedXPath.append(xpath);
            return modifiedXPath.toString();
        }
    }

    public class Matcher
    extends XPathMatcher {
        protected final FieldActivator fFieldActivator;
        protected final int fInitialDepth;
        protected int fElementDepth;
        protected int fMatchedDepth;

        public Matcher(XPath xpath, FieldActivator activator, int initialDepth) {
            super(xpath);
            this.fFieldActivator = activator;
            this.fInitialDepth = initialDepth;
        }

        @Override
        public void startDocumentFragment() {
            super.startDocumentFragment();
            this.fElementDepth = 0;
            this.fMatchedDepth = -1;
        }

        @Override
        public void startElement(QName element, XMLAttributes attributes) {
            super.startElement(element, attributes);
            ++this.fElementDepth;
            if (this.isMatched()) {
                this.fMatchedDepth = this.fElementDepth;
                this.fFieldActivator.startValueScopeFor(Selector.this.fIdentityConstraint, this.fInitialDepth);
                int count = Selector.this.fIdentityConstraint.getFieldCount();
                for (int i = 0; i < count; ++i) {
                    Field field = Selector.this.fIdentityConstraint.getFieldAt(i);
                    XPathMatcher matcher = this.fFieldActivator.activateField(field, this.fInitialDepth);
                    matcher.startElement(element, attributes);
                }
            }
        }

        @Override
        public void endElement(QName element, XSTypeDefinition type, boolean nillable, Object actualValue, short valueType, ShortList itemValueType) {
            super.endElement(element, type, nillable, actualValue, valueType, itemValueType);
            if (this.fElementDepth-- == this.fMatchedDepth) {
                this.fMatchedDepth = -1;
                this.fFieldActivator.endValueScopeFor(Selector.this.fIdentityConstraint, this.fInitialDepth);
            }
        }

        public IdentityConstraint getIdentityConstraint() {
            return Selector.this.fIdentityConstraint;
        }

        public int getInitialDepth() {
            return this.fInitialDepth;
        }
    }
}

