/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.IOException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import uk.ac.starlink.fits.ColFitsTableSerializer;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.votable.VOTableFitsTableWriter;

public class ColFitsPlusTableWriter
extends VOTableFitsTableWriter {
    public ColFitsPlusTableWriter() {
        super("colfits-plus");
    }

    public boolean looksLikeFile(String location) {
        return location.endsWith(".colfits");
    }

    protected void customisePrimaryHeader(Header hdr) throws HeaderCardException {
        hdr.addValue("COLFITS", true, "Table extension stored column-oriented");
        hdr.addValue("VOTMETA", true, "Table metadata in VOTable format");
    }

    protected boolean isMagic(int icard, String key, String value) {
        switch (icard) {
            case 4: {
                return "COLFITS".equals(key) && "T".equals(value);
            }
            case 5: {
                return "VOTMETA".equals(key);
            }
        }
        return super.isMagic(icard, key, value);
    }

    protected FitsTableSerializer createSerializer(StarTable table) throws IOException {
        return new ColFitsTableSerializer(table);
    }
}

