/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.web.ClientAuthorizer;

public class ClientAuthorizers {
    public static final ClientAuthorizer FALSE;
    public static final ClientAuthorizer TRUE;
    private static ClientAuthorizer swingAuth_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ClientAuthorizers() {
    }

    public static ClientAuthorizer createFixedClientAuthorizer(boolean policy) {
        if (policy) {
            return new ClientAuthorizer(){

                public void authorize(HttpServer.Request request, Map securityMap) {
                }
            };
        }
        return new ClientAuthorizer(){

            public void authorize(HttpServer.Request request, Map securityMap) throws SampException {
                throw new SampException("All registration requests unconditionally denied");
            }
        };
    }

    public static ClientAuthorizer createLoggingClientAuthorizer(final ClientAuthorizer auth, final Level acceptLevel, final Level refuseLevel) {
        return new ClientAuthorizer(){

            public synchronized void authorize(HttpServer.Request request, Map securityMap) throws SampException {
                try {
                    auth.authorize(request, securityMap);
                    this.log(true, securityMap, null);
                }
                catch (SampException e) {
                    this.log(false, securityMap, e);
                    throw e;
                }
            }

            private void log(boolean accept, Map securityMap, SampException err) {
                String clTxt;
                String string = clTxt = securityMap.containsKey("samp.name") ? securityMap.get("samp.name").toString() : securityMap.toString();
                if (accept) {
                    logger_.log(acceptLevel, "Accepted registration for client " + clTxt);
                } else {
                    logger_.log(refuseLevel, "Rejected registration for client " + clTxt + "(" + err.getMessage() + ")");
                }
            }
        };
    }

    public static String getAppName(Map securityMap) throws SampException {
        String nameKey = "samp.name";
        if (!$assertionsDisabled && !"samp.name".equals(nameKey)) {
            throw new AssertionError();
        }
        Object appNameObj = securityMap.get(nameKey);
        if (appNameObj instanceof String) {
            return (String)appNameObj;
        }
        if (appNameObj == null) {
            throw new SampException("No " + nameKey + " entry in securityInfo map");
        }
        throw new SampException("Wrong data type (not string) for " + nameKey + " entry in securityInfo map");
    }

    static {
        $assertionsDisabled = !ClientAuthorizers.class.desiredAssertionStatus();
        FALSE = ClientAuthorizers.createLoggingClientAuthorizer(ClientAuthorizers.createFixedClientAuthorizer(false), Level.INFO, Level.INFO);
        TRUE = ClientAuthorizers.createLoggingClientAuthorizer(ClientAuthorizers.createFixedClientAuthorizer(true), Level.WARNING, Level.WARNING);
        logger_ = Logger.getLogger(ClientAuthorizers.class.getName());
    }
}

