/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.convert;

import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.convert.ValueConverter;
import uk.ac.starlink.ttools.func.Coords;

public class SexagesimalToDegrees
implements ValueConverter {
    private final boolean hours_;
    private final ValueInfo inInfo_;
    private final DefaultValueInfo outInfo_;

    public SexagesimalToDegrees(ValueInfo sexInfo, boolean hours) {
        if (!String.class.isAssignableFrom(sexInfo.getContentClass())) {
            throw new IllegalArgumentException("Input data must be String, not " + sexInfo.getContentClass().getName());
        }
        this.inInfo_ = sexInfo;
        this.hours_ = hours;
        this.outInfo_ = new DefaultValueInfo(sexInfo);
        this.outInfo_.setContentClass(Double.class);
        this.outInfo_.setUnitString("degrees");
        this.outInfo_.setNullable(true);
    }

    public ValueInfo getInputInfo() {
        return this.inInfo_;
    }

    public ValueInfo getOutputInfo() {
        return this.outInfo_;
    }

    public Object convert(Object in) {
        if (in instanceof String) {
            String sex = ((String)in).trim();
            if (sex.length() > 0) {
                double rad = this.hours_ ? Coords.hmsToRadians(sex) : Coords.dmsToRadians(sex);
                return new Double(Coords.radiansToDegrees(rad));
            }
            return null;
        }
        return null;
    }

    public Object unconvert(Object out) {
        if (out instanceof Number) {
            double deg = ((Number)out).doubleValue();
            if (Double.isNaN(deg) || Double.isInfinite(deg)) {
                return null;
            }
            double rad = Math.toRadians(deg);
            return this.hours_ ? Coords.radiansToHms(rad, 3) : Coords.radiansToDms(rad, 2);
        }
        return null;
    }

    public String toString() {
        return this.hours_ ? "HMS->degrees" : "DMS->degrees";
    }
}

