/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.filter;

import java.io.IOException;
import java.util.Iterator;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.filter.ArgException;
import uk.ac.starlink.ttools.filter.BasicFilter;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.filter.ReplaceValueTable;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;

public class BadValueFilter
extends BasicFilter {
    public BadValueFilter() {
        super("badval", "<bad-val> <colid-list>");
    }

    protected String[] getDescriptionLines() {
        return new String[]{"<p>For each column specified in <code>&lt;colid-list&gt;</code>", "any occurrence of the value <code>&lt;bad-val&gt;</code>", "is replaced by a blank entry.", "</p>", BadValueFilter.explainSyntax(new String[]{"colid-list"})};
    }

    public ProcessingStep createStep(Iterator argIt) throws ArgException {
        String badStr = null;
        String colIdList = null;
        while (argIt.hasNext()) {
            String arg = (String)argIt.next();
            if (badStr == null) {
                badStr = arg;
                argIt.remove();
                continue;
            }
            if (colIdList != null) break;
            colIdList = arg;
            argIt.remove();
        }
        if (badStr != null && colIdList != null) {
            final String fBadStr = badStr;
            final String fColIdList = colIdList;
            return new ProcessingStep(){

                public StarTable wrap(StarTable base) throws IOException {
                    return new ReplaceValueTable(base, new ColumnIdentifier(base).getColumnFlags(fColIdList), fBadStr, null);
                }
            };
        }
        throw new ArgException("Bad " + this.getName() + " specification");
    }
}

