/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.lint;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import uk.ac.starlink.ttools.lint.AttributeChecker;
import uk.ac.starlink.ttools.lint.ElementHandler;
import uk.ac.starlink.ttools.lint.HandlerStack;
import uk.ac.starlink.ttools.lint.LintContext;

public class LintContentHandler
implements ContentHandler,
ErrorHandler {
    private final LintContext context_;
    private final HandlerStack stack_;
    private static final Pattern NS_PAT = LintContentHandler.getNamespaceNamePattern();
    private static final Map EMPTY_MAP = Collections.unmodifiableMap(new HashMap());

    LintContentHandler(LintContext context) {
        this.context_ = context;
        this.stack_ = new HandlerStack();
    }

    public void setDocumentLocator(Locator locator) {
        this.context_.setLocator(locator);
    }

    public void startDocument() {
    }

    public void endDocument() {
        this.context_.reportUncheckedRefs();
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.context_.getNamespaceMap().put(prefix, uri);
    }

    public void endPrefixMapping(String prefix) {
        this.context_.getNamespaceMap().remove(prefix);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        int i;
        ElementHandler handler = this.context_.createHandler(localName);
        this.stack_.push(handler);
        handler.setAncestry(this.stack_.getAncestry());
        int natt = atts.getLength();
        if (natt > 0) {
            HashMap<String, String> attMap = new HashMap<String, String>();
            for (i = 0; i < natt; ++i) {
                attMap.put(atts.getQName(i), atts.getValue(i));
            }
            handler.setAttributes(attMap);
        } else {
            handler.setAttributes(EMPTY_MAP);
        }
        Map attCheckers = this.context_.getAttributeCheckers(localName);
        for (i = 0; i < natt; ++i) {
            AttributeChecker checker = (AttributeChecker)attCheckers.get(atts.getQName(i));
            if (checker == null) continue;
            checker.check(atts.getValue(i), handler);
        }
        handler.startElement();
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        ElementHandler handler = this.stack_.top();
        handler.endElement();
        handler.setAncestry(null);
        this.stack_.pop();
    }

    public void characters(char[] ch, int start, int length) {
        this.stack_.top().characters(ch, start, length);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
        this.context_.info("Ignoring processing instruction <?" + target + " " + data + "?>");
    }

    public void skippedEntity(String name) {
        this.context_.info("Skipping entity " + name);
    }

    public void warning(SAXParseException e) {
        this.context_.message("WARN", null, e);
    }

    public void error(SAXParseException e) {
        if (!this.isNamespaceError(e)) {
            this.context_.message("ERROR", null, e);
        }
    }

    public void fatalError(SAXParseException e) {
        this.context_.message("FATAL", null, e);
    }

    private boolean isNamespaceError(SAXParseException e) {
        String msg = e.getMessage();
        if (msg != null) {
            if (msg.indexOf("xmlns") >= 0) {
                return true;
            }
            Matcher matcher = NS_PAT.matcher(msg);
            if (matcher.lookingAt()) {
                String prefix = matcher.group(1);
                String localName = matcher.group(2);
                if (prefix.toLowerCase().startsWith("xml")) {
                    return true;
                }
                if (this.context_.getNamespaceMap().containsKey(prefix)) {
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private static Pattern getNamespaceNamePattern() {
        String charPat = "\\p{Lu}\\p{Ll}_";
        String startCharPat = charPat + "0-9\\-\\.";
        String pats = ".*?([" + startCharPat + "]" + "[" + charPat + "]*" + "):(" + "[" + charPat + "]+" + ")";
        return Pattern.compile(pats);
    }
}

