/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;

public class ClientRegWatcher
implements CallableClient {
    private final HubConnection connection_;
    private final Map clientMap_;
    private final Map responseMap_;
    private static final String REG_MTYPE = "samp.hub.event.register";
    private static final String UNREG_MTYPE = "samp.hub.event.unregister";
    private static final String METADATA_MTYPE = "samp.hub.event.metadata";

    public ClientRegWatcher(HubConnection connection) {
        this.connection_ = connection;
        this.clientMap_ = new HashMap();
        this.responseMap_ = new HashMap();
    }

    public Subscriptions getSubscriptions() {
        Subscriptions subs = new Subscriptions();
        subs.put((Object)REG_MTYPE, new HashMap());
        subs.put((Object)UNREG_MTYPE, new HashMap());
        subs.put((Object)METADATA_MTYPE, new HashMap());
        return subs;
    }

    public synchronized String waitForIdFromName(String name, long waitMillis) {
        String id;
        long endTime;
        long l = endTime = waitMillis >= 0L ? System.currentTimeMillis() + waitMillis : Long.MAX_VALUE;
        while ((id = this.getIdFromName(name)) == null && endTime - System.currentTimeMillis() > 0L) {
            try {
                this.wait(endTime - System.currentTimeMillis());
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return id;
    }

    public synchronized String getIdFromName(String name) {
        Iterator it = this.clientMap_.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String id = (String)entry.getKey();
            Map meta = (Map)entry.getValue();
            if (meta == null) continue;
            String clientName = (String)meta.get("samp.name");
            if (!name.equalsIgnoreCase(name)) continue;
            return id;
        }
        return null;
    }

    public synchronized Response waitForResponse(String msgTag) {
        while (!this.responseMap_.containsKey(msgTag)) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return (Response)this.responseMap_.get(msgTag);
    }

    public void receiveCall(String senderId, String msgId, Message msg) throws SampException {
        this.receiveNotification(senderId, msg);
        this.connection_.reply(msgId, (Map)Response.createSuccessResponse(new HashMap()));
    }

    public synchronized void receiveNotification(String senderId, Message msg) {
        String mtype = msg.getMType();
        if (REG_MTYPE.equals(mtype)) {
            String id = (String)msg.getParam("id");
            if (!this.clientMap_.containsKey(id)) {
                this.clientMap_.put(id, null);
                this.clientMap_.notifyAll();
            }
        } else if (UNREG_MTYPE.equals(mtype)) {
            this.clientMap_.remove(msg.getParam("id"));
            this.clientMap_.notifyAll();
        } else if (METADATA_MTYPE.equals(mtype)) {
            this.clientMap_.put(msg.getParam("id"), msg.getParam("metadata"));
            this.clientMap_.notifyAll();
        } else {
            throw new UnsupportedOperationException("MType " + mtype + "??");
        }
    }

    public synchronized void receiveResponse(String responderId, String msgTag, Response response) {
        this.responseMap_.put(msgTag, response);
        this.notifyAll();
    }
}

