/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.BitSet;
import java.util.Iterator;
import javax.swing.JComponent;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot.BarStyle;
import uk.ac.starlink.ttools.plot.BinnedData;
import uk.ac.starlink.ttools.plot.DataBounds;
import uk.ac.starlink.ttools.plot.HistogramPlotState;
import uk.ac.starlink.ttools.plot.MapBinnedData;
import uk.ac.starlink.ttools.plot.NormalisedBinnedData;
import uk.ac.starlink.ttools.plot.PlotData;
import uk.ac.starlink.ttools.plot.PlotEvent;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.PlotSurface;
import uk.ac.starlink.ttools.plot.PointSequence;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.SurfacePlot;

public class Histogram
extends SurfacePlot {
    private BinnedData binned_;
    private PlotData lastData_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Histogram(PlotSurface surface) {
        this.add(new HistogramDataPanel());
        this.setSurface(surface);
    }

    public void setState(PlotState state) {
        super.setState(state);
        PlotData data = state.getPlotData();
        if (data != this.lastData_) {
            this.binned_ = null;
            this.lastData_ = data;
        }
    }

    public BinnedData getBinnedData() {
        if (this.binned_ == null) {
            this.binned_ = this.binData((HistogramPlotState)this.getState());
        }
        return this.binned_;
    }

    private void drawData(Graphics g) {
        HistogramPlotState state = (HistogramPlotState)this.getState();
        PlotData data = state.getPlotData();
        BinnedData binnedData = this.getBinnedData();
        PlotSurface surface = this.getSurface();
        if (data == null || binnedData == null || state == null || surface == null || !state.getValid()) {
            return;
        }
        g = g.create();
        g.setClip(g.getClip().getBounds().createIntersection(this.getSurface().getClip().getBounds()));
        boolean xflip = state.getFlipFlags()[0];
        boolean cumulative = state.getCumulative();
        double dylo = state.getLogFlags()[1] ? Double.MIN_VALUE : 0.0;
        int nset = data.getSetCount();
        int iylo = surface.dataToGraphics((double)1.0, (double)dylo, (boolean)false).y;
        for (int iset = 0; iset < nset; ++iset) {
            BarStyle style = (BarStyle)data.getSetStyle(iset);
            int lastIxLead = xflip ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            int lastIyhi = 0;
            double total = 0.0;
            Iterator it = binnedData.getBinIterator(cumulative);
            while (it.hasNext()) {
                BinnedData.Bin bin = (BinnedData.Bin)it.next();
                double sum = bin.getWeightedCount(iset);
                double tsum = cumulative ? total + sum : sum;
                total += sum;
                if (tsum <= 0.0) continue;
                double dxlo = bin.getLowBound();
                double dxhi = bin.getHighBound();
                double dxmid = dxlo + 0.5 * dxhi;
                int ixlo = surface.dataToGraphics((double)(xflip ? dxhi : dxlo), (double)dylo, (boolean)false).x;
                int ixhi = surface.dataToGraphics((double)(xflip ? dxlo : dxhi), (double)dylo, (boolean)false).x;
                int iyhi = surface.dataToGraphics((double)dxmid, (double)tsum, (boolean)false).y;
                if (lastIxLead != (xflip ? ixhi : ixlo)) {
                    style.drawEdge(g, lastIxLead, lastIyhi, iylo, iset, nset);
                    lastIyhi = iylo;
                }
                style.drawEdge(g, xflip ? ixhi : ixlo, lastIyhi, iyhi, iset, nset);
                lastIxLead = xflip ? ixlo : ixhi;
                lastIyhi = iyhi;
                style.drawBar(g, ixlo, ixhi, iyhi, iylo, iset, nset);
            }
            style.drawEdge(g, lastIxLead, lastIyhi, iylo, iset, nset);
        }
        this.firePlotChangedLater(new PlotEvent(this, state, -1, -1, -1));
    }

    public DataBounds calculateBounds(PlotData data, PlotState state) {
        DataBounds plotBounds = super.calculateBounds(data, state);
        int np = plotBounds.getPointCount();
        int[] npoints = plotBounds.getPointCounts();
        Range xRange = plotBounds.getRanges()[0];
        double[] xBounds = xRange.getFiniteBounds(state.getLogFlags()[0]);
        return new DataBounds(new Range[]{xRange}, np, npoints);
    }

    private double[] getSurfaceBounds() {
        PlotSurface surface = this.getSurface();
        Rectangle container = surface.getClip().getBounds();
        double[] lopt = surface.graphicsToData(container.x, container.y + container.height, false);
        double[] hipt = surface.graphicsToData(container.x + container.width, container.y, false);
        double[] bounds = new double[]{lopt[0], lopt[1], hipt[0], hipt[1]};
        if (this.getState().getFlipFlags()[0]) {
            if (!$assertionsDisabled && !(bounds[2] <= bounds[0])) {
                throw new AssertionError();
            }
            bounds = new double[]{bounds[2], bounds[1], bounds[0], bounds[3]};
        }
        return bounds;
    }

    public BitSet getVisiblePoints() {
        BinnedData binnedData = this.getBinnedData();
        if (binnedData == null) {
            return new BitSet();
        }
        double[] bounds = this.getSurfaceBounds();
        double xbot = bounds[0];
        double xtop = bounds[2];
        Iterator it = binnedData.getBinIterator(false);
        while (it.hasNext()) {
            BinnedData.Bin bin = (BinnedData.Bin)it.next();
            if (bin.getLowBound() < xbot) {
                xbot = Math.max(xbot, bin.getHighBound());
            }
            if (!(bin.getHighBound() > xtop)) continue;
            xtop = Math.min(xtop, bin.getLowBound());
        }
        PlotData data = this.getState().getPlotData();
        int nset = data.getSetCount();
        BitSet mask = new BitSet();
        PointSequence pseq = data.getPointSequence();
        int ip = 0;
        while (pseq.next()) {
            double[] coords = pseq.getPoint();
            double x = coords[0];
            if (!Double.isNaN(x) && !Double.isInfinite(x) && x >= xbot && x <= xtop) {
                for (int is = 0; is < nset; ++is) {
                    if (!pseq.isIncluded(is)) continue;
                    mask.set(ip);
                    break;
                }
            }
            ++ip;
        }
        pseq.close();
        return mask;
    }

    private BinnedData binData(HistogramPlotState state) {
        PlotData data = state.getPlotData();
        int nset = data.getSetCount();
        BinnedData binned = this.createBinnedData(nset);
        if (state.getNormalised()) {
            binned = new NormalisedBinnedData(binned);
        }
        boolean[] setFlags = new boolean[nset];
        PointSequence pseq = data.getPointSequence();
        int ip = 0;
        while (pseq.next()) {
            double[] coords = pseq.getPoint();
            double x = coords[0];
            double w = coords[1];
            if (!(Double.isNaN(x) || Double.isInfinite(x) || Double.isNaN(w) || Double.isInfinite(w))) {
                for (int is = 0; is < nset; ++is) {
                    setFlags[is] = pseq.isIncluded(is);
                }
                binned.submitDatum(x, w, setFlags);
            }
            ++ip;
        }
        return ip > 0 ? binned : null;
    }

    private BinnedData createBinnedData(int nset) {
        HistogramPlotState state = (HistogramPlotState)this.getState();
        MapBinnedData.BinMapper mapper = MapBinnedData.createBinMapper(state.getLogFlags()[0], state.getBinWidth(), state.getBinBase());
        return new MapBinnedData(nset, mapper);
    }

    public static ValueInfo getYInfo(boolean isWeighted, boolean isNormalised) {
        boolean isInt;
        String descrip;
        String name;
        if (isWeighted) {
            if (isNormalised) {
                name = "Normalised weighted count";
                descrip = "Normalised weighted sum of values";
            } else {
                name = "Weighted count";
                descrip = "Weighted sum of values";
            }
        } else if (isNormalised) {
            name = "Normalised count";
            descrip = "Normalised sum of values";
        } else {
            name = "Count";
            descrip = "Number of values";
        }
        boolean bl = isInt = !isWeighted && !isNormalised;
        Class clazz = isInt ? Integer.class : Double.class;
        return new DefaultValueInfo(name, clazz, descrip + " in bin");
    }

    static {
        $assertionsDisabled = !Histogram.class.desiredAssertionStatus();
    }

    private class HistogramDataPanel
    extends JComponent {
        HistogramDataPanel() {
            this.setOpaque(false);
        }

        protected void paintComponent(Graphics g) {
            if (this.isOpaque()) {
                Color color = g.getColor();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(color);
            }
            Histogram.this.drawData(g);
        }
    }
}

