/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.ErrorModeSelection;
import uk.ac.starlink.ttools.plot.MarkStyle;
import uk.ac.starlink.ttools.plot.Style;

public class Legend
extends JComponent {
    private LabelledStyle[] labelledStyles_;
    private ErrorModeSelection[] errorModeSelections_;
    private int iconWidth_;
    private int lineHeight_;
    private int prefWidth_;
    private int prefHeight_;
    private static final int IL_PAD = 8;

    public Legend() {
        this.setOpaque(false);
        this.labelledStyles_ = new LabelledStyle[0];
        this.errorModeSelections_ = new ErrorModeSelection[0];
    }

    public void setErrorModeSelections(ErrorModeSelection[] errorSelections) {
        this.errorModeSelections_ = errorSelections;
    }

    public void setStyles(Style[] styles, String[] labels) {
        if (labels.length != styles.length) {
            throw new IllegalArgumentException();
        }
        ArrayList<LabelledStyle> lsList = new ArrayList<LabelledStyle>();
        for (int i = 0; i < styles.length; ++i) {
            Style style = styles[i];
            String label = labels[i];
            if (label == null || label.trim().length() <= 0) continue;
            lsList.add(new LabelledStyle(style, label));
        }
        this.setStyles(lsList.toArray(new LabelledStyle[0]));
    }

    private void setStyles(LabelledStyle[] labelledStyles) {
        this.labelledStyles_ = (LabelledStyle[])labelledStyles.clone();
        int nstyle = labelledStyles.length;
        int ixmax = 0;
        int iymax = 0;
        int sxmax = 0;
        int height = 0;
        int width = 0;
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(font);
        this.lineHeight_ = (int)(1.2 * (double)Math.max(fm.getHeight(), iymax));
        ErrorMode[] errorModes = this.getErrorModes();
        for (int is = 0; is < nstyle; ++is) {
            LabelledStyle ls = labelledStyles[is];
            Icon icon = this.getIcon(ls.getStyle(), errorModes);
            ixmax = Math.max(ixmax, icon.getIconWidth());
            iymax = Math.max(iymax, icon.getIconHeight());
            sxmax = Math.max(sxmax, fm.stringWidth(ls.getLabel()) + 1);
            height += this.lineHeight_;
        }
        this.iconWidth_ = ixmax;
        width = this.iconWidth_ + 8 + sxmax;
        Insets insets = this.getInsets();
        int xpad = insets.left + insets.right;
        int ypad = insets.top + insets.bottom;
        this.prefWidth_ = Math.max(width + insets.left + insets.right, this.prefWidth_);
        this.prefHeight_ = height + insets.top + insets.bottom;
        this.revalidate();
        this.repaint();
    }

    public void resetWidth() {
        this.prefWidth_ = 0;
        this.setStyles(this.labelledStyles_);
    }

    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            Color col = g.getColor();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(col);
        }
        int nstyle = this.labelledStyles_.length;
        Insets insets = this.getInsets();
        FontMetrics fm = g.getFontMetrics();
        ErrorMode[] errorModes = this.getErrorModes();
        int xoff = insets.left;
        int ys = this.lineHeight_ / 2 + fm.getHeight() / 2;
        int xs = xoff + this.iconWidth_ + 8;
        for (int is = 0; is < nstyle; ++is) {
            LabelledStyle ls = this.labelledStyles_[is];
            int yoff = insets.top + this.lineHeight_ * is;
            Icon icon = this.getIcon(ls.getStyle(), errorModes);
            int yi = yoff + (this.lineHeight_ - icon.getIconHeight()) / 2;
            int xi = xoff + (this.iconWidth_ - icon.getIconWidth()) / 2;
            icon.paintIcon(this, g, xi, yi);
            g.drawString(ls.getLabel(), xs, ys + yoff);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.prefWidth_, this.prefHeight_);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, this.prefHeight_);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private Icon getIcon(Style style, ErrorMode[] errorModes) {
        return style instanceof MarkStyle ? ((MarkStyle)style).getLegendIcon(errorModes) : style.getLegendIcon();
    }

    private ErrorMode[] getErrorModes() {
        int nerr = this.errorModeSelections_.length;
        ErrorMode[] modes = new ErrorMode[nerr];
        for (int ierr = 0; ierr < nerr; ++ierr) {
            modes[ierr] = this.errorModeSelections_[ierr].getErrorMode();
        }
        return modes;
    }

    private static class LabelledStyle {
        private final Style style_;
        private final String label_;

        LabelledStyle(Style style, String label) {
            this.style_ = style;
            this.label_ = label;
        }

        Style getStyle() {
            return this.style_;
        }

        String getLabel() {
            return this.label_;
        }
    }
}

