/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.server;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.swing.JComponent;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.StarTableWriter;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.MultiParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.plot.GraphicExporter;
import uk.ac.starlink.ttools.plottask.PaintModeParameter;
import uk.ac.starlink.ttools.plottask.Painter;
import uk.ac.starlink.ttools.task.LineTableEnvironment;
import uk.ac.starlink.ttools.task.OutputFormatParameter;
import uk.ac.starlink.ttools.task.OutputModeParameter;
import uk.ac.starlink.ttools.task.OutputTableParameter;
import uk.ac.starlink.ttools.task.TableEnvironment;

public class ServletEnvironment
implements TableEnvironment {
    private final ServletRequest request_;
    private final ServletResponse response_;
    private final Map paramMap_;
    private final PrintStream outStream_;
    private final StarTableFactory tableFactory_;
    private final StarTableOutput tableOutput_;
    private final JDBCAuthenticator jdbcAuth_;
    private boolean strictVot_;
    private boolean debug_;

    public ServletEnvironment(ServletRequest request, ServletResponse response, StarTableFactory tableFactory, StarTableOutput tableOutput, JDBCAuthenticator jdbcAuth) throws IOException {
        this.request_ = request;
        this.response_ = response;
        this.tableFactory_ = tableFactory;
        this.tableOutput_ = tableOutput;
        this.jdbcAuth_ = jdbcAuth;
        this.paramMap_ = new HashMap();
        Iterator it = request.getParameterMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.paramMap_.put(LineTableEnvironment.normaliseName((String)entry.getKey()), entry.getValue());
        }
        this.outStream_ = new PrintStream((OutputStream)response.getOutputStream());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void acquireValue(Parameter param) throws TaskException {
        boolean isDefault;
        String pname = LineTableEnvironment.normaliseName(param.getName());
        boolean bl = isDefault = !this.paramMap_.containsKey(pname);
        if (isDefault && param instanceof OutputTableParameter) {
            StarTableWriter writer;
            OutputTableParameter outParam = (OutputTableParameter)param;
            OutputFormatParameter formatParam = outParam.getFormatParameter();
            formatParam.setDefault("votable");
            String format = formatParam.stringValue(this);
            try {
                writer = this.getTableOutput().getHandler(format);
            }
            catch (TableFormatException e) {
                throw new ParameterValueException(param, "Unknown table output format " + format, (Throwable)e);
            }
            outParam.setValueFromConsumer(new ServletTableConsumer(writer));
            return;
        }
        if (isDefault && param instanceof OutputModeParameter) {
            StarTableWriter writer;
            OutputModeParameter outParam = (OutputModeParameter)param;
            OutputFormatParameter formatParam = new OutputFormatParameter("ofmt");
            formatParam.setDefault("votable");
            String format = formatParam.stringValue(this);
            try {
                writer = this.getTableOutput().getHandler(format);
            }
            catch (TableFormatException e) {
                throw new ParameterValueException(param, "Unknown table output format " + format, (Throwable)e);
            }
            outParam.setValueFromConsumer(new ServletTableConsumer(writer));
            return;
        }
        if (isDefault && param instanceof PaintModeParameter) {
            PaintModeParameter pmParam = (PaintModeParameter)param;
            ChoiceParameter formatParam = pmParam.getFormatParameter();
            formatParam.setDefault("png");
            GraphicExporter exporter = (GraphicExporter)formatParam.objectValue((Environment)this);
            pmParam.setValueFromPainter(new ServletPainter(exporter));
            return;
        } else {
            String stringVal;
            String[] valueArray = (String[])this.paramMap_.get(pname);
            if (isDefault) {
                stringVal = param.getDefault();
            } else if (param instanceof MultiParameter) {
                char sep = ((MultiParameter)param).getValueSeparator();
                StringBuffer sbuf = new StringBuffer();
                for (int iv = 0; iv < valueArray.length; ++iv) {
                    if (iv > 0) {
                        sbuf.append(sep);
                    }
                    sbuf.append(valueArray[iv]);
                }
                stringVal = sbuf.toString();
            } else if (valueArray.length > 1) {
                int nv = 0;
                String val = null;
                for (int iv = 0; iv < valueArray.length; ++iv) {
                    String value = valueArray[iv];
                    if (value == null || value.length() <= 0) continue;
                    ++nv;
                    val = value;
                }
                if (nv == 0) {
                    stringVal = null;
                } else {
                    if (nv != true) throw new ParameterValueException(param, "Multiple values supplied for single-valued  parameter");
                    stringVal = val;
                }
            } else {
                stringVal = valueArray[0];
            }
            if (stringVal == null || stringVal.length() == 0) {
                if (!param.isNullPermitted()) throw new ParameterValueException(param, "null value not allowed");
                param.setValueFromString((Environment)this, null);
                return;
            } else {
                param.setValueFromString((Environment)this, stringVal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearValue(Parameter param) {
        Map map = this.paramMap_;
        synchronized (map) {
            this.paramMap_.remove(LineTableEnvironment.normaliseName(param.getName()));
        }
    }

    public String[] getNames() {
        return this.paramMap_.keySet().toArray(new String[0]);
    }

    public PrintStream getOutputStream() {
        return this.outStream_;
    }

    public PrintStream getErrorStream() {
        return this.outStream_;
    }

    public StarTableFactory getTableFactory() {
        return this.tableFactory_;
    }

    public StarTableOutput getTableOutput() {
        return this.tableOutput_;
    }

    public JDBCAuthenticator getJdbcAuthenticator() {
        return this.jdbcAuth_;
    }

    public boolean isDebug() {
        return this.debug_;
    }

    public void setDebug(boolean debug) {
        this.debug_ = debug;
    }

    public boolean isStrictVotable() {
        return this.strictVot_;
    }

    public void setStrictVotable(boolean strictVot) {
        this.strictVot_ = strictVot;
    }

    public boolean isHelp() {
        if (this.paramMap_.isEmpty()) {
            return true;
        }
        Iterator it = this.paramMap_.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.equalsIgnoreCase("help") && !key.equalsIgnoreCase("-help")) continue;
            return true;
        }
        return false;
    }

    private class ServletPainter
    implements Painter {
        private final GraphicExporter exporter_;

        ServletPainter(GraphicExporter exporter) {
            this.exporter_ = exporter;
        }

        public void paintPlot(JComponent plot) throws IOException {
            ServletEnvironment.this.response_.setContentType(this.exporter_.getMimeType());
            String encoding = this.exporter_.getContentEncoding();
            if (encoding != null && ServletEnvironment.this.response_ instanceof HttpServletResponse) {
                ((HttpServletResponse)ServletEnvironment.this.response_).setHeader("Content-Encoding", encoding);
            }
            if (ServletEnvironment.this.response_ instanceof HttpServletResponse) {
                HttpServletResponse hr = (HttpServletResponse)ServletEnvironment.this.response_;
                hr.setStatus(200);
            }
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)ServletEnvironment.this.response_.getOutputStream());
            this.exporter_.exportGraphic(plot, out);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
    }

    private class ServletTableConsumer
    implements TableConsumer {
        private final StarTableWriter tableWriter_;

        ServletTableConsumer(StarTableWriter tableWriter) {
            this.tableWriter_ = tableWriter;
        }

        public void consume(StarTable table) throws IOException {
            ServletEnvironment.this.response_.setContentType(this.tableWriter_.getMimeType());
            if (ServletEnvironment.this.response_ instanceof HttpServletResponse) {
                HttpServletResponse hr = (HttpServletResponse)ServletEnvironment.this.response_;
                hr.setStatus(200);
            }
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)ServletEnvironment.this.response_.getOutputStream());
            this.tableWriter_.writeStarTable(table, (OutputStream)out);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
    }
}

