/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import uk.ac.starlink.table.jdbc.JDBCUtils;
import uk.ac.starlink.task.BooleanParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Executable;
import uk.ac.starlink.task.MultiParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.ParameterValueException;
import uk.ac.starlink.task.Task;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.jel.JELUtils;
import uk.ac.starlink.ttools.jel.ResultSetJELRowReader;
import uk.ac.starlink.ttools.task.ConnectionParameter;

public class SqlUpdate
implements Task {
    private final ConnectionParameter connParam_ = new ConnectionParameter("db");
    private final Parameter selectParam_ = new Parameter("select");
    private final AssignParameter assignParam_;
    private final BooleanParameter progressParam_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.task");
    private static final char[] SPINNER = new char[]{'|', '/', '-', '\\'};
    private static final int INTERVAL = 500;

    public SqlUpdate() {
        this.selectParam_.setUsage("<select-stmt>");
        this.selectParam_.setPrompt("SELECT statement");
        this.selectParam_.setDescription(new String[]{"<p>Gives the full text (including \"<code>SELECT</code>\")", "of the SELECT statement to identify which rows undergo", "updates.", "</p>"});
        this.assignParam_ = new AssignParameter("assign");
        this.assignParam_.setPrompt("col=expr assignment(s)");
        this.assignParam_.setUsage("<col>=<expr>");
        this.assignParam_.setDescription(new String[]{"<p>Assigns new values for a given column.", "The assignment is made in the form", "<code>&lt;colname&gt;=&lt;expr&gt;</code>", "where <code>&lt;colname&gt;</code> is the name of a column", "in the SQL table and", "<code>&lt;expr&gt;</code> is the text of an expression using", "STILTS's expression language, as described in <ref id='jel'/>.", "SQL table column names or $ID", "identifiers may be used as variables in the usual way.", "</p>", "<p>This parameter may be supplied more than once to effect", "multiple assignments, or multiple assignments may be made", "by separating them with semicolons in the value of this", "parameter.", "</p>"});
        this.progressParam_ = new BooleanParameter("progress");
        this.progressParam_.setDefault("true");
        this.progressParam_.setPrompt("Display progress on console?");
        this.progressParam_.setDescription(new String[]{"<p>If true, a spinner will be drawn on standard error", "which shows how many rows have been updated so far.", "</p>"});
    }

    public String getPurpose() {
        return "Updates values in an SQL table";
    }

    public Parameter[] getParameters() {
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add((Object)this.connParam_);
        paramList.addAll(Arrays.asList(this.connParam_.getAssociatedParameters()));
        paramList.add(this.selectParam_);
        paramList.add((Object)this.assignParam_);
        paramList.add(this.progressParam_);
        return paramList.toArray(new Parameter[0]);
    }

    public Executable createExecutable(Environment env) throws TaskException {
        final Connection connection = this.connParam_.connectionValue(env);
        final String select = this.selectParam_.stringValue(env);
        final Assignment[] assigns = this.assignParam_.assignmentsValue(env);
        boolean progress = this.progressParam_.booleanValue(env);
        final PrintStream progStrm = progress ? env.getErrorStream() : null;
        return new Executable(){

            public void execute() throws IOException, TaskException {
                try {
                    SqlUpdate.sqlUpdates(connection, select, assigns, progStrm);
                }
                catch (SQLException e) {
                    throw (IOException)new IOException(e.getMessage()).initCause(e);
                }
            }
        };
    }

    private static void sqlUpdates(Connection connection, String select, Assignment[] assigns, PrintStream progStrm) throws SQLException, TaskException {
        Statement stmt = JDBCUtils.createStreamingStatement((Connection)connection, (boolean)true);
        SqlUpdate.logWarnings(connection.getWarnings());
        connection.clearWarnings();
        if (stmt.getResultSetConcurrency() != 1008) {
            logger_.warning("JDBC driver apparently does not provide updatable statements");
        }
        ResultSet rset = stmt.executeQuery(select);
        SqlUpdate.logWarnings(stmt.getWarnings());
        stmt.clearWarnings();
        if (rset.getConcurrency() != 1008) {
            logger_.warning("JDBC driver apparently does not provide updatable ResultSet");
        }
        ResultSetJELRowReader jelly = new ResultSetJELRowReader(rset);
        Library lib = JELUtils.getLibrary(jelly);
        int nassign = assigns.length;
        int[] iacols = new int[nassign];
        CompiledExpression[] acompexs = new CompiledExpression[nassign];
        for (int ia = 0; ia < nassign; ++ia) {
            iacols[ia] = rset.findColumn(assigns[ia].getName());
            String expr = assigns[ia].getExpression();
            try {
                acompexs[ia] = Evaluator.compile((String)expr, (Library)lib);
                continue;
            }
            catch (CompilationException e) {
                throw (TaskException)new TaskException("Error parsing \"" + expr + "\": " + e.getMessage()).initCause((Throwable)e);
            }
        }
        long alarm = System.currentTimeMillis() + 500L;
        long irow = 0L;
        int progCount = 0;
        while (rset.next()) {
            long now;
            for (int ia = 0; ia < nassign; ++ia) {
                Object val;
                CompiledExpression compex = acompexs[ia];
                try {
                    val = jelly.evaluate(compex);
                }
                catch (Throwable e) {
                    throw (TaskException)new TaskException("Error evaluating \"" + assigns[ia].getExpression() + "\": " + e.getMessage()).initCause(e);
                }
                rset.updateObject(iacols[ia], val);
            }
            rset.updateRow();
            if (progStrm == null || (now = System.currentTimeMillis()) <= alarm) continue;
            alarm = now + 500L;
            StringBuffer sbuf = new StringBuffer().append('\r').append(SPINNER[progCount % SPINNER.length]).append(' ').append(irow + 1L).append('\r');
            ++progCount;
            progStrm.print(sbuf.toString());
        }
        rset.close();
        stmt.close();
        connection.close();
    }

    private static void logWarnings(SQLWarning warnings) {
        while (warnings != null) {
            logger_.warning(warnings.toString());
            warnings = warnings.getNextWarning();
        }
    }

    private static class Assignment {
        private final String name_;
        private final String expr_;

        public Assignment(String name, String expr) {
            this.name_ = name;
            this.expr_ = expr;
        }

        public String getName() {
            return this.name_;
        }

        public String getExpression() {
            return this.expr_;
        }
    }

    private static class AssignParameter
    extends Parameter
    implements MultiParameter {
        private Assignment[] assigns_;

        public AssignParameter(String name) {
            super(name);
            this.setUsage("<name>=<value>");
            this.setNullPermitted(false);
        }

        public char getValueSeparator() {
            return ';';
        }

        public void setValueFromString(Environment env, String sval) throws TaskException {
            this.assigns_ = sval == null ? new Assignment[]{} : this.parseAssignments(sval);
            super.setValueFromString(env, sval);
        }

        public Assignment[] assignmentsValue(Environment env) throws TaskException {
            this.checkGotValue(env);
            return this.assigns_;
        }

        private Assignment[] parseAssignments(String sval) throws TaskException {
            String[] lines = sval.split(new String(new char[]{this.getValueSeparator()}));
            Assignment[] assigns = new Assignment[lines.length];
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                int ieq = line.indexOf(61);
                if (ieq <= 0) {
                    String msg = "No \"=\" character in assignment \"" + line + "\"";
                    throw new ParameterValueException((Parameter)this, msg);
                }
                assigns[i] = new Assignment(line.substring(0, ieq).trim(), line.substring(ieq + 1).trim());
            }
            return assigns;
        }
    }
}

