/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import java.util.ArrayList;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.IntegerParameter;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;
import uk.ac.starlink.ttools.filter.ProcessingStep;
import uk.ac.starlink.ttools.mode.ProcessingMode;
import uk.ac.starlink.ttools.task.FilterParameter;
import uk.ac.starlink.ttools.task.InputFormatParameter;
import uk.ac.starlink.ttools.task.InputTableParameter;
import uk.ac.starlink.ttools.task.InputTableSpec;
import uk.ac.starlink.ttools.task.MapperTask;
import uk.ac.starlink.ttools.task.TableMapper;

public class VariableMapperTask
extends MapperTask {
    private final IntegerParameter ninParam_;
    private boolean useInFilters_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public VariableMapperTask(String purpose, ProcessingMode outMode, boolean useOutFilter, TableMapper mapper, boolean useInFilters) {
        super(purpose, outMode, useOutFilter, mapper);
        FilterParameter filterParam;
        this.useInFilters_ = useInFilters;
        ArrayList<Object> paramList = new ArrayList<Object>();
        String numLabel = "N";
        InputTableParameter inParam = VariableMapperTask.createInputParameter(numLabel);
        paramList.add(inParam.getFormatParameter());
        paramList.add((Object)inParam);
        if (useInFilters) {
            filterParam = VariableMapperTask.getFilterParameter(numLabel);
            paramList.add(filterParam);
        } else {
            filterParam = null;
        }
        Parameter[] inParams = paramList.toArray(new Parameter[0]);
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < inParams.length; ++i) {
            String pName = inParams[i].getName();
            if (!$assertionsDisabled && !pName.endsWith(numLabel)) {
                throw new AssertionError();
            }
            if (i > 0) {
                sbuf.append(i == inParams.length - 1 ? " and " : ", ");
            }
            sbuf.append("<code>").append(pName).append("</code>");
        }
        String inParamListing = sbuf.toString();
        this.ninParam_ = new IntegerParameter("nin");
        this.ninParam_.setMinimum(1);
        this.ninParam_.setUsage("<count>");
        this.ninParam_.setPrompt("Number of input tables");
        this.ninParam_.setDescription(new String[]{"<p>The number of input tables for this task.", "For each of the input tables " + numLabel, "there will be associated parameters", inParamListing + ".", "</p>"});
        paramList.add(0, this.ninParam_);
        this.getParameterList().addAll(0, paramList);
    }

    protected InputTableSpec[] getInputSpecs(Environment env) throws TaskException {
        int nin = this.ninParam_.intValue(env);
        InputTableSpec[] inSpecs = new InputTableSpec[nin];
        for (int i = 0; i < nin; ++i) {
            String label = String.valueOf(i + 1);
            InputTableParameter inParam = VariableMapperTask.createInputParameter(label);
            StarTable table = inParam.tableValue(env);
            String tName = inParam.stringValue(env);
            ProcessingStep[] steps = this.useInFilters_ ? VariableMapperTask.getFilterParameter(label).stepsValue(env) : null;
            inSpecs[i] = InputTableSpec.createSpec(tName, steps, table);
        }
        return inSpecs;
    }

    private static InputTableParameter createInputParameter(String label) {
        InputTableParameter inParam = new InputTableParameter("in" + label);
        inParam.setUsage("<table" + label + ">");
        inParam.setPrompt("Location of input table " + label);
        inParam.setDescription(inParam.getDescription().replaceFirst("the input table", "input table #" + label));
        InputFormatParameter fmtParam = inParam.getFormatParameter();
        fmtParam.setDescription(fmtParam.getDescription().replaceFirst("the input table", "input table #" + label));
        return inParam;
    }

    private static FilterParameter getFilterParameter(String label) {
        FilterParameter filterParam = new FilterParameter("icmd" + label);
        filterParam.setPrompt("Processing command(s) for input table " + label);
        filterParam.setDescription(new String[]{"<p>Commands to operate on input table #" + label + ",", "before any other processing takes place.", "</p>", filterParam.getDescription()});
        return filterParam;
    }

    static {
        $assertionsDisabled = !VariableMapperTask.class.desiredAssertionStatus();
    }
}

